/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc.kilo;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.httprpc.kilo.WebService;
import org.httprpc.kilo.io.JSONEncoder;
import org.httprpc.kilo.io.TemplateEncoder;
import org.httprpc.kilo.util.Collections;

@WebServlet(urlPatterns={""}, loadOnStartup=1)
public class IndexServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<WebService.ServiceDescriptor> serviceDescriptors = WebService.getServiceDescriptors();
        String accept = request.getHeader("Accept");
        if (accept != null && accept.equalsIgnoreCase("application/json")) {
            response.setContentType(String.format("%s;charset=%s", "application/json", StandardCharsets.UTF_8));
            JSONEncoder jsonEncoder = new JSONEncoder();
            jsonEncoder.write(serviceDescriptors, (OutputStream)response.getOutputStream());
        } else {
            response.setContentType(String.format("%s;charset=%s", "text/html", StandardCharsets.UTF_8));
            TemplateEncoder templateEncoder = new TemplateEncoder(IndexServlet.class, "index.html");
            templateEncoder.setResourceBundle(ResourceBundle.getBundle(IndexServlet.class.getName(), request.getLocale()));
            templateEncoder.write((Object)Collections.mapOf((Map.Entry[])new Map.Entry[]{Collections.entry((Object)"contextPath", (Object)request.getContextPath()), Collections.entry((Object)"services", serviceDescriptors)}), (OutputStream)response.getOutputStream());
        }
    }
}

