/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc.kilo;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.httprpc.kilo.Creates;
import org.httprpc.kilo.Description;
import org.httprpc.kilo.Name;
import org.httprpc.kilo.RequestMethod;
import org.httprpc.kilo.Required;
import org.httprpc.kilo.ResourcePath;
import org.httprpc.kilo.beans.BeanAdapter;
import org.httprpc.kilo.io.JSONDecoder;
import org.httprpc.kilo.io.JSONEncoder;
import org.httprpc.kilo.io.TemplateEncoder;
import org.httprpc.kilo.util.Collections;
import org.httprpc.kilo.util.Optionals;

public abstract class WebService
extends HttpServlet {
    private Resource root = null;
    private ServiceDescriptor serviceDescriptor = null;
    private static final Map<Class<? extends WebService>, WebService> instances = new HashMap<Class<? extends WebService>, WebService>();
    private static final Comparator<Method> methodNameComparator = Comparator.comparing(Method::getName);
    private static final Comparator<Method> methodParameterCountComparator = Comparator.comparing(Method::getParameterCount);
    private static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> response = new ThreadLocal();
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String TEXT_CSV = "text/csv";
    protected static final String TEXT_HTML = "text/html";
    protected static final String TEXT_XML = "text/xml";
    protected static final String TEXT_PLAIN = "text/plain";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";

    public static synchronized <T extends WebService> T getInstance(Class<T> type) {
        return (T)((Object)instances.get(type));
    }

    public static synchronized List<ServiceDescriptor> getServiceDescriptors() {
        return instances.values().stream().map(WebService::getServiceDescriptor).sorted(Comparator.comparing(ServiceDescriptor::getPath)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Class<?> type = ((Object)((Object)this)).getClass();
        WebServlet webServlet = type.getAnnotation(WebServlet.class);
        if (webServlet == null) {
            throw new ServletException("Web servlet annotation is required.");
        }
        String[] urlPatterns = webServlet.urlPatterns();
        if (urlPatterns.length == 0) {
            throw new ServletException("At least one URL pattern is required.");
        }
        String path = urlPatterns[0];
        if (!path.startsWith("/") || !path.endsWith("/*")) {
            throw new ServletException("Invalid URL pattern.");
        }
        path = path.substring(0, path.length() - 2);
        this.root = WebService.index(type.getMethods());
        this.serviceDescriptor = new ServiceDescriptor(path, type);
        this.describeResource(path, this.root);
        Class<WebService> clazz = WebService.class;
        synchronized (WebService.class) {
            instances.put(type, this);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static Resource index(Method[] methods) throws ServletException {
        Resource root = new Resource();
        for (int i = 0; i < methods.length; ++i) {
            Method handler = methods[i];
            RequestMethod requestMethod = handler.getAnnotation(RequestMethod.class);
            if (requestMethod == null) continue;
            String method = requestMethod.value().toUpperCase();
            Resource resource = root;
            ResourcePath resourcePath = handler.getAnnotation(ResourcePath.class);
            if (resourcePath != null) {
                String[] components = resourcePath.value().split("/");
                for (int j = 0; j < components.length; ++j) {
                    String component = components[j];
                    if (component.isEmpty()) {
                        throw new ServletException("Invalid resource path.");
                    }
                    resource = resource.resources.computeIfAbsent(component, key -> new Resource());
                }
            }
            resource.handlerMap.computeIfAbsent(method, key -> new LinkedList()).add(handler);
        }
        WebService.sort(root);
        return root;
    }

    private static void sort(Resource root) {
        for (List<Method> handlers : root.handlerMap.values()) {
            handlers.sort(methodNameComparator.thenComparing(methodParameterCountComparator.reversed()));
        }
        for (Resource resource : root.resources.values()) {
            WebService.sort(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object result;
        Object[] arguments;
        List<Method> handlerList;
        String api;
        String method = request.getMethod().toUpperCase();
        String pathInfo = request.getPathInfo();
        if (method.equals("GET") && pathInfo == null && (api = request.getParameter("api")) != null) {
            String accept = request.getHeader("Accept");
            if (accept != null && accept.equalsIgnoreCase(APPLICATION_JSON)) {
                response.setContentType(String.format("%s;charset=%s", APPLICATION_JSON, StandardCharsets.UTF_8));
                JSONEncoder jsonEncoder = new JSONEncoder();
                jsonEncoder.write((Object)this.serviceDescriptor, (OutputStream)response.getOutputStream());
            } else {
                response.setContentType(String.format("%s;charset=%s", TEXT_HTML, StandardCharsets.UTF_8));
                TemplateEncoder templateEncoder = new TemplateEncoder(WebService.class, "api.html");
                templateEncoder.setResourceBundle(ResourceBundle.getBundle(WebService.class.getName(), request.getLocale()));
                templateEncoder.write((Object)Collections.mapOf((Map.Entry[])new Map.Entry[]{Collections.entry((Object)"contextPath", (Object)request.getContextPath()), Collections.entry((Object)"service", (Object)this.serviceDescriptor)}), (OutputStream)response.getOutputStream());
            }
            return;
        }
        Resource resource = this.root;
        ArrayList<String> keys = new ArrayList<String>();
        if (pathInfo != null) {
            String[] components = pathInfo.split("/");
            for (int i = 1; i < components.length; ++i) {
                String component = components[i];
                Resource child = resource.resources.get(component);
                if (child == null) {
                    child = resource.resources.get("?");
                    if (child == null) {
                        super.service(request, response);
                        return;
                    }
                    keys.add(component);
                }
                resource = child;
            }
        }
        if ((handlerList = resource.handlerMap.get(method)) == null) {
            super.service(request, response);
            return;
        }
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        }
        HashMap argumentMap = new HashMap();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            argumentMap.put(name, Arrays.asList(request.getParameterValues(name)));
        }
        String contentType = (String)Optionals.map((Object)request.getContentType(), String::toLowerCase);
        if (contentType != null && contentType.startsWith(MULTIPART_FORM_DATA)) {
            for (Part part : request.getParts()) {
                String submittedFileName = part.getSubmittedFileName();
                if (submittedFileName == null || submittedFileName.isEmpty()) continue;
                String name = part.getName();
                ArrayList<Part> values = (ArrayList<Part>)argumentMap.get(name);
                if (values == null) {
                    values = new ArrayList<Part>();
                    argumentMap.put(name, values);
                }
                values.add(part);
            }
        }
        boolean empty = contentType == null || contentType.startsWith(APPLICATION_X_WWW_FORM_URLENCODED) || contentType.startsWith(MULTIPART_FORM_DATA);
        Method handler = WebService.getHandler(handlerList, keys.size(), argumentMap.keySet(), empty);
        if (handler == null) {
            response.setStatus(405);
            return;
        }
        try {
            arguments = this.getArguments(handler.getParameters(), keys, argumentMap, empty, request);
        }
        catch (Exception exception) {
            response.setStatus(403);
            this.reportError(response, exception);
            return;
        }
        WebService.request.set(request);
        WebService.response.set(response);
        try {
            result = handler.invoke((Object)this, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (response.isCommitted()) {
                if (cause != null) {
                    this.log(cause.getMessage(), cause);
                }
                return;
            }
            int status = cause instanceof IllegalArgumentException || cause instanceof UnsupportedOperationException ? 403 : (cause instanceof NoSuchElementException ? 404 : (cause instanceof IllegalStateException ? 409 : 500));
            response.setStatus(status);
            this.reportError(response, cause);
            return;
        }
        finally {
            WebService.request.remove();
            WebService.response.remove();
        }
        if (response.isCommitted()) {
            return;
        }
        if (result != null) {
            if (handler.getAnnotation(Creates.class) != null) {
                response.setStatus(201);
            }
            try {
                this.encodeResult(request, response, result);
            }
            catch (Exception exception) {
                this.log(exception.getMessage(), exception);
            }
        } else {
            Class<?> returnType = handler.getReturnType();
            if (returnType == Void.TYPE || returnType == Void.class) {
                response.setStatus(204);
            } else {
                response.setStatus(404);
            }
        }
    }

    private static Method getHandler(List<Method> handlerList, int keyCount, Set<String> argumentNames, boolean empty) {
        for (Method handler : handlerList) {
            Parameter[] parameters = handler.getParameters();
            int n = parameters.length;
            if (!empty) {
                --n;
            }
            if (keyCount > n) continue;
            if (argumentNames.isEmpty()) {
                return handler;
            }
            int c = 0;
            int argumentCount = argumentNames.size();
            for (int i = keyCount; i < n; ++i) {
                Parameter parameter = parameters[i];
                String name = (String)Optionals.coalesce((Object[])new String[]{(String)Optionals.map((Object)parameter.getAnnotation(Name.class), Name::value), parameter.getName()});
                if (!argumentNames.contains(name) || ++c != argumentCount) continue;
                return handler;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] getArguments(Parameter[] parameters, List<String> keys, Map<String, List<?>> argumentMap, boolean empty, HttpServletRequest request) {
        Object body;
        int n = parameters.length;
        Object[] arguments = new Object[n];
        if (!empty) {
            --n;
        }
        int keyCount = keys.size();
        for (int i = 0; i < n; ++i) {
            Object argument;
            Parameter parameter = parameters[i];
            if (i < keyCount) {
                arguments[i] = BeanAdapter.coerce((Object)keys.get(i), parameter.getType());
                continue;
            }
            String name = (String)Optionals.coalesce((Object[])new String[]{(String)Optionals.map((Object)parameter.getAnnotation(Name.class), Name::value), parameter.getName()});
            Class<?> type = parameter.getType();
            List<?> values = argumentMap.get(name);
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (values != null) {
                    argument = Array.newInstance(componentType, values.size());
                    int j = 0;
                    for (Object value : values) {
                        Array.set(argument, j++, BeanAdapter.coerce(value, componentType));
                    }
                } else {
                    argument = Array.newInstance(componentType, 0);
                }
            } else if (Collection.class.isAssignableFrom(type)) {
                Type elementType = ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0];
                if (!(elementType instanceof Class)) throw new UnsupportedOperationException("Invalid element type.");
                if (type == List.class) {
                    argument = values == null ? Collections.listOf((Object[])new Object[0]) : BeanAdapter.coerceList(values, (Class)((Class)elementType));
                } else {
                    if (type != Set.class) throw new UnsupportedOperationException("Unsupported collection type.");
                    argument = values == null ? Collections.setOf((Object[])new Object[0]) : BeanAdapter.coerceSet(values, (Class)((Class)elementType));
                }
            } else {
                Object value = values != null ? values.get(values.size() - 1) : null;
                if (parameter.getAnnotation(Required.class) != null && value == null) {
                    throw new IllegalArgumentException("Required argument is not defined.");
                }
                argument = BeanAdapter.coerce(value, type);
            }
            arguments[i] = argument;
        }
        if (n >= parameters.length) return arguments;
        Type type = parameters[n].getParameterizedType();
        if (type == Void.class) {
            body = null;
        } else {
            try {
                body = this.decodeBody(request, type);
            }
            catch (IOException exception) {
                throw new UnsupportedOperationException(exception);
            }
        }
        arguments[n] = body;
        return arguments;
    }

    protected static HttpServletRequest getRequest() {
        return request.get();
    }

    protected static HttpServletResponse getResponse() {
        return response.get();
    }

    protected Object decodeBody(HttpServletRequest request, Type type) throws IOException {
        JSONDecoder jsonDecoder = new JSONDecoder(type);
        return jsonDecoder.read((InputStream)request.getInputStream());
    }

    protected void encodeResult(HttpServletRequest request, HttpServletResponse response, Object result) throws IOException {
        response.setContentType(String.format("%s;charset=%s", APPLICATION_JSON, StandardCharsets.UTF_8));
        JSONEncoder jsonEncoder = new JSONEncoder();
        jsonEncoder.write(result, (OutputStream)response.getOutputStream());
    }

    protected void reportError(HttpServletResponse response, Throwable cause) throws IOException {
        String message;
        response.setContentType(String.format("%s;charset=%s", TEXT_PLAIN, StandardCharsets.UTF_8));
        if (cause != null && (message = cause.getMessage()) != null) {
            response.getWriter().append(message);
        }
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    private void describeResource(String path, Resource resource) {
        if (!resource.handlerMap.isEmpty()) {
            EndpointDescriptor endpoint = new EndpointDescriptor(path);
            for (Map.Entry<String, List<Method>> entry : resource.handlerMap.entrySet()) {
                for (Method handler : entry.getValue()) {
                    OperationDescriptor operation = new OperationDescriptor(entry.getKey().toUpperCase(), handler);
                    operation.deprecated |= this.serviceDescriptor.deprecated;
                    operation.produces = this.describeGenericType(handler.getGenericReturnType());
                    Parameter[] parameters = handler.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        Parameter parameter = parameters[i];
                        VariableDescriptor parameterDescriptor = new VariableDescriptor(parameter);
                        parameterDescriptor.type = this.describeGenericType(parameter.getParameterizedType());
                        operation.parameters.add(parameterDescriptor);
                    }
                    endpoint.operations.add(operation);
                }
            }
            this.serviceDescriptor.endpoints.add(endpoint);
        }
        for (Map.Entry<String, Resource> entry : resource.resources.entrySet()) {
            this.describeResource(String.format("%s/%s", path, entry.getKey()), entry.getValue());
        }
    }

    private TypeDescriptor describeGenericType(Type type) {
        if (type instanceof Class) {
            return this.describeRawType((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (Iterable.class.isAssignableFrom(rawType)) {
                return new IterableTypeDescriptor(this.describeGenericType(actualTypeArguments[0]));
            }
            if (Map.class.isAssignableFrom(rawType)) {
                return new MapTypeDescriptor(this.describeGenericType(actualTypeArguments[0]), this.describeGenericType(actualTypeArguments[1]));
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private TypeDescriptor describeRawType(Class<?> type) {
        block12: {
            block11: {
                if (type.isPrimitive() || type == Object.class || type == Boolean.class || Number.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || type == Void.class || Date.class.isAssignableFrom(type) || type == Instant.class || type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class || type == Duration.class || type == Period.class || type == UUID.class || type == URI.class || type == Path.class || type == Part.class) {
                    return new TypeDescriptor(type, true);
                }
                if (type.isArray()) {
                    return new IterableTypeDescriptor(this.describeRawType(type.getComponentType()));
                }
                if (Iterable.class.isAssignableFrom(type)) {
                    return new IterableTypeDescriptor(this.describeRawType(Object.class));
                }
                if (Map.class.isAssignableFrom(type)) {
                    return new MapTypeDescriptor(this.describeRawType(Object.class), this.describeRawType(Object.class));
                }
                if (!type.isEnum()) break block11;
                EnumerationDescriptor enumeration = this.serviceDescriptor.enumerations.get(type);
                if (enumeration != null) break block12;
                enumeration = new EnumerationDescriptor(type);
                this.serviceDescriptor.enumerations.put(type, enumeration);
                Field[] fields = type.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (!field.isEnumConstant()) continue;
                    enumeration.values.add(new ConstantDescriptor(field));
                }
                break block12;
            }
            StructureDescriptor structure = this.serviceDescriptor.structures.get(type);
            if (structure == null) {
                structure = new StructureDescriptor(type);
                this.serviceDescriptor.structures.put(type, structure);
                if (type.isInterface()) {
                    Class<?>[] interfaces = type.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        structure.supertypes.add(this.describeRawType(interfaces[i]));
                    }
                } else {
                    Class<?> baseType = type.getSuperclass();
                    if (baseType != Object.class && baseType != Record.class) {
                        structure.supertypes.add(this.describeRawType(baseType));
                    }
                }
                for (Map.Entry entry : BeanAdapter.getProperties(type).entrySet()) {
                    Method accessor = ((BeanAdapter.Property)entry.getValue()).getAccessor();
                    if (accessor.getDeclaringClass() != type) continue;
                    VariableDescriptor propertyDescriptor = new VariableDescriptor((String)entry.getKey(), accessor);
                    propertyDescriptor.type = this.describeGenericType(accessor.getGenericReturnType());
                    structure.properties.add(propertyDescriptor);
                }
            }
        }
        return new TypeDescriptor(type, false);
    }

    private static String getTypeName(Class<?> type) {
        return type.getCanonicalName().substring(type.getPackageName().length() + 1);
    }

    private static class Resource {
        Map<String, Resource> resources = new TreeMap<String, Resource>();
        Map<String, List<Method>> handlerMap = new TreeMap<String, List<Method>>((method1, method2) -> {
            int i1 = methodOrder.indexOf(method1);
            int i2 = methodOrder.indexOf(method2);
            return Integer.compare(i1 == -1 ? methodOrder.size() : i1, i2 == -1 ? methodOrder.size() : i2);
        });
        static final List<String> methodOrder = Collections.immutableListOf((Object[])new String[]{"GET", "POST", "PUT", "DELETE"});

        private Resource() {
        }
    }

    public static class ServiceDescriptor {
        private String path;
        private String description;
        private boolean deprecated;
        private List<EndpointDescriptor> endpoints = new LinkedList<EndpointDescriptor>();
        private Map<Class<?>, EnumerationDescriptor> enumerations = new TreeMap<Class, EnumerationDescriptor>(Comparator.comparing(WebService::getTypeName));
        private Map<Class<?>, StructureDescriptor> structures = new TreeMap<Class, StructureDescriptor>(Comparator.comparing(WebService::getTypeName));

        private ServiceDescriptor(String path, Class<? extends WebService> type) {
            this.path = path;
            this.description = (String)Optionals.map((Object)type.getAnnotation(Description.class), Description::value);
            this.deprecated = type.getAnnotation(Deprecated.class) != null;
        }

        public String getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public List<EndpointDescriptor> getEndpoints() {
            return this.endpoints;
        }

        public List<EnumerationDescriptor> getEnumerations() {
            return new ArrayList<EnumerationDescriptor>(this.enumerations.values());
        }

        public List<StructureDescriptor> getStructures() {
            return new ArrayList<StructureDescriptor>(this.structures.values());
        }
    }

    public static class EndpointDescriptor {
        private String path;
        private List<OperationDescriptor> operations = new LinkedList<OperationDescriptor>();

        private EndpointDescriptor(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public List<OperationDescriptor> getOperations() {
            return this.operations;
        }
    }

    public static class OperationDescriptor {
        private String method;
        private String description;
        private boolean deprecated;
        private TypeDescriptor produces = null;
        private List<VariableDescriptor> parameters = new LinkedList<VariableDescriptor>();

        private OperationDescriptor(String method, Method handler) {
            this.method = method;
            this.description = (String)Optionals.map((Object)handler.getAnnotation(Description.class), Description::value);
            this.deprecated = handler.getAnnotation(Deprecated.class) != null;
        }

        public String getMethod() {
            return this.method;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public TypeDescriptor getProduces() {
            return this.produces;
        }

        public List<VariableDescriptor> getParameters() {
            return this.parameters;
        }
    }

    public static class TypeDescriptor {
        private Class<?> type;
        private boolean intrinsic;

        private TypeDescriptor(Class<?> type, boolean intrinsic) {
            this.type = type;
            this.intrinsic = intrinsic;
        }

        public String getName() {
            if (this.type.isPrimitive()) {
                return this.type.getName();
            }
            return WebService.getTypeName(this.type);
        }

        public boolean isIntrinsic() {
            return this.intrinsic;
        }

        public boolean isIterable() {
            return false;
        }

        public TypeDescriptor getElementType() {
            return null;
        }

        public boolean isMap() {
            return false;
        }

        public TypeDescriptor getKeyType() {
            return null;
        }

        public TypeDescriptor getValueType() {
            return null;
        }
    }

    public static class VariableDescriptor {
        private String name;
        private String description;
        private boolean required;
        private TypeDescriptor type = null;

        private VariableDescriptor(Parameter parameter) {
            this.name = (String)Optionals.coalesce((Object[])new String[]{(String)Optionals.map((Object)parameter.getAnnotation(Name.class), Name::value), parameter.getName()});
            this.description = (String)Optionals.map((Object)parameter.getAnnotation(Description.class), Description::value);
            this.required = parameter.getAnnotation(Required.class) != null;
        }

        private VariableDescriptor(String name, Method accessor) {
            this.name = name;
            this.description = (String)Optionals.map((Object)accessor.getAnnotation(Description.class), Description::value);
            this.required = accessor.getAnnotation(Required.class) != null;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public TypeDescriptor getType() {
            return this.type;
        }
    }

    public static class IterableTypeDescriptor
    extends TypeDescriptor {
        private TypeDescriptor elementType;

        private IterableTypeDescriptor(TypeDescriptor elementType) {
            super(Iterable.class, true);
            this.elementType = elementType;
        }

        @Override
        public boolean isIterable() {
            return true;
        }

        @Override
        public TypeDescriptor getElementType() {
            return this.elementType;
        }
    }

    public static class MapTypeDescriptor
    extends TypeDescriptor {
        private TypeDescriptor keyType;
        private TypeDescriptor valueType;

        private MapTypeDescriptor(TypeDescriptor keyType, TypeDescriptor valueType) {
            super(Map.class, true);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public TypeDescriptor getKeyType() {
            return this.keyType;
        }

        @Override
        public TypeDescriptor getValueType() {
            return this.valueType;
        }
    }

    public static class EnumerationDescriptor {
        private String name;
        private String description;
        private List<ConstantDescriptor> values = new LinkedList<ConstantDescriptor>();

        private EnumerationDescriptor(Class<?> type) {
            this.name = WebService.getTypeName(type);
            this.description = (String)Optionals.map((Object)type.getAnnotation(Description.class), Description::value);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<ConstantDescriptor> getValues() {
            return this.values;
        }
    }

    public static class ConstantDescriptor {
        private String name;
        private String description;

        private ConstantDescriptor(Field field) {
            Object constant;
            try {
                constant = field.get(null);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            this.name = constant.toString();
            this.description = (String)Optionals.map((Object)field.getAnnotation(Description.class), Description::value);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class StructureDescriptor {
        private String name;
        private String description;
        private List<TypeDescriptor> supertypes = new LinkedList<TypeDescriptor>();
        private List<VariableDescriptor> properties = new LinkedList<VariableDescriptor>();

        private StructureDescriptor(Class<?> type) {
            this.name = WebService.getTypeName(type);
            this.description = (String)Optionals.map((Object)type.getAnnotation(Description.class), Description::value);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<TypeDescriptor> getSupertypes() {
            return this.supertypes;
        }

        public List<VariableDescriptor> getProperties() {
            return this.properties;
        }
    }
}

