/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.jdbc;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.huiche.jdbc.DefaultSql;
import org.huiche.jdbc.Executor;
import org.huiche.jdbc.Jdbc;
import org.huiche.jdbc.Sql;
import org.huiche.jdbc.support.JdbcHelper;
import org.huiche.sql.configuration.Configuration;
import org.huiche.sql.connection.ConnectionFactory;
import org.huiche.sql.connection.Isolation;
import org.huiche.sql.dialect.DefaultDialect;
import org.huiche.sql.dialect.Dialect;
import org.huiche.sql.dialect.Translation;
import org.huiche.sql.dsl.statement.Statement;
import org.huiche.sql.exception.HcJdbcException;
import org.huiche.sql.exception.HcSQLException;
import org.huiche.sql.exception.SQLExceptionTranslator;
import org.huiche.sql.listener.Listener;
import org.huiche.sql.mapper.RowMapper;

public record DefaultJdbc(Configuration configuration, Dialect dialect, ConnectionFactory connectionFactory) implements Jdbc,
Executor
{
    private static final Logger LOGGER = Logger.getLogger(DefaultJdbc.class.getName());

    public DefaultJdbc(ConnectionFactory connectionFactory) {
        this(new Configuration(), (Dialect)new DefaultDialect(), connectionFactory);
    }

    public DefaultJdbc(Dialect dialect, ConnectionFactory connectionFactory) {
        this(new Configuration(), dialect, connectionFactory);
    }

    public DefaultJdbc(Configuration configuration, ConnectionFactory connectionFactory) {
        this(configuration, (Dialect)new DefaultDialect(), connectionFactory);
    }

    @Override
    public Sql sql(String sql, List<Object> params) {
        return new DefaultSql(this, sql, params);
    }

    @Override
    public Sql sql(Statement statement) {
        LOGGER.finest(() -> "dsl: " + statement);
        this.configuration().listen(l -> l.onTranslate(statement));
        Translation translation = this.dialect.translateStatement(statement, this.configuration.namingStrategy());
        String sql = translation.sql();
        List params = translation.params();
        this.configuration().listen(l -> l.onTranslateFinish(statement, sql, params));
        return new DefaultSql(this, sql, params);
    }

    @Override
    public void tx(Class<? extends Throwable> rollbackException, Isolation isolation, Runnable runnable) {
        LOGGER.finest(() -> "transaction begin...");
        this.configuration().listen(l -> l.onTransaction(isolation, rollbackException));
        this.connectionFactory.begin(isolation);
        boolean rollback = false;
        try {
            runnable.run();
        }
        catch (Exception e) {
            rollback = true;
            if (rollbackException != null && !rollbackException.isAssignableFrom(e.getClass())) {
                LOGGER.info(() -> "transaction don't need rollback");
                rollback = false;
            }
            throw e;
        }
        finally {
            if (rollback) {
                LOGGER.info(() -> "transaction rollback...");
                this.connectionFactory.rollback();
            } else {
                LOGGER.finest(() -> "transaction commit...");
                this.connectionFactory.commit();
            }
            boolean finalRollback = rollback;
            this.configuration().listen(l -> l.onTransactionFinish(isolation, rollbackException, finalRollback));
        }
    }

    @Override
    public void execute(String sql, List<Object> params, boolean generateKey, Consumer<PreparedStatement> consumer) {
        LOGGER.fine(() -> "sql: " + sql);
        LOGGER.finest(() -> "params: " + params);
        this.configuration().listen(l -> l.onStart(sql, params));
        Connection connection = null;
        boolean success = false;
        try {
            Connection finalConnection = connection = this.connectionFactory.get();
            this.configuration().listen(l -> l.onGetConnection(sql, params, finalConnection));
            try (PreparedStatement ps = generateKey ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql);){
                if (this.configuration.fetchSize() != -1) {
                    ps.setFetchSize(this.configuration.fetchSize());
                }
                if (this.configuration.maxRows() != -1) {
                    ps.setMaxRows(this.configuration.maxRows());
                }
                if (this.configuration.queryTimeout() != null) {
                    ps.setQueryTimeout((int)this.configuration.queryTimeout().toSeconds());
                }
                if (!params.isEmpty()) {
                    ParameterMetaData parameterMetaData = ps.getParameterMetaData();
                    int index = 0;
                    for (Object param : params) {
                        ++index;
                        if (param == null) {
                            ps.setNull(index, parameterMetaData.getParameterType(index));
                            continue;
                        }
                        JdbcHelper.setPsVal(ps, index, param, this.configuration);
                    }
                }
                consumer.accept(ps);
            }
            success = true;
        }
        catch (Exception e) {
            Object re;
            this.configuration().listen(l -> l.onExecuteException(sql, params, e));
            SQLExceptionTranslator exceptionTranslator = this.configuration.exceptionTranslator();
            if (exceptionTranslator != null) {
                if (e instanceof SQLException) {
                    SQLException se = (SQLException)e;
                    re = exceptionTranslator.translate(sql, params, se);
                } else if (e instanceof HcSQLException) {
                    HcSQLException hse = (HcSQLException)e;
                    re = exceptionTranslator.translate(sql, params, hse.getSqlException());
                } else {
                    re = new HcJdbcException(e.getMessage());
                }
            } else {
                HcSQLException hse;
                re = e instanceof HcSQLException ? (hse = (HcSQLException)e) : new HcJdbcException(e.getMessage(), (Throwable)e);
            }
            throw re;
        }
        finally {
            boolean finalSuccess = success;
            this.connectionFactory.release(connection);
            this.configuration().listen(l -> l.onFinish(sql, params, finalSuccess));
        }
    }

    @Override
    public void executeQuery(String sql, List<Object> params, Consumer<ResultSet> consumer) {
        this.configuration().listen(l -> l.onExecute(sql, params, Listener.Type.QUERY));
        this.execute(sql, params, ps -> {
            try (ResultSet rs = ps.executeQuery();){
                this.configuration().listen(l -> l.onExecuteSuccess(sql, params, Listener.Type.QUERY));
                consumer.accept(rs);
            }
            catch (SQLException e) {
                throw new HcSQLException(e);
            }
        });
    }

    @Override
    public void executeQueryAndLoop(String sql, List<Object> params, Consumer<Executor.ResultSetInfo> consumer) {
        this.executeQuery(sql, params, rs -> {
            try {
                int index = 0;
                Map<String, Integer> columnMap = JdbcHelper.columnNameIndexMap(rs.getMetaData(), this.configuration.namingStrategy());
                while (rs.next()) {
                    consumer.accept(new Executor.ResultSetInfo((ResultSet)rs, index++, columnMap));
                }
            }
            catch (SQLException e) {
                throw new HcSQLException(e);
            }
        });
    }

    @Override
    public <C extends Collection<T>, T> C executeQueryCollection(String sql, List<Object> params, RowMapper<T> mapper, C collection) {
        this.executeQueryAndLoop(sql, params, info -> {
            try {
                collection.add(mapper.map(info.rs(), info.rowIndex(), info.columnIndexMap(), this.configuration));
            }
            catch (SQLException e) {
                throw new HcSQLException(e);
            }
        });
        return collection;
    }

    @Override
    public int executeUpdate(String sql, List<Object> params, Consumer<ResultSet> consumer) {
        AtomicInteger count = new AtomicInteger();
        boolean generateKey = consumer != null;
        Listener.Type type = generateKey ? Listener.Type.UPDATE_WITH_GENERATED : Listener.Type.UPDATE;
        this.configuration().listen(l -> l.onExecute(sql, params, type));
        this.execute(sql, params, generateKey, ps -> {
            block8: {
                try {
                    count.set(ps.executeUpdate());
                    this.configuration().listen(l -> l.onExecuteSuccess(sql, params, type));
                    if (!generateKey) break block8;
                    try (ResultSet rs = ps.getGeneratedKeys();){
                        consumer.accept(rs);
                    }
                }
                catch (SQLException e) {
                    throw new HcSQLException(e);
                }
            }
        });
        return count.get();
    }

    @Override
    public int executeUpdateAndLoop(String sql, List<Object> params, Consumer<Executor.ResultSetInfo> consumer) {
        return this.executeUpdate(sql, params, rs -> {
            try {
                Map<String, Integer> columnMap = JdbcHelper.columnNameIndexMap(rs.getMetaData(), this.configuration.namingStrategy());
                int index = 0;
                while (rs.next()) {
                    consumer.accept(new Executor.ResultSetInfo((ResultSet)rs, index++, columnMap));
                }
            }
            catch (SQLException e) {
                throw new HcSQLException(e);
            }
        });
    }
}

