/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.jdbc;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.huiche.jdbc.Executor;
import org.huiche.jdbc.MappedQuery;
import org.huiche.jdbc.Sql;
import org.huiche.jdbc.support.JdbcHelper;
import org.huiche.sql.mapper.RowMapper;

public class DefaultSql
implements Sql {
    private static final Logger LOGGER = Logger.getLogger(DefaultSql.class.getName());
    private final String sql;
    private final List<Object> params;
    private final Executor executor;

    public DefaultSql(Executor executor, String sql, List<Object> params) {
        this.sql = sql;
        this.params = params;
        this.executor = executor;
    }

    @Override
    public void resultSet(Consumer<ResultSet> consumer) {
        this.executor.executeQuery(this.sql, this.params, consumer);
    }

    @Override
    public <T> MappedQuery<T> query(final RowMapper<T> rowMapper) {
        return new MappedQuery<T>(){

            @Override
            public <C extends Collection<T>> C collection(C collection) {
                return DefaultSql.this.executor.executeQueryCollection(DefaultSql.this.sql, DefaultSql.this.params, rowMapper, collection);
            }
        };
    }

    @Override
    public int update() {
        return this.executor.executeUpdate(this.sql, this.params);
    }

    @Override
    public int update(Consumer<List<Map<String, Object>>> keyConsumer) {
        ArrayList keys = new ArrayList();
        int count = this.executor.executeUpdateAndLoop(this.sql, this.params, info -> keys.add(JdbcHelper.resultToMap(info.rs(), this.executor.configuration().namingStrategy())));
        LOGGER.fine(() -> "generateKeys: " + keys);
        keyConsumer.accept(keys);
        return count;
    }

    @Override
    public <T, R> int update(Class<T> keyClass, BiFunction<List<Map<String, Object>>, Class<T>, R> transform, Consumer<R> keyConsumer) {
        return this.update(keys -> keyConsumer.accept(transform.apply((List<Map<String, Object>>)keys, keyClass)));
    }
}

