/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.jdbc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.huiche.jdbc.MappedQuery;
import org.huiche.jdbc.support.JdbcHelper;
import org.huiche.jdbc.support.RowMapperCachingHolder;
import org.huiche.sql.mapper.RowMapper;

public interface Sql {
    public void resultSet(Consumer<ResultSet> var1);

    default public MappedQuery<Map<String, Object>> query() {
        return this.query((rs, rowIndex, columnMap, configuration) -> JdbcHelper.resultToMap(rs, configuration.namingStrategy()));
    }

    default public <T> MappedQuery<T> query(Class<T> targetClass) {
        return this.query(RowMapperCachingHolder.get(targetClass));
    }

    public <T> MappedQuery<T> query(RowMapper<T> var1);

    default public MappedQuery<Object> queryColumn() {
        return this.query((rs, rowIndex, columnMap, configuration) -> rs.getObject(1));
    }

    default public <T> MappedQuery<T> queryColumn(Class<T> columnClass) {
        return this.query((rs, rowIndex, columnMap, configuration) -> JdbcHelper.getRsVal(columnClass, null, rs, 1, configuration));
    }

    default public <T> MappedQuery<T> queryColumn(ParameterizedType parameterizedType) {
        return this.query((rs, rowIndex, columnMap, configuration) -> JdbcHelper.getRsVal((Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments(), rs, 1, configuration));
    }

    default public <T> MappedQuery<T> queryColumn(Class<T> columnClass, Type ... generics) {
        return this.query((rs, rowIndex, columnMap, configuration) -> JdbcHelper.getRsVal(columnClass, generics, rs, 1, configuration));
    }

    public int update();

    public int update(Consumer<List<Map<String, Object>>> var1);

    public <T, R> int update(Class<T> var1, BiFunction<List<Map<String, Object>>, Class<T>, R> var2, Consumer<R> var3);

    default public <T> int update(Class<T> keyClass, Consumer<T> keyConsumer) {
        return this.update(keyClass, JdbcHelper::mappingSingleKey, keyConsumer);
    }

    default public <T> int updateBatchKey(Class<T> keyClass, Consumer<List<T>> keyConsumer) {
        return this.update(keyClass, JdbcHelper::mappingListKey, keyConsumer);
    }
}

