/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.huiche.jdbc.support.JdbcHelper;
import org.huiche.sql.configuration.Configuration;
import org.huiche.sql.exception.HcSQLException;
import org.huiche.sql.mapper.RowMapper;
import org.huiche.sql.support.ColumnInfo;
import org.huiche.sql.support.TableInfo;
import org.huiche.sql.support.TableInfoCachingHolder;

public class EntityRowMapper<T>
implements RowMapper<T> {
    private final TableInfo info;

    public EntityRowMapper(Class<T> clazz) {
        this.info = TableInfoCachingHolder.get(clazz);
    }

    public T map(ResultSet rs, int rowIndex, Map<String, Integer> columnIndexMap, Configuration configuration) {
        HashMap values = new HashMap(this.info.columns().size());
        for (ColumnInfo col : this.info.columns()) {
            Integer index = columnIndexMap.get(col.name());
            if (index == null) {
                values.put(col.name(), null);
                continue;
            }
            try {
                values.put(col.name(), JdbcHelper.getRsVal(col.field().getType(), col.generics(), rs, index, configuration));
            }
            catch (SQLException e) {
                throw new HcSQLException(e);
            }
        }
        return (T)this.info.instanceFunc().apply(values);
    }
}

