/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.jdbc.support;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.huiche.sql.configuration.Configuration;
import org.huiche.sql.dsl.column.Column;
import org.huiche.sql.exception.HcJdbcException;
import org.huiche.sql.exception.HcSQLException;
import org.huiche.sql.mapper.ColumnMapper;
import org.huiche.sql.mapper.SerializationColumnMapper;
import org.huiche.sql.naming.NamingStrategy;
import org.huiche.sql.support.ColumnInfo;
import org.huiche.sql.support.PrimaryKeyInfo;
import org.huiche.sql.support.TableInfo;
import org.huiche.sql.support.TableInfoCachingHolder;
import org.huiche.util.ReflectUtil;

public interface JdbcHelper {
    public static <T> void setPsVal(PreparedStatement ps, int parameterIndex, T val, Configuration configuration) throws SQLException {
        ColumnMapper mapper = (ColumnMapper)configuration.columnMappers().get(val.getClass());
        if (mapper != null) {
            mapper.write(ps, parameterIndex, val);
            return;
        }
        if (JdbcHelper.setPsSimpleVal(ps, parameterIndex, val) || JdbcHelper.setPsDateOrTimeVal(ps, parameterIndex, val) || JdbcHelper.setPsBigNumberVal(ps, parameterIndex, val)) {
            return;
        }
        if (val instanceof Enum) {
            Enum enumVal = (Enum)val;
            ps.setString(parameterIndex, enumVal.name());
        } else if (configuration.serializationColumnMapper() != null) {
            ps.setString(parameterIndex, configuration.serializationColumnMapper().serialize(val));
        } else {
            throw new HcJdbcException("unsupported value: " + val + ", you can add a ColumnMapper or set serializationColumnMapper in configuration");
        }
    }

    private static <T> boolean setPsSimpleVal(PreparedStatement ps, int parameterIndex, T val) throws SQLException {
        if (val instanceof Boolean) {
            Boolean boolVal = (Boolean)val;
            ps.setBoolean(parameterIndex, boolVal);
        } else if (val instanceof Byte) {
            Byte byteVal = (Byte)val;
            ps.setByte(parameterIndex, byteVal);
        } else if (val instanceof Short) {
            Short shortVal = (Short)val;
            ps.setShort(parameterIndex, shortVal);
        } else if (val instanceof Integer) {
            Integer intVal = (Integer)val;
            ps.setInt(parameterIndex, intVal);
        } else if (val instanceof Long) {
            Long longVal = (Long)val;
            ps.setLong(parameterIndex, longVal);
        } else if (val instanceof Float) {
            Float floatVal = (Float)val;
            ps.setFloat(parameterIndex, floatVal.floatValue());
        } else if (val instanceof Double) {
            Double doubleVal = (Double)val;
            ps.setDouble(parameterIndex, doubleVal);
        } else if (val instanceof Character || val instanceof String) {
            ps.setString(parameterIndex, val.toString());
        } else if (val instanceof byte[]) {
            byte[] bytesVal = (byte[])val;
            ps.setBytes(parameterIndex, bytesVal);
        } else {
            return false;
        }
        return true;
    }

    private static <T> boolean setPsDateOrTimeVal(PreparedStatement ps, int parameterIndex, T val) throws SQLException {
        Class<?> clazz = val.getClass();
        if (java.util.Date.class.equals(clazz)) {
            java.util.Date dateVal = (java.util.Date)val;
            ps.setTimestamp(parameterIndex, new Timestamp(dateVal.getTime()));
        } else if (Date.class.equals(clazz)) {
            ps.setDate(parameterIndex, (Date)val);
        } else if (Time.class.equals(clazz)) {
            ps.setTime(parameterIndex, (Time)val);
        } else if (Timestamp.class.equals(clazz)) {
            ps.setTimestamp(parameterIndex, (Timestamp)val);
        } else if (val instanceof LocalDateTime) {
            LocalDateTime localDatetimeVal = (LocalDateTime)val;
            ps.setTimestamp(parameterIndex, Timestamp.valueOf(localDatetimeVal));
        } else if (val instanceof LocalDate) {
            LocalDate localDateVal = (LocalDate)val;
            ps.setDate(parameterIndex, Date.valueOf(localDateVal));
        } else if (val instanceof LocalTime) {
            LocalTime localTimeVal = (LocalTime)val;
            ps.setTime(parameterIndex, Time.valueOf(localTimeVal));
        } else {
            return false;
        }
        return true;
    }

    private static <T> boolean setPsBigNumberVal(PreparedStatement ps, int parameterIndex, T val) throws SQLException {
        if (val instanceof BigDecimal) {
            BigDecimal bigDecimalVal = (BigDecimal)val;
            ps.setBigDecimal(parameterIndex, bigDecimalVal);
        } else if (val instanceof BigInteger) {
            BigInteger bigIntVal = (BigInteger)val;
            ps.setBigDecimal(parameterIndex, new BigDecimal(bigIntVal));
        } else {
            return false;
        }
        return true;
    }

    public static <T> T getRsVal(Class<T> clazz, Type[] generics, ResultSet rs, int columnIndex, Configuration configuration) throws SQLException {
        ColumnMapper mapper = (ColumnMapper)configuration.columnMappers().get(clazz);
        Object val = mapper == null ? null : mapper.read(rs, columnIndex);
        val = val == null && String.class.equals(clazz) ? rs.getString(columnIndex) : val;
        val = val == null ? JdbcHelper.getRsPrimitiveWrapperVal(clazz, rs, columnIndex) : val;
        val = val == null ? JdbcHelper.getRsBigNumberVal(clazz, rs, columnIndex) : val;
        val = val == null ? JdbcHelper.getRsDateOrTimeVal(clazz, rs, columnIndex) : val;
        val = val == null ? JdbcHelper.getRsPrimitiveVal(clazz, rs, columnIndex) : val;
        val = val == null && clazz.isEnum() ? JdbcHelper.getRsEnumNumberVal(clazz, rs.getString(columnIndex)) : val;
        Object object = val = val == null && byte[].class.equals(clazz) ? (Object)Optional.ofNullable(rs.getBytes(columnIndex)).orElse(new byte[0]) : val;
        if (val != null) {
            return (T)val;
        }
        String str = rs.getString(columnIndex);
        if (generics != null && generics.length > 0) {
            val = JdbcHelper.getRsSerializeGenericsVal(str, clazz, generics, configuration.serializationColumnMapper());
        }
        val = val == null ? JdbcHelper.getRsSerializeVal(clazz, str, configuration.serializationColumnMapper()) : val;
        return (T)val;
    }

    public static <T> Object getRsSerializeGenericsVal(String str, Class<T> clazz, Type[] generics, SerializationColumnMapper serializationColumnMapper) {
        return serializationColumnMapper == null || str == null || str.isEmpty() ? null : serializationColumnMapper.deserializeGenericsType(str, ReflectUtil.parameterizedType(clazz, (Type[])generics));
    }

    private static Object getRsPrimitiveVal(Class<?> clazz, ResultSet rs, int columnIndex) throws SQLException {
        if (Boolean.TYPE.equals(clazz)) {
            return rs.getBoolean(columnIndex);
        }
        if (Byte.TYPE.equals(clazz)) {
            return rs.getByte(columnIndex);
        }
        if (Short.TYPE.equals(clazz)) {
            return rs.getShort(columnIndex);
        }
        if (Character.TYPE.equals(clazz)) {
            String str = rs.getString(columnIndex);
            if (str != null && !str.isEmpty()) {
                return Character.valueOf(str.toCharArray()[0]);
            }
            return Character.valueOf('\u0000');
        }
        if (Integer.TYPE.equals(clazz)) {
            return rs.getInt(columnIndex);
        }
        if (Long.TYPE.equals(clazz)) {
            return rs.getLong(columnIndex);
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.valueOf(rs.getFloat(columnIndex));
        }
        if (Double.TYPE.equals(clazz)) {
            return rs.getDouble(columnIndex);
        }
        return null;
    }

    private static Object getRsPrimitiveWrapperVal(Class<?> clazz, ResultSet rs, int columnIndex) throws SQLException {
        Comparable<Boolean> val = null;
        if (Boolean.class.equals(clazz)) {
            val = rs.getBoolean(columnIndex);
        } else if (Byte.class.equals(clazz)) {
            val = rs.getByte(columnIndex);
        } else if (Short.class.equals(clazz)) {
            val = rs.getShort(columnIndex);
        } else if (Character.class.equals(clazz)) {
            String str = rs.getString(columnIndex);
            if (str != null && !str.isEmpty()) {
                val = Character.valueOf(str.toCharArray()[0]);
            }
        } else if (Integer.class.equals(clazz)) {
            val = rs.getInt(columnIndex);
        } else if (Long.class.equals(clazz)) {
            val = rs.getLong(columnIndex);
        } else if (Float.class.equals(clazz)) {
            val = Float.valueOf(rs.getFloat(columnIndex));
        } else if (Double.class.equals(clazz)) {
            val = rs.getDouble(columnIndex);
        }
        if (val != null && rs.wasNull()) {
            return null;
        }
        return val;
    }

    private static Object getRsDateOrTimeVal(Class<?> clazz, ResultSet rs, int columnIndex) throws SQLException {
        Time time;
        if (Date.class.equals(clazz)) {
            return rs.getDate(columnIndex);
        }
        if (Time.class.equals(clazz)) {
            return rs.getTime(columnIndex);
        }
        if (Timestamp.class.equals(clazz)) {
            return rs.getTimestamp(columnIndex);
        }
        if (java.util.Date.class.equals(clazz)) {
            Timestamp timestamp = rs.getTimestamp(columnIndex);
            if (timestamp != null) {
                return new java.util.Date(timestamp.getTime());
            }
        } else if (LocalDateTime.class.equals(clazz)) {
            Timestamp timestamp = rs.getTimestamp(columnIndex);
            if (timestamp != null) {
                return timestamp.toLocalDateTime();
            }
        } else if (LocalDate.class.equals(clazz)) {
            Date date = rs.getDate(columnIndex);
            if (date != null) {
                return date.toLocalDate();
            }
        } else if (LocalTime.class.equals(clazz) && (time = rs.getTime(columnIndex)) != null) {
            return time.toLocalTime();
        }
        return null;
    }

    private static Object getRsBigNumberVal(Class<?> clazz, ResultSet rs, int columnIndex) throws SQLException {
        BigDecimal bigDecimal;
        if (BigDecimal.class.equals(clazz)) {
            return rs.getBigDecimal(columnIndex);
        }
        if (BigInteger.class.equals(clazz) && (bigDecimal = rs.getBigDecimal(columnIndex)) != null) {
            return bigDecimal.toBigInteger();
        }
        return null;
    }

    private static Object getRsEnumNumberVal(Class<?> clazz, String str) {
        if (str == null) {
            return null;
        }
        for (Object t : clazz.getEnumConstants()) {
            Enum e = (Enum)t;
            if (!e.name().equalsIgnoreCase(str)) continue;
            return t;
        }
        return null;
    }

    private static Object getRsSerializeVal(Class<?> clazz, String str, SerializationColumnMapper serializationColumnMapper) {
        return serializationColumnMapper == null || str == null || str.isEmpty() ? null : serializationColumnMapper.deserialize(str, clazz);
    }

    public static Map<String, Object> resultToMap(ResultSet rs, NamingStrategy namingStrategy) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                map.put(namingStrategy.toJavaName(metaData.getColumnLabel(i)), rs.getObject(i));
            }
        }
        catch (SQLException e) {
            throw new HcSQLException(e);
        }
        return map;
    }

    public static Map<String, Integer> columnNameIndexMap(ResultSetMetaData metaData, NamingStrategy namingStrategy) throws SQLException {
        int columnCount = metaData.getColumnCount();
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(columnCount);
        LinkedHashMap<String, Integer> optionMap = new LinkedHashMap<String, Integer>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String dbName = metaData.getColumnLabel(i);
            String javaName = namingStrategy.toJavaName(dbName);
            map.put(javaName, i);
            if (javaName.equals(dbName)) continue;
            optionMap.put(dbName, i);
        }
        optionMap.forEach((k, v) -> {
            if (!map.containsKey(k)) {
                map.put((String)k, (Integer)v);
            }
        });
        return map;
    }

    public static <T> T mappingSingleKey(List<Map<String, Object>> keys, Class<T> keyClass) {
        Object key = keys.stream().map(map -> map.values().iterator().next()).findFirst().orElse(null);
        if (key == null) {
            throw new HcJdbcException("can not find key");
        }
        if (keyClass.isAssignableFrom(key.getClass())) {
            return keyClass.cast(key);
        }
        throw new HcJdbcException("key: " + key + " cant not assignable to " + keyClass);
    }

    public static <T> List<T> mappingListKey(List<Map<String, Object>> keys, Class<T> keyClass) {
        return keys.stream().map(map -> {
            Object key = map.values().iterator().next();
            if (key == null) {
                throw new HcJdbcException("some key is null");
            }
            if (keyClass.isAssignableFrom(key.getClass())) {
                throw new HcJdbcException("key: " + key + " cant not assignable to " + keyClass);
            }
            return keyClass.cast(key);
        }).toList();
    }

    public static List<ColumnInfo> getColumnsByValueMap(Map<String, Object> valueMap, List<ColumnInfo> allColumns) {
        if (valueMap.isEmpty() || allColumns.isEmpty()) {
            return Collections.emptyList();
        }
        return allColumns.stream().filter(col -> valueMap.containsKey(col.name())).toList();
    }

    public static List<ColumnInfo> getColumnsByValueMapList(List<Map<String, Object>> valueMapList, List<ColumnInfo> allColumns) {
        if (valueMapList.isEmpty() || allColumns.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet colSet = new LinkedHashSet();
        valueMapList.forEach(i -> colSet.addAll(i.keySet()));
        return allColumns.stream().filter(col -> colSet.contains(col.name())).toList();
    }

    public static Column getSinglePkColumn(Class<?> clazz) {
        TableInfo info = TableInfoCachingHolder.get(clazz);
        if (info.pks().size() == 1) {
            return Column.of((ColumnInfo)((PrimaryKeyInfo)info.pks().get(0)).columnInfo());
        }
        throw new HcJdbcException(clazz.getCanonicalName() + " cant not find the one and only primary key");
    }
}

