/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.jdbc.support;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.huiche.sql.exception.HcJdbcException;

public interface KeyHolder {
    public List<Map<String, Object>> keysList();

    default public Map<String, Object> keys() {
        List<Map<String, Object>> keysList = this.keysList();
        if (keysList.isEmpty()) {
            throw new HcJdbcException("no keys found");
        }
        return keysList.get(0);
    }

    default public Object key() {
        Map<String, Object> map = this.keys();
        if (map.isEmpty()) {
            throw new HcJdbcException("no key found");
        }
        return map.values().iterator().next();
    }

    default public String string() {
        return this.key().toString();
    }

    default public List<String> stringList() {
        return this.keysList().stream().map(map -> map.values().iterator().next()).map(Object::toString).toList();
    }

    default public Integer intKey() {
        return Integer.parseInt(this.string());
    }

    default public List<Integer> intKeyList() {
        return this.stringList().stream().map(Integer::valueOf).toList();
    }

    default public Long longKey() {
        return Long.parseLong(this.string());
    }

    default public List<Long> longKeyList() {
        return this.stringList().stream().map(Long::valueOf).toList();
    }

    default public <T> T as(Class<T> clazz) {
        Object key = this.key();
        if (clazz.isAssignableFrom(key.getClass())) {
            return clazz.cast(key);
        }
        throw new HcJdbcException("key is not assignable from " + clazz.getName());
    }

    default public <T> List<T> listAs(Class<T> clazz) {
        return this.keysList().stream().map(i -> {
            if (clazz.isAssignableFrom(i.getClass())) {
                return clazz.cast(i);
            }
            throw new HcJdbcException("key is not assignable from " + clazz.getName());
        }).toList();
    }

    default public <T> void consumer(Class<T> clazz, Consumer<T> consumer) {
        Object key = Integer.TYPE.equals(clazz) || Integer.class.equals(clazz) ? this.intKey() : (Long.TYPE.equals(clazz) || Long.class.equals(clazz) ? this.longKey() : (String.class.equals(clazz) ? this.string() : this.as(clazz)));
        consumer.accept((Integer)key);
    }

    default public <T> void listConsumer(Class<T> clazz, Consumer<List<T>> consumer) {
        List<Object> keyList = Integer.TYPE.equals(clazz) || Integer.class.equals(clazz) ? this.intKeyList() : (Long.TYPE.equals(clazz) || Long.class.equals(clazz) ? this.longKeyList() : (String.class.equals(clazz) ? this.stringList() : this.listAs(clazz)));
        consumer.accept(keyList);
    }
}

