/*
 * Decompiled with CFR 0.152.
 */
package org.huiche.jdbc.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.huiche.jdbc.mapper.EntityRowMapper;
import org.huiche.jdbc.mapper.SingleColumnRowMapper;
import org.huiche.sql.dsl.support.TypeHelper;
import org.huiche.sql.mapper.RowMapper;

public class RowMapperCachingHolder {
    private static final Map<Class<?>, RowMapper<?>> CACHE = new ConcurrentHashMap();

    private RowMapperCachingHolder() {
    }

    public static synchronized <T> RowMapper<T> get(Class<T> clazz) {
        RowMapper<?> cache = CACHE.get(clazz);
        if (cache == null) {
            cache = TypeHelper.isSupportType(clazz) ? new SingleColumnRowMapper<T>(clazz) : new EntityRowMapper<T>(clazz);
            CACHE.put(clazz, cache);
        }
        return cache;
    }
}

