/*
 * Copyright 2019 IBM All Rights Reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * <p>This package provides the set of interfaces that enable a Java application to
 * interact with a Fabric blockchain network. It provides a simple API to
 * submit transactions to a ledger or query the contents of a ledger with minimal code.
 * The Gateway SDK implements the Fabric programming model as described in the
 * <a href="https://hyperledger-fabric.readthedocs.io/en/release-1.4/developapps/developing_applications.html">Developing Applications</a>
 * chapter of the Fabric documentation.</p>
 *
 * @see <a href="https://hyperledger-fabric.readthedocs.io/en/release-1.4/developapps/developing_applications.html">Developing Fabric Applications</a>
 */
package org.hyperledger.fabric.gateway;
