/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ListenerSet<T>
implements Iterable<T> {
    private static final Log LOG = LogFactory.getLog(ListenerSet.class);
    private final Set<T> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public T add(T listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void remove(T listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.listeners.forEach(listener -> {
            try {
                action.accept(listener);
            }
            catch (Exception e) {
                LOG.error((Object)"forEach: Exception notifying listener", (Throwable)e);
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return this.listeners.iterator();
    }

    public String toString() {
        return this.listeners.toString();
    }
}

