/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSource;
import org.hyperledger.fabric.gateway.impl.event.ListenerSet;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.BlockInfo;

public final class OrderedBlockEventSource
implements BlockEventSource {
    private static final Comparator<BlockEvent> EVENT_COMPARATOR = Comparator.comparingLong(BlockInfo::getBlockNumber);
    private final BlockEventSource blockSource;
    private final ListenerSet<Consumer<BlockEvent>> listeners = new ListenerSet();
    private final Consumer<BlockEvent> blockListener;
    private final Object stateLock = new Object();
    private long blockNumber;
    private final SortedSet<BlockEvent> queuedEvents = new TreeSet<BlockEvent>(EVENT_COMPARATOR);

    public OrderedBlockEventSource(BlockEventSource blockSource) {
        this(blockSource, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedBlockEventSource(BlockEventSource blockSource, long startBlock) {
        this.blockSource = blockSource;
        this.blockListener = blockSource.addBlockListener(this::receivedBlock);
        Object object = this.stateLock;
        synchronized (object) {
            this.blockNumber = startBlock;
        }
    }

    @Override
    public Consumer<BlockEvent> addBlockListener(Consumer<BlockEvent> listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void removeBlockListener(Consumer<BlockEvent> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() {
        this.listeners.clear();
        this.blockSource.removeBlockListener(this.blockListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedBlock(BlockEvent event) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isOldBlockNumber(event.getBlockNumber())) {
                return;
            }
            this.queuedEvents.add(event);
            this.notifyListeners();
        }
    }

    private boolean isOldBlockNumber(long eventBlockNumber) {
        return eventBlockNumber < this.blockNumber;
    }

    private void notifyListeners() {
        BlockEvent event;
        long eventBlockNumber;
        Iterator eventIter = this.queuedEvents.iterator();
        while (eventIter.hasNext() && this.isNextBlockNumber(eventBlockNumber = (event = (BlockEvent)eventIter.next()).getBlockNumber())) {
            eventIter.remove();
            this.blockNumber = eventBlockNumber + 1L;
            this.listeners.forEach(listener -> listener.accept(event));
        }
    }

    private boolean isNextBlockNumber(long eventBlockNumber) {
        return this.blockNumber < 0L || this.blockNumber == eventBlockNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String queuedBlocks;
        long currentBlockNumber;
        Object object = this.stateLock;
        synchronized (object) {
            currentBlockNumber = this.blockNumber;
            queuedBlocks = this.queuedEvents.stream().mapToLong(BlockInfo::getBlockNumber).mapToObj(Long::toString).collect(Collectors.joining(", ", "[", "]"));
        }
        return GatewayUtils.toString(this, "blockNumber=" + currentBlockNumber, "queuedBlocks=" + queuedBlocks);
    }
}

