/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.function.Consumer;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.event.ListenerSet;
import org.hyperledger.fabric.gateway.impl.event.PeerDisconnectEventSource;
import org.hyperledger.fabric.gateway.spi.PeerDisconnectEvent;
import org.hyperledger.fabric.sdk.Peer;

public final class PeerDisconnectInterceptor
implements PeerDisconnectEventSource {
    private final ListenerSet<Consumer<PeerDisconnectEvent>> listeners = new ListenerSet();
    private final Peer peer;
    private final Peer.PeerEventingServiceDisconnected disconnectHandler;

    PeerDisconnectInterceptor(Peer peer) {
        this.peer = peer;
        this.disconnectHandler = peer.getPeerEventingServiceDisconnected();
        peer.setPeerEventingServiceDisconnected(this::handleDisconnect);
    }

    private void handleDisconnect(Peer.PeerEventingServiceDisconnectEvent event) {
        this.notifyListeners(event);
        this.disconnectHandler.disconnected(event);
    }

    @Override
    public Consumer<PeerDisconnectEvent> addDisconnectListener(Consumer<PeerDisconnectEvent> listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void removeDisconnectListener(Consumer<PeerDisconnectEvent> listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(final Peer.PeerEventingServiceDisconnectEvent sdkEvent) {
        PeerDisconnectEvent ourEvent = new PeerDisconnectEvent(){

            @Override
            public Peer getPeer() {
                return PeerDisconnectInterceptor.this.peer;
            }

            @Override
            public Throwable getCause() {
                return sdkEvent.getExceptionThrown();
            }
        };
        this.listeners.forEach(listener -> listener.accept(ourEvent));
    }

    @Override
    public void close() {
        this.listeners.clear();
        this.peer.setPeerEventingServiceDisconnected(this.disconnectHandler);
    }

    public String toString() {
        return GatewayUtils.toString(this, "peer=" + this.peer);
    }
}

