/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Consumer;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.NetworkImpl;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSource;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSourceFactory;
import org.hyperledger.fabric.gateway.impl.event.ListenerSession;
import org.hyperledger.fabric.gateway.impl.event.OrderedBlockEventSource;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;

public final class ReplayListenerSession
implements ListenerSession {
    private final GatewayImpl gateway;
    private final Channel channel;
    private final BlockEventSource blockSource;

    public ReplayListenerSession(NetworkImpl network, Consumer<BlockEvent> listener, long startBlock) {
        this.gateway = network.getGateway().newInstance();
        String channelName = network.getChannel().getName();
        this.channel = this.gateway.getNetwork(channelName).getChannel();
        Collection eventingPeers = this.channel.getPeers(EnumSet.of(Peer.PeerRole.EVENT_SOURCE));
        this.removeAllPeers();
        BlockEventSource channelBlockSource = BlockEventSourceFactory.getInstance().newBlockEventSource(this.channel);
        this.blockSource = new OrderedBlockEventSource(channelBlockSource, startBlock);
        this.blockSource.addBlockListener(listener);
        this.addReplayPeers(eventingPeers, startBlock);
    }

    private void removeAllPeers() {
        try {
            for (Peer peer : this.channel.getPeers()) {
                this.channel.removePeer(peer);
            }
        }
        catch (InvalidArgumentException e) {
            throw new GatewayRuntimeException("Failed to remove peers from channel", e);
        }
    }

    private void addReplayPeers(Collection<Peer> eventingPeers, long startBlock) {
        HFClient client = this.gateway.getClient();
        try {
            for (Peer originalPeer : eventingPeers) {
                Peer replayPeer = client.newPeer(originalPeer.getName(), originalPeer.getUrl(), originalPeer.getProperties());
                Channel.PeerOptions options = Channel.PeerOptions.createPeerOptions().addPeerRole(Peer.PeerRole.EVENT_SOURCE).startEvents(startBlock);
                this.channel.addPeer(replayPeer, options);
            }
        }
        catch (InvalidArgumentException e) {
            throw new GatewayRuntimeException("Failed to add peers for event replay", e);
        }
    }

    @Override
    public void close() {
        this.blockSource.close();
        this.gateway.close();
    }

    public String toString() {
        return GatewayUtils.toString(this, "channel=" + this.channel, "blockSource=" + this.blockSource);
    }
}

