/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.idin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import net.bankid.merchant.library.AssuranceLevel;
import net.bankid.merchant.library.AuthenticationRequest;
import net.bankid.merchant.library.AuthenticationResponse;
import net.bankid.merchant.library.Communicator;
import net.bankid.merchant.library.Configuration;
import net.bankid.merchant.library.DirectoryResponse;
import net.bankid.merchant.library.ErrorResponse;
import net.bankid.merchant.library.SamlResponse;
import net.bankid.merchant.library.ServiceId;
import net.bankid.merchant.library.StatusRequest;
import net.bankid.merchant.library.StatusResponse;
import net.bankid.merchant.library.internal.DirectoryResponseBase;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.HasPhysicalDestination;
import nl.nn.adapterframework.core.PipeLineSession;
import nl.nn.adapterframework.core.SenderException;
import nl.nn.adapterframework.core.TimeoutException;
import nl.nn.adapterframework.senders.SenderWithParametersBase;
import nl.nn.adapterframework.stream.Message;
import nl.nn.adapterframework.util.CredentialFactory;
import nl.nn.adapterframework.util.DateUtils;
import nl.nn.adapterframework.util.DomBuilderException;
import nl.nn.adapterframework.util.XmlBuilder;
import nl.nn.adapterframework.util.XmlUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class IdinSender
extends SenderWithParametersBase
implements HasPhysicalDestination {
    private final String domain = "Idin";
    private String merchantID = null;
    private int merchantSubID = 0;
    private String merchantReturnUrl = null;
    private String acquirerDirectoryUrl = null;
    private String acquirerTransactionUrl = null;
    private String acquirerStatusUrl = null;
    private String keyStoreLocation = null;
    private CredentialFactory keyStoreCredentials = null;
    private String merchantCertificateAlias = null;
    private CredentialFactory merchantCertificateCredentials = null;
    private String acquirerCertificateAlias = null;
    private String acquirerAlternativeCertificateAlias = null;
    private String SAMLCertificateAlias = null;
    private CredentialFactory SAMLCertificateCredentials = null;
    private boolean logsEnabled = false;
    private boolean serviceLogsEnabled = false;
    private String serviceLogsLocation = null;
    private String serviceLogsPattern = "%Y-%M-%D\\%h%m%s.%f-%a.xml";
    private String action = "DIRECTORY";
    private List<String> actions = Arrays.asList("DIRECTORY", "RESPONSE", "AUTHENTICATE");
    Configuration idinConfig = null;
    Communicator communicator = null;

    public void configure() throws ConfigurationException {
        super.configure();
        if (StringUtils.isNotEmpty((CharSequence)this.getAction()) && !this.actions.contains(this.getAction())) {
            throw new ConfigurationException(this.getLogPrefix() + "unknown action [" + this.getAction() + "] supported methods are " + this.actions.toString() + "");
        }
        this.idinConfig = Configuration.defaultInstance();
        if (StringUtils.isNotEmpty((CharSequence)this.getMerchantID())) {
            this.idinConfig.setMerchantID(this.getMerchantID());
        }
        if (this.getMerchantSubID() > 0) {
            this.idinConfig.setMerchantSubID(this.getMerchantSubID());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getMerchantReturnUrl())) {
            this.idinConfig.setMerchantReturnUrl(this.getMerchantReturnUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerDirectoryUrl())) {
            this.idinConfig.setAcquirerDirectoryURL(this.getAcquirerDirectoryUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerTransactionUrl())) {
            this.idinConfig.setAcquirerTransactionURL(this.getAcquirerTransactionUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerStatusUrl())) {
            this.idinConfig.setAcquirerStatusURL(this.getAcquirerStatusUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getKeyStoreLocation())) {
            this.idinConfig.setKeyStoreLocation(this.getKeyStoreLocation());
            if (StringUtils.isNotEmpty((CharSequence)this.getKeyStorePassword())) {
                this.idinConfig.setKeyStorePassword(this.getKeyStorePassword());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getMerchantCertificateAlias())) {
            this.idinConfig.setMerchantCertificateAlias(this.getMerchantCertificateAlias());
            if (StringUtils.isNotEmpty((CharSequence)this.getMerchantCertificatePassword())) {
                this.idinConfig.setMerchantCertificatePassword(this.getMerchantCertificatePassword());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerCertificateAlias())) {
            this.idinConfig.setAcquirerCertificateAlias(this.getAcquirerCertificateAlias());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerAlternativeCertificateAlias())) {
            this.idinConfig.setAcquirerAlternateCertificateAlias(this.getAcquirerAlternativeCertificateAlias());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getSAMLCertificateAlias())) {
            this.idinConfig.setSamlCertificateAlias(this.getSAMLCertificateAlias());
            if (StringUtils.isNotEmpty((CharSequence)this.getSAMLCertificatePassword())) {
                this.idinConfig.setSamlCertificatePassword(this.getSAMLCertificatePassword());
            }
        }
        if (this.getLogsEnabled()) {
            this.idinConfig.setLogsEnabled(this.getLogsEnabled());
        }
        if (this.getServiceLogsEnabled()) {
            this.idinConfig.setServiceLogsEnabled(this.getServiceLogsEnabled());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getServiceLogsLocation())) {
            this.idinConfig.setServiceLogsLocation(this.getServiceLogsLocation());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getServiceLogsPattern())) {
            this.idinConfig.setServiceLogsPattern(this.getServiceLogsPattern());
        }
        this.idinConfig.setTls12Enabled(true);
        this.communicator = new Communicator(this.idinConfig);
    }

    public Communicator getCommunicator() {
        return this.communicator;
    }

    public Message sendMessage(Message message, PipeLineSession session) throws SenderException, TimeoutException {
        Element queryElement = null;
        try {
            queryElement = XmlUtils.isWellFormed((String)message.asString(), (String)"idin") ? XmlUtils.buildElement((String)message.asString()) : XmlUtils.buildElement((String)"<idin/>");
        }
        catch (IOException | DomBuilderException e) {
            throw new SenderException(e);
        }
        XmlBuilder result = new XmlBuilder("result");
        ErrorResponse error = null;
        if (this.getAction().equals("DIRECTORY")) {
            DirectoryResponse response = this.getCommunicator().getDirectory();
            if (response.getIsError()) {
                error = response.getErrorResponse();
            } else {
                XmlBuilder issuers = new XmlBuilder("issuers");
                if (XmlUtils.getChildTagAsBoolean((Element)queryElement, (String)"issuersByCountry")) {
                    for (Map.Entry entry : response.getIssuersByCountry().entrySet()) {
                        XmlBuilder countryXml = new XmlBuilder("country");
                        String country = (String)entry.getKey();
                        countryXml.addAttribute("name", country);
                        for (DirectoryResponseBase.Issuer issuer : (List)entry.getValue()) {
                            XmlBuilder issuerXml = new XmlBuilder("issuer");
                            issuerXml.setValue(issuer.getIssuerName());
                            issuerXml.addAttribute("id", issuer.getIssuerID());
                            countryXml.addSubElement(issuerXml);
                        }
                        issuers.addSubElement(countryXml);
                    }
                } else {
                    for (DirectoryResponseBase.Issuer issuer : response.getIssuers()) {
                        XmlBuilder issuerXml = new XmlBuilder("issuer");
                        issuerXml.setValue(issuer.getIssuerName());
                        issuerXml.addAttribute("id", issuer.getIssuerID());
                        issuerXml.addAttribute("country", issuer.getIssuerCountry());
                        issuers.addSubElement(issuerXml);
                    }
                }
                result.addSubElement(issuers);
                XmlBuilder timestamp = new XmlBuilder("timestamp");
                Date date = response.getDirectoryDateTimestamp().toGregorianCalendar().getTime();
                timestamp.setValue(DateUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss.SSS"), false);
                result.addSubElement(timestamp);
            }
            if (StringUtils.isNotEmpty((CharSequence)response.getRawMessage())) {
                this.log.debug(response.getRawMessage());
            }
        } else if (this.getAction().equals("RESPONSE")) {
            String transactionID = XmlUtils.getChildTagAsString((Element)queryElement, (String)"transactionID");
            if (StringUtils.isEmpty((CharSequence)transactionID)) {
                throw new SenderException("no transactionID was supplied");
            }
            StatusRequest statusRequest = new StatusRequest();
            statusRequest.setTransactionID(transactionID);
            StatusResponse response = this.getCommunicator().getResponse(statusRequest);
            if (response.getIsError()) {
                error = response.getErrorResponse();
            } else {
                XmlBuilder xmlBuilder = new XmlBuilder("status");
                xmlBuilder.setValue(response.getStatus(), false);
                result.addSubElement(xmlBuilder);
                if (response.getStatus() == "Success") {
                    SamlResponse saml = response.getSamlResponse();
                    XmlBuilder samlXml = new XmlBuilder("saml");
                    XmlBuilder acquirerId = new XmlBuilder("acquirerId");
                    acquirerId.setValue(saml.getAcquirerID());
                    samlXml.addSubElement(acquirerId);
                    XmlBuilder attributes = new XmlBuilder("attributes");
                    for (Map.Entry entry : saml.getAttributes().entrySet()) {
                        XmlBuilder attribute = new XmlBuilder("attribute");
                        attribute.addAttribute("name", (String)entry.getKey());
                        attribute.setValue((String)entry.getValue());
                        attributes.addSubElement(attribute);
                    }
                    samlXml.addSubElement(attributes);
                    XmlBuilder merchantReference = new XmlBuilder("merchantReference");
                    merchantReference.setValue(saml.getMerchantReference());
                    samlXml.addSubElement(merchantReference);
                    XmlBuilder version = new XmlBuilder("version");
                    version.setValue(saml.getAcquirerID());
                    samlXml.addSubElement(version);
                    result.addSubElement(samlXml);
                }
                XmlBuilder transactionIdXml = new XmlBuilder("transactionID");
                transactionIdXml.setValue(response.getTransactionID(), false);
                result.addSubElement(transactionIdXml);
                XmlBuilder timestamp = new XmlBuilder("timestamp");
                Date txDate = response.getStatusDateTimestamp().toGregorianCalendar().getTime();
                timestamp.setValue(DateUtils.format((Date)txDate, (String)"yyyy-MM-dd HH:mm:ss.SSS"), false);
                result.addSubElement(timestamp);
            }
            if (StringUtils.isNotEmpty((CharSequence)response.getRawMessage())) {
                this.log.debug(response.getRawMessage());
            }
        } else if (this.getAction().equals("AUTHENTICATE")) {
            AuthenticationResponse response;
            String requestedServiceId;
            String string;
            AuthenticationRequest authRequest = new AuthenticationRequest();
            String issuerId = XmlUtils.getChildTagAsString((Element)queryElement, (String)"issuerId");
            if (StringUtils.isEmpty((CharSequence)issuerId)) {
                throw new SenderException("no issuerId was supplied");
            }
            authRequest.setIssuerID(issuerId);
            String language = XmlUtils.getChildTagAsString((Element)queryElement, (String)"language");
            if (StringUtils.isNotEmpty((CharSequence)language)) {
                authRequest.setLanguage(language);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string = XmlUtils.getChildTagAsString((Element)queryElement, (String)"expirationPeriod")))) {
                try {
                    Duration duration = DatatypeFactory.newInstance().newDuration(string);
                    authRequest.setExpirationPeriod(duration);
                }
                catch (DatatypeConfigurationException e) {
                    throw new SenderException((Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(requestedServiceId = XmlUtils.getChildTagAsString((Element)queryElement, (String)"requestedServiceId")))) {
                authRequest.setRequestedServiceID(new ServiceId(requestedServiceId));
            }
            String merchantReference = XmlUtils.getChildTagAsString((Element)queryElement, (String)"merchantReference");
            if (StringUtils.isNotEmpty((CharSequence)requestedServiceId)) {
                authRequest.setMerchantReference(merchantReference);
            }
            AssuranceLevel assuranceLevel = AssuranceLevel.Loa3;
            String assurance = XmlUtils.getChildTagAsString((Element)queryElement, (String)"assuranceLevel");
            if (StringUtils.isNotEmpty((CharSequence)assurance)) {
                assuranceLevel = AssuranceLevel.valueOf((String)assurance);
            }
            authRequest.setAssuranceLevel(assuranceLevel);
            String entranceCode = XmlUtils.getChildTagAsString((Element)queryElement, (String)"entranceCode");
            if (StringUtils.isNotEmpty((CharSequence)entranceCode)) {
                authRequest.setEntranceCode(entranceCode);
            }
            if ((response = this.getCommunicator().newAuthenticationRequest(authRequest)).getIsError()) {
                error = response.getErrorResponse();
            } else {
                XmlBuilder authenticationURL = new XmlBuilder("authenticationURL");
                authenticationURL.setValue(response.getIssuerAuthenticationURL(), false);
                result.addSubElement(authenticationURL);
                XmlBuilder transactionIdXml = new XmlBuilder("transactionID");
                transactionIdXml.setValue(response.getTransactionID(), false);
                result.addSubElement(transactionIdXml);
                XmlBuilder creationTime = new XmlBuilder("creationTime");
                Date txDate = response.getTransactionCreateDateTimestamp().toGregorianCalendar().getTime();
                creationTime.setValue(DateUtils.format((Date)txDate, (String)"yyyy-MM-dd HH:mm:ss.SSS"), false);
                result.addSubElement(creationTime);
            }
            if (StringUtils.isNotEmpty((CharSequence)response.getRawMessage())) {
                this.log.debug(response.getRawMessage());
            }
        }
        if (error != null) {
            XmlBuilder errorXml = new XmlBuilder("error");
            XmlBuilder statusCodeXml = new XmlBuilder("statusCode");
            statusCodeXml.setValue(error.getErrorCode());
            errorXml.addSubElement(statusCodeXml);
            XmlBuilder detailsXml = new XmlBuilder("details");
            detailsXml.setValue(error.getErrorDetails());
            errorXml.addSubElement(detailsXml);
            XmlBuilder xmlBuilder = new XmlBuilder("message");
            xmlBuilder.setValue(error.getErrorMessage());
            errorXml.addSubElement(xmlBuilder);
            result.addSubElement(errorXml);
        }
        return new Message(result.toXML());
    }

    public String getPhysicalDestinationName() {
        StringBuilder destination = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.getMerchantReturnUrl())) {
            destination.append(" returnUrl[" + this.getMerchantReturnUrl() + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerDirectoryUrl())) {
            destination.append(" directoryUrl[" + this.getAcquirerDirectoryUrl() + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerTransactionUrl())) {
            destination.append(" transactionUrl[" + this.getAcquirerTransactionUrl() + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAcquirerStatusUrl())) {
            destination.append(" statusUrl[" + this.getAcquirerStatusUrl() + "]");
        }
        return destination.toString().trim();
    }

    public void setAction(String action) {
        this.action = action.toUpperCase();
    }

    public String getAction() {
        return this.action;
    }

    public void setMerchantID(String merchantMerchantID) {
        this.merchantID = merchantMerchantID;
    }

    public String getMerchantID() {
        return this.merchantID;
    }

    public void setMerchantSubID(int merchantSubID) {
        this.merchantSubID = merchantSubID;
    }

    public int getMerchantSubID() {
        return this.merchantSubID;
    }

    public void setMerchantReturnUrl(String merchantReturnUrl) {
        this.merchantReturnUrl = merchantReturnUrl;
    }

    public String getMerchantReturnUrl() {
        return this.merchantReturnUrl;
    }

    public void setAcquirerDirectoryUrl(String acquirerDirectoryUrl) {
        this.acquirerDirectoryUrl = acquirerDirectoryUrl;
    }

    public String getAcquirerDirectoryUrl() {
        return this.acquirerDirectoryUrl;
    }

    public void setAcquirerTransactionUrl(String acquirerTransactionUrl) {
        this.acquirerTransactionUrl = acquirerTransactionUrl;
    }

    public String getAcquirerTransactionUrl() {
        return this.acquirerTransactionUrl;
    }

    public void setAcquirerStatusUrl(String acquirerStatusUrl) {
        this.acquirerStatusUrl = acquirerStatusUrl;
    }

    public String getAcquirerStatusUrl() {
        return this.acquirerStatusUrl;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStoreCredentials = new CredentialFactory(null, null, keyStorePassword);
    }

    public void setKeyStoreAuthAlias(String keyStoreAuthAlias) {
        this.keyStoreCredentials = new CredentialFactory(keyStoreAuthAlias, null, null);
    }

    public String getKeyStorePassword() {
        if (this.keyStoreCredentials == null) {
            return null;
        }
        return this.keyStoreCredentials.getPassword();
    }

    public void setMerchantCertificateAlias(String merchantCertificateAlias) {
        this.merchantCertificateAlias = merchantCertificateAlias;
    }

    public String getMerchantCertificateAlias() {
        return this.merchantCertificateAlias;
    }

    public void setMerchantCertificatePassword(String merchantCertificatePassword) {
        this.merchantCertificateCredentials = new CredentialFactory(null, null, merchantCertificatePassword);
    }

    public void setMerchantCertificateAuthAlias(String merchantCertificateAuthAlias) {
        this.merchantCertificateCredentials = new CredentialFactory(merchantCertificateAuthAlias, null, null);
    }

    public String getMerchantCertificatePassword() {
        if (this.merchantCertificateCredentials == null) {
            return null;
        }
        return this.merchantCertificateCredentials.getPassword();
    }

    public void setAcquirerCertificateAlias(String acquirerCertificateAlias) {
        this.acquirerCertificateAlias = acquirerCertificateAlias;
    }

    public String getAcquirerCertificateAlias() {
        return this.acquirerCertificateAlias;
    }

    public void setAcquirerAlternativeCertificateAlias(String acquirerAlternativeCertificateAlias) {
        this.acquirerAlternativeCertificateAlias = acquirerAlternativeCertificateAlias;
    }

    public String getAcquirerAlternativeCertificateAlias() {
        return this.acquirerAlternativeCertificateAlias;
    }

    public void setSAMLCertificateAlias(String SAMLCertificateAlias) {
        this.SAMLCertificateAlias = SAMLCertificateAlias;
    }

    public String getSAMLCertificateAlias() {
        return this.SAMLCertificateAlias;
    }

    public void setSAMLCertificatePassword(String SAMLCertificatePassword) {
        this.SAMLCertificateCredentials = new CredentialFactory(null, null, SAMLCertificatePassword);
    }

    public void setSAMLCertificateAuthAlias(String SAMLCertificateAuthAlias) {
        this.SAMLCertificateCredentials = new CredentialFactory(SAMLCertificateAuthAlias, null, null);
    }

    public String getSAMLCertificatePassword() {
        if (this.SAMLCertificateCredentials == null) {
            return null;
        }
        return this.SAMLCertificateCredentials.getPassword();
    }

    public void setLogsEnabled(boolean logsEnabled) {
        this.logsEnabled = logsEnabled;
    }

    public boolean getLogsEnabled() {
        return this.logsEnabled;
    }

    public void setServiceLogsEnabled(boolean serviceLogsEnabled) {
        this.serviceLogsEnabled = serviceLogsEnabled;
    }

    public boolean getServiceLogsEnabled() {
        return this.serviceLogsEnabled;
    }

    public void setServiceLogsLocation(String serviceLogsLocation) {
        this.serviceLogsLocation = serviceLogsLocation;
    }

    public String getServiceLogsLocation() {
        return this.serviceLogsLocation;
    }

    public void setServiceLogsPattern(String serviceLogsPattern) {
        this.serviceLogsPattern = serviceLogsPattern;
    }

    public String getServiceLogsPattern() {
        return this.serviceLogsPattern;
    }

    public String getDomain() {
        return "Idin";
    }
}

