/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.jms;

import com.ing.ifsa.IFSAContext;
import com.ing.ifsa.IFSAQueue;
import com.ing.ifsa.IFSAQueueConnectionFactory;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import nl.nn.adapterframework.extensions.ifsa.IfsaException;
import nl.nn.adapterframework.jms.MessagingSource;
import nl.nn.adapterframework.util.AppConstants;
import nl.nn.adapterframework.util.ClassUtils;

public class IfsaMessagingSource
extends MessagingSource {
    private static final String CLEANUP_ON_CLOSE_KEY = "ifsa.cleanUpOnClose";
    private static Boolean cleanUpOnClose = null;
    private boolean preJms22Api;
    private boolean xaEnabled;

    public IfsaMessagingSource(String applicationId, IFSAContext context, IFSAQueueConnectionFactory connectionFactory, Map messagingSourceMap, boolean preJms22Api, boolean xaEnabled) {
        super(applicationId, (Context)context, (ConnectionFactory)connectionFactory, messagingSourceMap, null, false, true);
        this.preJms22Api = preJms22Api;
        this.xaEnabled = xaEnabled;
        this.log.debug((Object)("created new IfsaMessagingSource for [" + applicationId + "] context [" + context + "] connectionfactory [" + connectionFactory + "]"));
    }

    public boolean hasDynamicReplyQueue() throws IfsaException {
        try {
            if (this.preJms22Api) {
                return !((IFSAQueueConnectionFactory)this.getConnectionFactory()).IsClientTransactional();
            }
            return ((IFSAContext)this.getContext()).hasDynamicReplyQueue();
        }
        catch (NamingException e) {
            throw new IfsaException("could not find IfsaContext", (Throwable)e);
        }
    }

    public boolean canUseIfsaModeSessions() throws IfsaException {
        return this.hasDynamicReplyQueue() && !this.useSingleDynamicReplyQueue();
    }

    public Queue getClientReplyQueue(QueueSession session) throws IfsaException {
        Queue replyQueue = null;
        try {
            if (this.hasDynamicReplyQueue()) {
                replyQueue = this.getDynamicReplyQueue((Session)session);
                this.log.debug((Object)("got dynamic reply queue [" + replyQueue.getQueueName() + "]"));
            } else {
                replyQueue = (Queue)((IFSAContext)this.getContext()).lookupReply(this.getId());
                this.log.debug((Object)("got static reply queue [" + replyQueue.getQueueName() + "]"));
            }
            return replyQueue;
        }
        catch (Exception e) {
            throw new IfsaException((Throwable)e);
        }
    }

    protected void releaseClientReplyQueue(Queue replyQueue) throws IfsaException {
        if (this.hasDynamicReplyQueue()) {
            this.releaseDynamicReplyQueue(replyQueue);
        }
    }

    public QueueReceiver getReplyReceiver(QueueSession session, Message sentMessage) throws IfsaException {
        QueueReceiver queueReceiver;
        Queue replyQueue;
        String correlationId;
        try {
            correlationId = sentMessage.getJMSMessageID();
            replyQueue = (Queue)sentMessage.getJMSReplyTo();
        }
        catch (JMSException e) {
            throw new IfsaException((Throwable)e);
        }
        try {
            if (this.hasDynamicReplyQueue() && !this.useSingleDynamicReplyQueue()) {
                queueReceiver = session.createReceiver(replyQueue);
                this.log.debug((Object)"created receiver on individual dynamic reply queue");
            } else {
                String selector = "JMSCorrelationID='" + correlationId + "'";
                queueReceiver = session.createReceiver(replyQueue, selector);
                this.log.debug((Object)("created receiver on static or shared-dynamic reply queue - selector [" + selector + "]"));
            }
        }
        catch (JMSException e) {
            throw new IfsaException((Throwable)e);
        }
        return queueReceiver;
    }

    public void closeReplyReceiver(QueueReceiver receiver) throws IfsaException {
        try {
            if (receiver != null) {
                Queue replyQueue = receiver.getQueue();
                receiver.close();
                this.releaseClientReplyQueue(replyQueue);
            }
        }
        catch (JMSException e) {
            throw new IfsaException((Throwable)e);
        }
    }

    public IFSAQueue lookupService(String serviceId) throws IfsaException {
        try {
            return (IFSAQueue)((IFSAContext)this.getContext()).lookupService(serviceId);
        }
        catch (NamingException e) {
            throw new IfsaException("cannot lookup queue for service [" + serviceId + "]", (Throwable)e);
        }
    }

    public IFSAQueue lookupProviderInput() throws IfsaException {
        try {
            return (IFSAQueue)((IFSAContext)this.getContext()).lookupProviderInput();
        }
        catch (NamingException e) {
            throw new IfsaException("cannot lookup provider queue", (Throwable)e);
        }
    }

    protected String replaceLast(String string, char from, char to) {
        int lastTo = string.lastIndexOf(to);
        int lastFrom = string.lastIndexOf(from);
        if (lastFrom > 0 && lastTo < lastFrom) {
            String result = string.substring(0, lastFrom) + to + string.substring(lastFrom + 1);
            this.log.info((Object)("replacing for Ifsa-compatibility [" + string + "] by [" + result + "]"));
            return result;
        }
        return string;
    }

    public String polishServiceId(String serviceId) {
        if (this.preJms22Api) {
            return this.replaceLast(serviceId, '/', ':');
        }
        return this.replaceLast(serviceId, ':', '/');
    }

    public synchronized boolean cleanUpOnClose() {
        if (cleanUpOnClose == null) {
            boolean cleanup = AppConstants.getInstance().getBoolean(CLEANUP_ON_CLOSE_KEY, true);
            cleanUpOnClose = new Boolean(cleanup);
        }
        return cleanUpOnClose;
    }

    protected ConnectionFactory getConnectionFactoryDelegate() throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        return (QueueConnectionFactory)ClassUtils.getDeclaredFieldValue((Object)this.getConnectionFactory(), (String)"qcf");
    }

    public boolean xaCapabilityCanBeDetermined() {
        return !this.preJms22Api;
    }

    public boolean isXaEnabled() {
        return this.xaEnabled;
    }

    public boolean isXaEnabledForSure() {
        return this.xaCapabilityCanBeDetermined() && this.isXaEnabled();
    }

    public boolean isNotXaEnabledForSure() {
        return this.xaCapabilityCanBeDetermined() && !this.isXaEnabled();
    }
}

