/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.jms;

import com.ing.ifsa.IFSAHeader;
import com.ing.ifsa.IFSAMessage;
import com.ing.ifsa.IFSAPoisonMessage;
import com.ing.ifsa.IFSAServiceName;
import com.ing.ifsa.IFSAServicesProvided;
import com.ing.ifsa.IFSATextMessage;
import com.ing.ifsa.IFSAUDZ;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.IListener;
import nl.nn.adapterframework.core.IMessageWrapper;
import nl.nn.adapterframework.core.INamedObject;
import nl.nn.adapterframework.core.IPullingListener;
import nl.nn.adapterframework.core.ListenerException;
import nl.nn.adapterframework.core.PipeLineResult;
import nl.nn.adapterframework.core.PipeLineSessionBase;
import nl.nn.adapterframework.extensions.ifsa.IfsaException;
import nl.nn.adapterframework.extensions.ifsa.IfsaMessageProtocolEnum;
import nl.nn.adapterframework.extensions.ifsa.jms.IfsaFacade;
import nl.nn.adapterframework.receivers.MessageWrapper;
import nl.nn.adapterframework.util.ClassUtils;
import nl.nn.adapterframework.util.DateUtils;
import nl.nn.adapterframework.util.JtaUtil;
import nl.nn.adapterframework.util.RunStateEnquirer;
import nl.nn.adapterframework.util.RunStateEnquiring;
import nl.nn.adapterframework.util.RunStateEnum;
import nl.nn.adapterframework.util.XmlUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PullingIfsaProviderListener
extends IfsaFacade
implements IPullingListener,
INamedObject,
RunStateEnquiring {
    private static final String THREAD_CONTEXT_SESSION_KEY = "session";
    private static final String THREAD_CONTEXT_RECEIVER_KEY = "receiver";
    private static final String THREAD_CONTEXT_ORIGINAL_RAW_MESSAGE_KEY = "originalRawMessage";
    private RunStateEnquirer runStateEnquirer = null;

    public PullingIfsaProviderListener() {
        super(true);
        this.setTimeOut(3000L);
    }

    protected QueueSession getSession(Map threadContext) throws ListenerException {
        if (this.isSessionsArePooled()) {
            try {
                return this.createSession();
            }
            catch (IfsaException e) {
                throw new ListenerException(this.getLogPrefix() + "exception creating QueueSession", (Throwable)e);
            }
        }
        return (QueueSession)threadContext.get(THREAD_CONTEXT_SESSION_KEY);
    }

    protected void releaseSession(Session session) throws ListenerException {
        if (this.isSessionsArePooled()) {
            this.closeSession(session);
        }
    }

    protected QueueReceiver getReceiver(Map threadContext, QueueSession session) throws ListenerException {
        if (this.isSessionsArePooled()) {
            try {
                return this.getServiceReceiver(session);
            }
            catch (IfsaException e) {
                throw new ListenerException(this.getLogPrefix() + "exception creating QueueReceiver", (Throwable)e);
            }
        }
        return (QueueReceiver)threadContext.get(THREAD_CONTEXT_RECEIVER_KEY);
    }

    protected void releaseReceiver(QueueReceiver receiver) throws ListenerException {
        if (this.isSessionsArePooled() && receiver != null) {
            try {
                receiver.close();
            }
            catch (Exception e) {
                throw new ListenerException(this.getLogPrefix() + "exception closing QueueReceiver", (Throwable)e);
            }
        }
    }

    @Override
    public void configure() throws ConfigurationException {
        super.configure();
    }

    public void open() throws ListenerException {
        try {
            this.openService();
            IFSAServicesProvided services = this.getServiceQueue().getIFSAServicesProvided();
            for (int i = 0; i < services.getNumberOfServices(); ++i) {
                IFSAServiceName service = services.getService(i);
                String protocol = service.IsFireAndForgetService() ? "Fire and Forget" : "Request/Reply";
                this.log.info((Object)(this.getLogPrefix() + "providing ServiceName [" + service.getServiceName() + "] ServiceGroup [" + service.getServiceGroup() + "] protocol [" + protocol + "] ServiceVersion [" + service.getServiceVersion() + "]"));
            }
        }
        catch (Exception e) {
            throw new ListenerException(this.getLogPrefix(), (Throwable)e);
        }
    }

    public Map openThread() throws ListenerException {
        HashMap<String, Object> threadContext = new HashMap<String, Object>();
        try {
            if (!this.isSessionsArePooled()) {
                QueueSession session = this.createSession();
                threadContext.put(THREAD_CONTEXT_SESSION_KEY, session);
                QueueReceiver receiver = this.getServiceReceiver(session);
                threadContext.put(THREAD_CONTEXT_RECEIVER_KEY, receiver);
            }
            return threadContext;
        }
        catch (IfsaException e) {
            throw new ListenerException(this.getLogPrefix() + "exception in openThread()", (Throwable)e);
        }
    }

    public void close() throws ListenerException {
        try {
            this.closeService();
        }
        catch (IfsaException e) {
            throw new ListenerException(this.getLogPrefix(), (Throwable)e);
        }
    }

    public void closeThread(Map threadContext) throws ListenerException {
        if (!this.isSessionsArePooled()) {
            QueueReceiver receiver = (QueueReceiver)threadContext.remove(THREAD_CONTEXT_RECEIVER_KEY);
            this.releaseReceiver(receiver);
            QueueSession session = (QueueSession)threadContext.remove(THREAD_CONTEXT_SESSION_KEY);
            this.closeSession((Session)session);
        }
    }

    public void afterMessageProcessed(PipeLineResult plr, Object rawMessage, Map threadContext) throws ListenerException {
        block16: {
            try {
                if (!this.isJmsTransacted() || this.getMessagingSource().isXaEnabledForSure() && JtaUtil.inTransaction()) break block16;
                QueueSession session = (QueueSession)threadContext.get(THREAD_CONTEXT_SESSION_KEY);
                try {
                    session.commit();
                }
                catch (JMSException e) {
                    this.log.error((Object)(this.getLogPrefix() + "got error committing the received message"), (Throwable)e);
                }
                if (this.isSessionsArePooled()) {
                    threadContext.remove(THREAD_CONTEXT_SESSION_KEY);
                    this.releaseSession((Session)session);
                }
            }
            catch (Exception e) {
                this.log.error((Object)(this.getLogPrefix() + "exception in closing or releasing session"), (Throwable)e);
            }
        }
        if (this.getMessageProtocolEnum().equals((Object)IfsaMessageProtocolEnum.REQUEST_REPLY)) {
            Message originalRawMessage = rawMessage instanceof Message ? (Message)rawMessage : (Message)threadContext.get(THREAD_CONTEXT_ORIGINAL_RAW_MESSAGE_KEY);
            if (originalRawMessage == null) {
                String id = (String)threadContext.get("messageId");
                String cid = (String)threadContext.get("cid");
                this.log.warn((Object)(this.getLogPrefix() + "no original raw message found for messageId [" + id + "] correlationId [" + cid + "], cannot send result"));
            } else {
                QueueSession session = this.getSession(threadContext);
                try {
                    String result = "<exception>no result</exception>";
                    if (plr != null && plr.getResult() != null) {
                        result = plr.getResult();
                    }
                    this.sendReply(session, originalRawMessage, result);
                }
                catch (IfsaException e) {
                    try {
                        this.sendReply(session, originalRawMessage, "<exception>" + e.getMessage() + "</exception>");
                    }
                    catch (IfsaException e2) {
                        this.log.warn((Object)(this.getLogPrefix() + "exception sending errormessage as reply"), (Throwable)e2);
                    }
                    throw new ListenerException(this.getLogPrefix() + "Exception on sending result", (Throwable)e);
                }
                finally {
                    this.releaseSession((Session)session);
                }
            }
        }
    }

    protected String getIdFromWrapper(IMessageWrapper wrapper, Map threadContext) {
        for (String key : wrapper.getContext().keySet()) {
            Object value = wrapper.getContext().get(key);
            this.log.debug((Object)(this.getLogPrefix() + "setting variable [" + key + "] to [" + value + "]"));
            threadContext.put(key, value);
        }
        return wrapper.getId();
    }

    protected String getStringFromWrapper(IMessageWrapper wrapper, Map threadContext) {
        return wrapper.getText();
    }

    public String getIdFromRawMessage(Object rawMessage, Map threadContext) throws ListenerException {
        IFSAMessage message = null;
        if (rawMessage instanceof IMessageWrapper) {
            return this.getIdFromWrapper((IMessageWrapper)rawMessage, threadContext);
        }
        try {
            message = (IFSAMessage)rawMessage;
        }
        catch (ClassCastException e) {
            this.log.error((Object)(this.getLogPrefix() + "message received was not of type IFSAMessage, but [" + rawMessage.getClass().getName() + "]"), (Throwable)e);
            return null;
        }
        String mode = "unknown";
        String id = "unset";
        String cid = "unset";
        Date tsSent = null;
        Destination replyTo = null;
        String messageText = null;
        String fullIfsaServiceName = null;
        IFSAServiceName requestedService = null;
        String ifsaServiceName = null;
        String ifsaGroup = null;
        String ifsaOccurrence = null;
        String ifsaVersion = null;
        try {
            if (message.getJMSDeliveryMode() == 1) {
                mode = "NON_PERSISTENT";
            } else if (message.getJMSDeliveryMode() == 2) {
                mode = "PERSISTENT";
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            id = message.getJMSMessageID();
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            cid = message.getJMSCorrelationID();
            if (cid == null) {
                cid = id;
                this.log.debug((Object)"Setting correlation ID to MessageId");
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            long lTimeStamp = message.getJMSTimestamp();
            tsSent = new Date(lTimeStamp);
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            replyTo = message.getJMSReplyTo();
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            messageText = ((TextMessage)message).getText();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            fullIfsaServiceName = message.getServiceString();
            requestedService = message.getService();
            ifsaServiceName = requestedService.getServiceName();
            ifsaGroup = requestedService.getServiceGroup();
            ifsaOccurrence = requestedService.getServiceOccurance();
            ifsaVersion = requestedService.getServiceVersion();
        }
        catch (JMSException e) {
            this.log.error((Object)(this.getLogPrefix() + "got error getting serviceparameter"), (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getLogPrefix() + "got message for [" + fullIfsaServiceName + "] with JMSDeliveryMode=[" + mode + "] \n  JMSMessageID=[" + id + "] \n  JMSCorrelationID=[" + cid + "] \n  ifsaServiceName=[" + ifsaServiceName + "] \n  ifsaGroup=[" + ifsaGroup + "] \n  ifsaOccurrence=[" + ifsaOccurrence + "] \n  ifsaVersion=[" + ifsaVersion + "] \n  Timestamp Sent=[" + DateUtils.format((Date)tsSent) + "] \n  ReplyTo=[" + (replyTo == null ? "none" : replyTo.toString()) + "] \n  MessageHeaders=[" + this.displayHeaders(message) + "\n" + "] \n  Message=[" + message.toString() + "\n]"));
        }
        PipeLineSessionBase.setListenerParameters((Map)threadContext, (String)id, (String)cid, null, (Date)tsSent);
        threadContext.put("timestamp", tsSent);
        threadContext.put("replyTo", replyTo == null ? "none" : replyTo.toString());
        threadContext.put("messageText", messageText);
        threadContext.put("fullIfsaServiceName", fullIfsaServiceName);
        threadContext.put("ifsaServiceName", ifsaServiceName);
        threadContext.put("ifsaGroup", ifsaGroup);
        threadContext.put("ifsaOccurrence", ifsaOccurrence);
        threadContext.put("ifsaVersion", ifsaVersion);
        IFSAUDZ udz = message.getIncomingUDZObject();
        if (udz != null) {
            String contextDump = "ifsaUDZ:";
            for (String key : udz.keySet()) {
                String value = (String)udz.get(key);
                contextDump = contextDump + "\n " + key + "=[" + value + "]";
                threadContext.put(key, value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getLogPrefix() + contextDump));
            }
        }
        return id;
    }

    private String displayHeaders(IFSAMessage message) {
        StringBuffer result = new StringBuffer();
        try {
            Enumeration enumeration = message.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String tagName = (String)enumeration.nextElement();
                Object value = message.getObjectProperty(tagName);
                result.append("\n").append(tagName).append(": ");
                if (value == null) {
                    result.append("null");
                    continue;
                }
                result.append("(").append(ClassUtils.nameOf((Object)value)).append(") [").append(value).append("]");
                if (!tagName.startsWith("ifsa") || tagName.equals("ifsa_unique_id") || tagName.startsWith("ifsa_epz_") || tagName.startsWith("ifsa_udz_")) continue;
                result.append(" * copied when sending reply");
                if (value instanceof String) continue;
                result.append(" THIS CAN CAUSE A PROBLEM AS " + ClassUtils.nameOf((Object)value) + " IS NOT String!");
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"exception parsing headers", t);
        }
        return result.toString();
    }

    private boolean sessionNeedsToBeSavedForAfterProcessMessage(Object result) {
        try {
            return this.isJmsTransacted() && (!this.getMessagingSource().isXaEnabledForSure() || !JtaUtil.inTransaction()) && this.isSessionsArePooled() && result != null && !(result instanceof IFSAPoisonMessage);
        }
        catch (Throwable t) {
            this.log.warn((Object)t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRawMessage(Map threadContext) throws ListenerException {
        Message result = null;
        QueueSession session = null;
        QueueReceiver receiver = null;
        threadContext.remove(THREAD_CONTEXT_ORIGINAL_RAW_MESSAGE_KEY);
        try {
            session = this.getSession(threadContext);
            try {
                receiver = this.getReceiver(threadContext, session);
                result = receiver.receive(this.getTimeOut());
                while (result == null && this.canGoOn() && !JtaUtil.inTransaction()) {
                    result = receiver.receive(this.getTimeOut());
                }
            }
            catch (Exception e) {
                throw new ListenerException(this.getLogPrefix(), (Throwable)e);
            }
            finally {
                this.releaseReceiver(receiver);
            }
        }
        finally {
            if (this.sessionNeedsToBeSavedForAfterProcessMessage(result)) {
                threadContext.put(THREAD_CONTEXT_SESSION_KEY, session);
            } else {
                this.releaseSession((Session)session);
            }
        }
        if (result instanceof IFSAPoisonMessage) {
            String source;
            IFSAHeader header = ((IFSAPoisonMessage)result).getIFSAHeader();
            try {
                source = header.getIFSA_Source();
            }
            catch (Exception e) {
                source = "unknown due to exeption:" + e.getMessage();
            }
            String msg = this.getLogPrefix() + "received IFSAPoisonMessage " + "source [" + source + "]" + "content [" + ToStringBuilder.reflectionToString((Object)((IFSAPoisonMessage)result)) + "]";
            this.log.warn((Object)msg);
        }
        try {
            if ((result instanceof IFSATextMessage || result instanceof IFSAPoisonMessage) && JtaUtil.inTransaction()) {
                threadContext.put(THREAD_CONTEXT_ORIGINAL_RAW_MESSAGE_KEY, result);
                result = new MessageWrapper((Object)result, (IListener)this);
            }
        }
        catch (Exception e) {
            throw new ListenerException("cannot wrap non serialzable message in wrapper", (Throwable)e);
        }
        return result;
    }

    public String getStringFromRawMessage(Object rawMessage, Map threadContext) throws ListenerException {
        if (rawMessage instanceof IMessageWrapper) {
            return this.getStringFromWrapper((IMessageWrapper)rawMessage, threadContext);
        }
        if (rawMessage instanceof IFSAPoisonMessage) {
            String source;
            IFSAPoisonMessage pm = (IFSAPoisonMessage)rawMessage;
            IFSAHeader header = pm.getIFSAHeader();
            try {
                source = header.getIFSA_Source();
            }
            catch (Exception e) {
                source = "unknown due to exeption:" + e.getMessage();
            }
            return "<poisonmessage>  <source>" + source + "</source>" + "  <contents>" + XmlUtils.encodeChars((String)ToStringBuilder.reflectionToString((Object)pm)) + "</contents>" + "</poisonmessage>";
        }
        TextMessage message = null;
        try {
            message = (TextMessage)rawMessage;
        }
        catch (ClassCastException e) {
            this.log.warn((Object)(this.getLogPrefix() + "message received was not of type TextMessage, but [" + rawMessage.getClass().getName() + "]"), (Throwable)e);
            return null;
        }
        try {
            return message.getText();
        }
        catch (JMSException e) {
            throw new ListenerException(this.getLogPrefix(), (Throwable)e);
        }
    }

    protected boolean canGoOn() {
        return this.runStateEnquirer != null && this.runStateEnquirer.isInState(RunStateEnum.STARTED);
    }

    public void SetRunStateEnquirer(RunStateEnquirer enquirer) {
        this.runStateEnquirer = enquirer;
    }
}

