/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.ejb;

import com.ing.ifsa.api.ServiceRequest;
import java.util.Map;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.extensions.ifsa.IfsaMessageProtocolEnum;
import nl.nn.adapterframework.util.LogUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class IfsaEjbBase {
    protected Logger log = LogUtil.getLogger((Object)this);
    protected String name;
    protected String applicationId;
    protected String serviceId;
    protected String polishedServiceId = null;
    protected IfsaMessageProtocolEnum messageProtocol;
    protected long timeOut = -1L;

    protected String getLogPrefix() {
        return "IfsaRequester[" + this.getName() + "] of Application [" + this.getApplicationId() + "] ";
    }

    protected void configure() throws ConfigurationException {
        if (StringUtils.isEmpty((String)this.getApplicationId())) {
            throw new ConfigurationException(this.getLogPrefix() + "applicationId is not specified");
        }
        if (this.getMessageProtocolEnum() == null) {
            throw new ConfigurationException(this.getLogPrefix() + "invalid messageProtocol specified [" + (Object)((Object)this.getMessageProtocolEnum()) + "], should be one of the following " + IfsaMessageProtocolEnum.getNames());
        }
    }

    protected void addUdzMapToRequest(Map udzMap, ServiceRequest request) {
        if (udzMap == null) {
            return;
        }
        for (Map.Entry entry : udzMap.entrySet()) {
            request.setUserDefinedZone(entry.getKey(), entry.getValue());
        }
    }

    public String getPhysicalDestinationName() {
        String result = null;
        try {
            result = this.getServiceId();
        }
        catch (Throwable t) {
            this.log.warn((Object)(this.getLogPrefix() + "got exception in getPhysicalDestinationName"), t);
        }
        return result;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getMessageProtocol() {
        return this.messageProtocol.getName();
    }

    public IfsaMessageProtocolEnum getMessageProtocolEnum() {
        return this.messageProtocol;
    }

    public void setMessageProtocol(String newMessageProtocol) {
        if (null == IfsaMessageProtocolEnum.getEnum(newMessageProtocol)) {
            throw new IllegalArgumentException(this.getLogPrefix() + "illegal messageProtocol [" + newMessageProtocol + "] specified, it should be one of the values " + IfsaMessageProtocolEnum.getNames());
        }
        this.messageProtocol = IfsaMessageProtocolEnum.getEnum(newMessageProtocol);
        this.log.debug((Object)(this.getLogPrefix() + "message protocol set to " + this.messageProtocol.getName()));
    }

    public String getPolishedServiceId() {
        return this.polishedServiceId;
    }

    public void setPolishedServiceId(String polishedServiceId) {
        this.polishedServiceId = polishedServiceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

