/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.ejb;

import com.ing.ifsa.api.ServiceRequest;
import com.ing.ifsa.exceptions.ServiceException;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import nl.nn.adapterframework.core.IListener;
import nl.nn.adapterframework.core.INamedObject;
import nl.nn.adapterframework.core.ListenerException;
import nl.nn.adapterframework.ejb.AbstractListenerConnectingEJB;

public abstract class IfsaEjbBeanBase
extends AbstractListenerConnectingEJB
implements SessionBean {
    protected SessionContext ejbContext;

    public void ejbCreate() throws CreateException {
        this.log.info((Object)"Creating IFSA Handler Session Bean");
        this.onEjbCreate();
    }

    public void ejbRemove() throws EJBException, RemoteException {
        this.log.info((Object)"Removing IFSA Handler Session Bean");
        this.onEjbRemove();
    }

    protected String processRequest(ServiceRequest request) throws ServiceException {
        this.log.debug((Object)">>> processRequest() Processing IFSA Request, generic handling");
        HashMap threadContext = new HashMap();
        try {
            String message = this.listener.getStringFromRawMessage((Object)request, threadContext);
            String cid = this.listener.getIdFromRawMessage((Object)request, threadContext);
            String replyText = this.listener.getHandler().processRequest((IListener)this.listener, cid, message, threadContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("processRequest(): ReplyText=[" + replyText + "]"));
            }
            String string = replyText;
            return string;
        }
        catch (ListenerException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            this.listener.getExceptionListener().exceptionThrown((INamedObject)this.listener, (Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
        finally {
            this.log.debug((Object)"<<< processRequest() finished generic handling");
        }
    }

    public void setSessionContext(SessionContext context) throws EJBException, RemoteException {
        this.ejbContext = context;
    }

    protected EJBContext getEJBContext() {
        return this.ejbContext;
    }

    public void ejbActivate() throws EJBException, RemoteException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

