/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.ejb;

import com.ing.ifsa.api.ServiceRequest;
import com.ing.ifsa.api.ServiceURI;
import java.util.Date;
import java.util.Map;
import javax.jms.Session;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.IListenerConnector;
import nl.nn.adapterframework.core.IMessageHandler;
import nl.nn.adapterframework.core.IPortConnectedListener;
import nl.nn.adapterframework.core.IReceiver;
import nl.nn.adapterframework.core.IbisExceptionListener;
import nl.nn.adapterframework.core.ListenerException;
import nl.nn.adapterframework.core.PipeLineResult;
import nl.nn.adapterframework.extensions.ifsa.ejb.IfsaEjbBase;

public class IfsaProviderListener
extends IfsaEjbBase
implements IPortConnectedListener {
    private IMessageHandler handler;
    private IbisExceptionListener exceptionListener;
    private IReceiver receiver;
    private IListenerConnector listenerPortConnector;

    public void setHandler(IMessageHandler handler) {
        this.handler = handler;
    }

    public void setExceptionListener(IbisExceptionListener listener) {
        this.exceptionListener = listener;
    }

    @Override
    public void configure() throws ConfigurationException {
        super.configure();
        this.listenerPortConnector.configureEndpointConnection((IPortConnectedListener)this, null, null, this.getExceptionListener(), null, 1, false, null, this.timeOut, -1L);
    }

    public void open() throws ListenerException {
        this.listenerPortConnector.start();
    }

    public void close() throws ListenerException {
        this.listenerPortConnector.stop();
    }

    public String getIdFromRawMessage(Object rawMessage, Map threadContext) throws ListenerException {
        ServiceRequest request = (ServiceRequest)rawMessage;
        return request.getUniqueId();
    }

    public String getStringFromRawMessage(Object rawMessage, Map threadContext) throws ListenerException {
        ServiceRequest request = (ServiceRequest)rawMessage;
        return request.getBusinessMessage().getText();
    }

    public void afterMessageProcessed(PipeLineResult processResult, Object rawMessage, Map context) throws ListenerException {
    }

    public IbisExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public IMessageHandler getHandler() {
        return this.handler;
    }

    public IReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(IReceiver receiver) {
        this.receiver = receiver;
    }

    public String getListenerPort() {
        String appIdName = this.getApplicationId().replaceFirst("IFSA://", "");
        return "IFSA_" + appIdName + "_" + this.getMessageProtocol() + "_Listener";
    }

    public IListenerConnector getListenerPortConnector() {
        return this.listenerPortConnector;
    }

    public void setListenerPortConnector(IListenerConnector listenerPortConnector) {
        this.listenerPortConnector = listenerPortConnector;
    }

    public void populateThreadContext(Object rawMessage, Map threadContext, Session session) throws ListenerException {
        String id;
        ServiceRequest request = (ServiceRequest)rawMessage;
        String mode = this.getMessageProtocol().equals("RR") ? "NON_PERSISTENT" : "PERSISTENT";
        String cid = id = request.getUniqueId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Setting correlation ID to MessageId");
        }
        Date dTimeStamp = new Date();
        String messageText = this.getStringFromRawMessage(rawMessage, threadContext);
        String fullIfsaServiceName = null;
        ServiceURI requestedService = request.getServiceURI();
        String ifsaServiceName = null;
        String ifsaGroup = null;
        String ifsaOccurrence = null;
        String ifsaVersion = null;
        ifsaServiceName = requestedService.getService();
        ifsaGroup = requestedService.getGroup();
        ifsaOccurrence = requestedService.getOccurrence();
        ifsaVersion = requestedService.getVersion();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getLogPrefix() + "got message for [" + fullIfsaServiceName + "] with JMSDeliveryMode=[" + mode + "] \n  JMSMessageID=[" + id + "] \n  JMSCorrelationID=[" + cid + "] \n  ifsaServiceName=[" + ifsaServiceName + "] \n  ifsaGroup=[" + ifsaGroup + "] \n  ifsaOccurrence=[" + ifsaOccurrence + "] \n  ifsaVersion=[" + ifsaVersion + "] \n  Timestamp=[" + dTimeStamp.toString() + "] \n  ReplyTo=[none" + "] \n  MessageHeaders=[<unknown>" + "] \n  Message=[" + messageText + "\n]"));
        }
        threadContext.put("id", id);
        threadContext.put("tcid", cid);
        threadContext.put("timestamp", dTimeStamp);
        threadContext.put("replyTo", "none");
        threadContext.put("messageText", messageText);
        threadContext.put("fullIfsaServiceName", fullIfsaServiceName);
        threadContext.put("ifsaServiceName", ifsaServiceName);
        threadContext.put("ifsaGroup", ifsaGroup);
        threadContext.put("ifsaOccurrence", ifsaOccurrence);
        threadContext.put("ifsaVersion", ifsaVersion);
        Map udz = request.getAllUserDefinedZones();
        if (udz != null) {
            String contextDump = "ifsaUDZ:";
            for (String key : udz.keySet()) {
                String value = (String)udz.get(key);
                contextDump = contextDump + "\n " + key + "=[" + value + "]";
                threadContext.put(key, value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getLogPrefix() + contextDump));
            }
        }
    }
}

