/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.ejb;

import com.ing.ifsa.api.BusinessMessage;
import com.ing.ifsa.api.Connection;
import com.ing.ifsa.api.ConnectionManager;
import com.ing.ifsa.api.FireForgetAccessBean;
import com.ing.ifsa.api.RequestReplyAccessBean;
import com.ing.ifsa.api.ServiceReply;
import com.ing.ifsa.api.ServiceRequest;
import com.ing.ifsa.api.ServiceURI;
import java.util.HashMap;
import java.util.Map;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.HasPhysicalDestination;
import nl.nn.adapterframework.core.INamedObject;
import nl.nn.adapterframework.core.ISenderWithParameters;
import nl.nn.adapterframework.core.ParameterException;
import nl.nn.adapterframework.core.SenderException;
import nl.nn.adapterframework.core.TimeOutException;
import nl.nn.adapterframework.extensions.ifsa.IfsaMessageProtocolEnum;
import nl.nn.adapterframework.extensions.ifsa.ejb.IfsaEjbBase;
import nl.nn.adapterframework.parameters.Parameter;
import nl.nn.adapterframework.parameters.ParameterList;
import nl.nn.adapterframework.parameters.ParameterResolutionContext;
import nl.nn.adapterframework.parameters.ParameterValueList;

public class IfsaRequesterSender
extends IfsaEjbBase
implements ISenderWithParameters,
INamedObject,
HasPhysicalDestination {
    protected ParameterList paramList = null;

    @Override
    public void configure() throws ConfigurationException {
        super.configure();
        if (this.paramList != null) {
            this.paramList.configure();
        }
        this.log.info((Object)(this.getLogPrefix() + " configured sender on " + this.getPhysicalDestinationName()));
    }

    public void open() throws SenderException {
    }

    public void close() throws SenderException {
    }

    protected Map convertParametersToMap(ParameterResolutionContext prc) throws SenderException {
        ParameterValueList paramValueList;
        try {
            paramValueList = prc.getValues(this.paramList);
        }
        catch (ParameterException e) {
            throw new SenderException(this.getLogPrefix() + "caught ParameterException in sendMessage() determining serviceId", (Throwable)e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramValueList != null && this.paramList != null) {
            for (int i = 0; i < this.paramList.size(); ++i) {
                String key = this.paramList.getParameter(i).getName();
                String value = paramValueList.getParameterValue(i).asStringValue(null);
                params.put(key, value);
            }
        }
        return params;
    }

    public boolean isSynchronous() {
        return this.getMessageProtocolEnum().equals((Object)IfsaMessageProtocolEnum.REQUEST_REPLY);
    }

    public String sendMessage(String dummyCorrelationId, String message) throws SenderException, TimeOutException {
        return this.sendMessage(dummyCorrelationId, message, (Map)null);
    }

    public String sendMessage(String dummyCorrelationId, String message, ParameterResolutionContext prc) throws SenderException, TimeOutException {
        Map params = this.convertParametersToMap(prc);
        return this.sendMessage(dummyCorrelationId, message, params);
    }

    public String sendMessage(String dummyCorrelationId, String message, Map params) throws SenderException, TimeOutException {
        HashMap udzMap = null;
        try (Connection conn = null;){
            String realServiceId;
            if (params != null && params.size() > 0) {
                String occurrence;
                realServiceId = (String)params.get("serviceId");
                if (realServiceId == null) {
                    realServiceId = this.getServiceId();
                }
                if ((occurrence = (String)params.get("occurrence")) != null) {
                    int i = realServiceId.indexOf(47, realServiceId.indexOf(47, realServiceId.indexOf(47, realServiceId.indexOf(47) + 1) + 1) + 1);
                    int j = realServiceId.indexOf(47, i + 1);
                    realServiceId = realServiceId.substring(0, i + 1) + occurrence + realServiceId.substring(j);
                }
                udzMap = new HashMap(params);
                udzMap.remove("serviceId");
                udzMap.remove("occurrence");
            } else {
                realServiceId = this.getServiceId();
            }
            conn = ConnectionManager.getConnection((String)this.getApplicationId());
            ServiceRequest request = new ServiceRequest(new BusinessMessage(message));
            request.setServiceURI(new ServiceURI(realServiceId));
            this.addUdzMapToRequest(udzMap, request);
            if (this.isSynchronous()) {
                if (this.timeOut > 0L) {
                    request.setTimeout(this.timeOut);
                }
                RequestReplyAccessBean rrBean = RequestReplyAccessBean.getInstance();
                ServiceReply reply = rrBean.sendReceive(conn, request);
                String string = reply.getBusinessMessage().getText();
                return string;
            }
            FireForgetAccessBean ffBean = FireForgetAccessBean.getInstance();
            ffBean.send(conn, request);
            String string = null;
            return string;
        }
    }

    public void addParameter(Parameter p) {
        if (this.paramList == null) {
            this.paramList = new ParameterList();
        }
        this.paramList.add((Object)p);
    }
}

