/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.jms;

import com.ing.ifsa.IFSAQueue;
import com.ing.ifsa.IFSAReportMessage;
import com.ing.ifsa.IFSATimeOutMessage;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.ISenderWithParameters;
import nl.nn.adapterframework.core.ParameterException;
import nl.nn.adapterframework.core.SenderException;
import nl.nn.adapterframework.core.TimeOutException;
import nl.nn.adapterframework.extensions.ifsa.IfsaException;
import nl.nn.adapterframework.extensions.ifsa.IfsaMessageProtocolEnum;
import nl.nn.adapterframework.extensions.ifsa.jms.IfsaFacade;
import nl.nn.adapterframework.parameters.Parameter;
import nl.nn.adapterframework.parameters.ParameterList;
import nl.nn.adapterframework.parameters.ParameterResolutionContext;
import nl.nn.adapterframework.parameters.ParameterValueList;
import nl.nn.adapterframework.statistics.HasStatistics;
import nl.nn.adapterframework.statistics.StatisticsKeeper;
import nl.nn.adapterframework.statistics.StatisticsKeeperIterationHandler;
import nl.nn.adapterframework.util.AppConstants;
import nl.nn.adapterframework.util.DateUtils;
import nl.nn.adapterframework.util.JtaUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class IfsaRequesterSender
extends IfsaFacade
implements ISenderWithParameters,
HasStatistics {
    private boolean throwExceptions = true;
    protected String bifNameSessionKey;
    protected ParameterList paramList = null;
    private StatisticsKeeper businessProcessTimes;

    public IfsaRequesterSender() {
        super(false);
    }

    @Override
    public void configure() throws ConfigurationException {
        super.configure();
        if (this.paramList != null) {
            this.paramList.configure();
        }
        this.log.info((Object)(this.getLogPrefix() + " configured sender on " + this.getPhysicalDestinationName()));
    }

    public void open() throws SenderException {
        try {
            this.openService();
        }
        catch (IfsaException e) {
            throw new SenderException(this.getLogPrefix() + "could not start Sender", (Throwable)e);
        }
    }

    public void close() throws SenderException {
        try {
            this.closeService();
        }
        catch (Throwable e) {
            throw new SenderException(this.getLogPrefix() + "got error occured stopping sender", e);
        }
    }

    public boolean isSynchronous() {
        return this.getMessageProtocolEnum().equals((Object)IfsaMessageProtocolEnum.REQUEST_REPLY);
    }

    private Message getRawReplyMessage(QueueSession session, IFSAQueue queue, TextMessage sentMessage) throws SenderException, TimeOutException {
        String selector = null;
        Message msg = null;
        QueueReceiver replyReceiver = null;
        try {
            replyReceiver = this.getReplyReceiver(session, (Message)sentMessage);
            selector = replyReceiver.getMessageSelector();
            long timeout = this.getExpiry(queue);
            this.log.debug((Object)(this.getLogPrefix() + "start waiting at most [" + timeout + "] ms for reply on message using selector [" + selector + "]"));
            msg = replyReceiver.receive(timeout);
            if (msg == null) {
                this.log.info((Object)(this.getLogPrefix() + "received null reply"));
            } else {
                this.log.info((Object)(this.getLogPrefix() + "received reply"));
            }
        }
        catch (Exception e) {
            throw new SenderException(this.getLogPrefix() + "got exception retrieving reply", (Throwable)e);
        }
        finally {
            try {
                this.closeReplyReceiver(replyReceiver);
            }
            catch (IfsaException e) {
                this.log.error((Object)(this.getLogPrefix() + "error closing replyreceiver"), (Throwable)e);
            }
        }
        if (msg == null) {
            throw new TimeOutException(this.getLogPrefix() + " timed out waiting for reply using selector [" + selector + "]");
        }
        if (msg instanceof IFSATimeOutMessage) {
            throw new TimeOutException(this.getLogPrefix() + "received IFSATimeOutMessage waiting for reply using selector [" + selector + "]");
        }
        return msg;
    }

    public String sendMessage(String message) throws SenderException, TimeOutException {
        return this.sendMessage(null, message, (Map)null);
    }

    public String sendMessage(String dummyCorrelationId, String message) throws SenderException, TimeOutException {
        return this.sendMessage(dummyCorrelationId, message, (Map)null);
    }

    public String sendMessage(String dummyCorrelationId, String message, ParameterResolutionContext prc) throws SenderException, TimeOutException {
        String BIF;
        ParameterValueList paramValueList;
        try {
            if (this.isSynchronous()) {
                if (JtaUtil.inTransaction()) {
                    throw new SenderException("cannot send RR message from within a transaction");
                }
            } else if (!JtaUtil.inTransaction()) {
                this.log.warn((Object)"FF messages should be sent from within a transaction");
            }
        }
        catch (Exception e) {
            throw new SenderException((Throwable)e);
        }
        try {
            paramValueList = prc.getValues(this.paramList);
        }
        catch (ParameterException e) {
            throw new SenderException(this.getLogPrefix() + "caught ParameterException in sendMessage() determining serviceId", (Throwable)e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramValueList != null && this.paramList != null) {
            for (int i = 0; i < this.paramList.size(); ++i) {
                String key = this.paramList.getParameter(i).getName();
                String value = paramValueList.getParameterValue(i).asStringValue(null);
                params.put(key, value);
            }
        }
        if (StringUtils.isEmpty((String)(BIF = (String)prc.getSession().get((Object)this.getBifNameSessionKey())))) {
            BIF = (String)prc.getSession().get((Object)"IfsaBif");
        }
        return this.sendMessage(dummyCorrelationId, message, params, BIF, null);
    }

    public String sendMessage(String dummyCorrelationId, String message, Map params) throws SenderException, TimeOutException {
        return this.sendMessage(dummyCorrelationId, message, params, null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendMessage(String dummyCorrelationId, String message, Map params, String bifName, byte[] btcData) throws SenderException, TimeOutException {
        QueueSession session;
        String result;
        block31: {
            result = null;
            session = null;
            QueueSender sender = null;
            HashMap udzMap = null;
            try {
                block30: {
                    TextMessage sentMessage;
                    block32: {
                        block33: {
                            IFSAQueue queue;
                            this.log.debug((Object)(this.getLogPrefix() + "creating session and sender"));
                            session = this.createSession();
                            if (params != null && params.size() > 0) {
                                String occurrence;
                                String serviceId = (String)params.get("serviceId");
                                if (serviceId == null) {
                                    serviceId = this.getServiceId();
                                }
                                if ((occurrence = (String)params.get("occurrence")) != null) {
                                    int i = serviceId.indexOf(47, serviceId.indexOf(47, serviceId.indexOf(47, serviceId.indexOf(47) + 1) + 1) + 1);
                                    int j = serviceId.indexOf(47, i + 1);
                                    serviceId = serviceId.substring(0, i + 1) + occurrence + serviceId.substring(j);
                                }
                                if ((queue = this.getMessagingSource().lookupService(this.getMessagingSource().polishServiceId(serviceId))) == null) {
                                    throw new SenderException(this.getLogPrefix() + "got null as queue for serviceId [" + serviceId + "]");
                                }
                                if (this.log.isDebugEnabled()) {
                                    this.log.info((Object)(this.getLogPrefix() + "got Queue to send messages on [" + queue.getQueueName() + "]"));
                                }
                                udzMap = new HashMap();
                                udzMap.putAll(params);
                                udzMap.remove("serviceId");
                                udzMap.remove("occurrence");
                            } else {
                                queue = this.getServiceQueue();
                            }
                            sender = this.createSender(session, (Queue)queue);
                            this.log.debug((Object)(this.getLogPrefix() + "sending message with bifName [" + bifName + "]"));
                            sentMessage = this.sendMessage(session, sender, message, udzMap, bifName, btcData);
                            this.log.debug((Object)(this.getLogPrefix() + "message sent"));
                            if (!this.isSynchronous()) break block32;
                            this.log.debug((Object)(this.getLogPrefix() + "waiting for reply"));
                            Message msg = this.getRawReplyMessage(session, queue, sentMessage);
                            try {
                                long tsReplyReceived = System.currentTimeMillis();
                                long tsRequestSent = sentMessage.getJMSTimestamp();
                                long tsReplySent = msg.getJMSTimestamp();
                                if (this.log.isInfoEnabled()) {
                                    this.log.info((Object)(this.getLogPrefix() + "A) RequestSent   [" + DateUtils.format((long)tsRequestSent) + "]"));
                                    this.log.info((Object)(this.getLogPrefix() + "B) ReplySent     [" + DateUtils.format((long)tsReplySent) + "] diff (~queing + processing) [" + (tsReplySent - tsRequestSent) + "]"));
                                    this.log.info((Object)(this.getLogPrefix() + "C) ReplyReceived [" + DateUtils.format((long)tsReplyReceived) + "] diff (transport of reply )[" + (tsReplyReceived - tsReplySent) + "]"));
                                }
                            }
                            catch (JMSException e) {
                                this.log.warn((Object)(this.getLogPrefix() + "exception determining processing times"), (Throwable)e);
                            }
                            if (msg instanceof TextMessage) {
                                result = ((TextMessage)msg).getText();
                            } else if (msg.getClass().getName().endsWith("IFSAReportMessage")) {
                                if (msg instanceof IFSAReportMessage) {
                                    IFSAReportMessage irm = (IFSAReportMessage)msg;
                                    if (this.isThrowExceptions()) {
                                        throw new SenderException(this.getLogPrefix() + "received IFSAReportMessage [" + ToStringBuilder.reflectionToString((Object)irm) + "], NoReplyReason [" + irm.getNoReplyReason() + "]");
                                    }
                                    this.log.warn((Object)(this.getLogPrefix() + "received IFSAReportMessage [" + ToStringBuilder.reflectionToString((Object)irm) + "], NoReplyReason [" + irm.getNoReplyReason() + "]"));
                                    result = "<IFSAReport><NoReplyReason>" + irm.getNoReplyReason() + "</NoReplyReason>" + "</IFSAReport>";
                                }
                            } else {
                                this.log.warn((Object)(this.getLogPrefix() + "received neither TextMessage nor IFSAReportMessage but [" + msg.getClass().getName() + "]"));
                                result = msg.toString();
                            }
                            if (result != null) break block33;
                            this.log.info((Object)(this.getLogPrefix() + "received null reply"));
                            break block30;
                        }
                        if (this.log.isDebugEnabled()) {
                            if (AppConstants.getInstance().getBoolean("log.logIntermediaryResults", false)) {
                                this.log.debug((Object)(this.getLogPrefix() + "received reply [" + result + "]"));
                                break block30;
                            } else {
                                this.log.debug((Object)(this.getLogPrefix() + "received reply"));
                            }
                            break block30;
                        } else {
                            this.log.info((Object)(this.getLogPrefix() + "received reply"));
                        }
                        break block30;
                    }
                    result = sentMessage.getJMSMessageID();
                }
                if (sender == null) break block31;
            }
            catch (JMSException e) {
                try {
                    throw new SenderException(this.getLogPrefix() + "caught JMSException in sendMessage()", (Throwable)e);
                    catch (IfsaException e2) {
                        throw new SenderException(this.getLogPrefix() + "caught IfsaException in sendMessage()", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (sender != null) {
                        try {
                            this.log.debug((Object)(this.getLogPrefix() + "closing sender"));
                            sender.close();
                        }
                        catch (JMSException e3) {
                            this.log.debug((Object)(this.getLogPrefix() + "Exception closing sender"), (Throwable)e3);
                        }
                    }
                    this.closeSession((Session)session);
                    throw throwable;
                }
            }
            try {
                this.log.debug((Object)(this.getLogPrefix() + "closing sender"));
                sender.close();
            }
            catch (JMSException e) {
                this.log.debug((Object)(this.getLogPrefix() + "Exception closing sender"), (Throwable)e);
            }
        }
        this.closeSession((Session)session);
        if (this.isThrowExceptions() && result != null && result.startsWith("<exception>")) {
            throw new SenderException("Retrieved exception message from IFSA bus: " + result);
        }
        return result;
    }

    public void iterateOverStatistics(StatisticsKeeperIterationHandler hski, Object data, int action) throws SenderException {
        if (this.businessProcessTimes != null) {
            hski.handleStatisticsKeeper(data, this.businessProcessTimes);
            this.businessProcessTimes.performAction(action);
        }
    }

    @Override
    public String toString() {
        String result = super.toString();
        ToStringBuilder ts = new ToStringBuilder((Object)this);
        result = result + ts.toString();
        return result;
    }

    public void addParameter(Parameter p) {
        if (this.paramList == null) {
            this.paramList = new ParameterList();
        }
        this.paramList.add((Object)p);
    }

    public void setThrowExceptions(boolean b) {
        this.throwExceptions = b;
    }

    public boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    public void setBifNameSessionKey(String bifnameSessionKey) {
        this.bifNameSessionKey = bifnameSessionKey;
    }

    public String getBifNameSessionKey() {
        return this.bifNameSessionKey;
    }
}

