/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.webcontrol.pipes;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.IPipe;
import nl.nn.adapterframework.core.IPipeLineSession;
import nl.nn.adapterframework.core.PipeRunException;
import nl.nn.adapterframework.core.SenderException;
import nl.nn.adapterframework.core.TimeOutException;
import nl.nn.adapterframework.extensions.ifsa.IfsaRequesterSender;
import nl.nn.adapterframework.pipes.TimeoutGuardPipe;
import nl.nn.adapterframework.util.Misc;
import nl.nn.adapterframework.util.XmlBuilder;
import nl.nn.adapterframework.util.XmlUtils;
import org.apache.commons.lang.StringUtils;

public class TestIfsaService
extends TimeoutGuardPipe {
    public String doPipeWithTimeoutGuarded(Object input, IPipeLineSession session) throws PipeRunException {
        String method = (String)session.get((Object)"method");
        if (method.equalsIgnoreCase("GET")) {
            return this.doGet(session);
        }
        if (method.equalsIgnoreCase("POST")) {
            return this.doPost(session);
        }
        throw new PipeRunException((IPipe)this, this.getLogPrefix(session) + "illegal value for method [" + method + "], must be 'GET' or 'POST'");
    }

    private String doGet(IPipeLineSession session) throws PipeRunException {
        return this.retrieveFormInput(session);
    }

    /*
     * Unable to fully structure code
     */
    private String doPost(IPipeLineSession session) throws PipeRunException {
        form_file = session.get((Object)"file");
        form_message = null;
        form_message = (String)session.get((Object)"message");
        if (form_file == null && StringUtils.isEmpty((String)form_message)) {
            throw new PipeRunException((IPipe)this, this.getLogPrefix(session) + "Nothing to send or test");
        }
        form_applicationId = (String)session.get((Object)"applicationId");
        form_serviceId = (String)session.get((Object)"serviceId");
        form_messageProtocol = (String)session.get((Object)"messageProtocol");
        if (form_file != null) {
            if (form_file instanceof InputStream) {
                inputStream = (InputStream)form_file;
                form_fileName = (String)session.get((Object)"fileName");
                form_fileEncoding = (String)session.get((Object)"fileEncoding");
                try {
                    if (inputStream.available() <= 0) ** GOTO lbl28
                    fileEncoding = StringUtils.isNotEmpty((String)form_fileEncoding) != false ? form_fileEncoding : "UTF-8";
                    if (StringUtils.endsWithIgnoreCase((String)form_fileName, (String)".zip")) {
                        try {
                            form_message = this.processZipFile(session, inputStream, fileEncoding, form_applicationId, form_serviceId, form_messageProtocol);
                        }
                        catch (Exception e) {
                            throw new PipeRunException((IPipe)this, this.getLogPrefix(session) + "exception on processing zip file", (Throwable)e);
                        }
                    }
                    form_message = Misc.streamToString((InputStream)inputStream, (String)"\n", (String)fileEncoding, (boolean)false);
                }
                catch (IOException e) {
                    throw new PipeRunException((IPipe)this, this.getLogPrefix(session) + "exception on converting stream to string", (Throwable)e);
                }
            } else {
                form_message = form_file.toString();
            }
lbl28:
            // 4 sources

            session.put((Object)"message", (Object)form_message);
        }
        if (StringUtils.isNotEmpty((String)form_message)) {
            try {
                result = this.processMessage(form_applicationId, form_serviceId, form_messageProtocol, form_message);
                session.put((Object)"result", (Object)result);
            }
            catch (Exception e) {
                throw new PipeRunException((IPipe)this, this.getLogPrefix(session) + "exception on sending message", (Throwable)e);
            }
        }
        return "<dummy/>";
    }

    private String processZipFile(IPipeLineSession session, InputStream inputStream, String fileEncoding, String applicationId, String serviceId, String messageProtocol) throws IOException {
        String result = "";
        String lastState = null;
        ZipInputStream archive = new ZipInputStream(inputStream);
        ZipEntry entry = archive.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            int size = (int)entry.getSize();
            if (size > 0) {
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = archive.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                String message = XmlUtils.readXml((byte[])b, (int)0, (int)rb, (String)fileEncoding, (boolean)false);
                if (StringUtils.isNotEmpty((String)result)) {
                    result = result + "\n";
                }
                try {
                    this.processMessage(applicationId, serviceId, messageProtocol, message);
                    lastState = "success";
                }
                catch (Exception e) {
                    lastState = "error";
                }
                result = result + name + ":" + lastState;
            }
            archive.closeEntry();
            entry = archive.getNextEntry();
        }
        archive.close();
        session.put((Object)"result", (Object)result);
        return "";
    }

    private String processMessage(String applicationId, String serviceId, String messageProtocol, String message) throws ConfigurationException, SenderException, TimeOutException {
        IfsaRequesterSender sender = new IfsaRequesterSender();
        sender.setName("testIfsaServiceAction");
        sender.setApplicationId(applicationId);
        sender.setServiceId(serviceId);
        sender.setMessageProtocol(messageProtocol);
        sender.configure();
        sender.open();
        return sender.sendMessage("testmsg_" + Misc.createUUID(), message);
    }

    private String retrieveFormInput(IPipeLineSession session) {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("RR");
        protocols.add("FF");
        XmlBuilder protocolsXML = new XmlBuilder("protocols");
        for (int i = 0; i < protocols.size(); ++i) {
            XmlBuilder protocolXML = new XmlBuilder("protocol");
            protocolXML.setValue((String)protocols.get(i));
            protocolsXML.addSubElement(protocolXML);
        }
        return protocolsXML.toXML();
    }
}

