/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.ejb;

import com.ing.ifsa.api.FireForgetService;
import com.ing.ifsa.api.RequestReplyService;
import com.ing.ifsa.internal.exceptions.InvalidServiceException;
import com.ing.ifsa.internal.exceptions.UnknownServiceException;
import com.ing.ifsa.provider.ServiceLocatorEJB;
import com.ing.ifsa.utils.NamingHelper;
import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import nl.nn.adapterframework.util.LogUtil;
import org.apache.log4j.Logger;

public class CustomIfsaServiceLocatorEJB
extends ServiceLocatorEJB {
    private static final Logger log = LogUtil.getLogger(CustomIfsaServiceLocatorEJB.class);
    public static final String SERVICE_DISPATCHER_EJB_NAME = "java:comp/env/ejb/ibis/ServiceDispatcher";
    protected final NamingHelper namingHelper = new NamingHelper();

    public FireForgetService getFireForgetService(String service) throws UnknownServiceException, InvalidServiceException {
        try {
            return super.getFireForgetService(service);
        }
        catch (UnknownServiceException e) {
            log.warn((Object)("Can not find EJB Bean for FF service [" + service + "], will look up generic FF service dispatcher EJB; original excpetion message: " + e.getMessage()));
            FireForgetService serviceDispatcherBean = (FireForgetService)this.getBeanFromJNDI(SERVICE_DISPATCHER_EJB_NAME);
            log.debug((Object)("Service [" + service + "] will be handled by generic FF service dispatcher bean [" + serviceDispatcherBean.toString() + "]"));
            return serviceDispatcherBean;
        }
    }

    public RequestReplyService getRequestReplyService(String service) throws UnknownServiceException, InvalidServiceException {
        try {
            return super.getRequestReplyService(service);
        }
        catch (UnknownServiceException e) {
            log.warn((Object)("Can not find EJB Bean for RR service [" + service + "], will look up generic RR service dispatcher EJB; original excpetion message: " + e.getMessage()));
            RequestReplyService serviceDispatcherBean = (RequestReplyService)this.getBeanFromJNDI(SERVICE_DISPATCHER_EJB_NAME);
            log.debug((Object)("Service [" + service + "] will be handled by generic RR service dispatcher bean [" + serviceDispatcherBean.toString() + "]"));
            return serviceDispatcherBean;
        }
    }

    protected Object getBeanFromJNDI(String beanHomeJNDIName) throws UnknownServiceException, InvalidServiceException {
        try {
            Object obj = this.namingHelper.lookup(beanHomeJNDIName);
            EJBHome svcHome = (EJBHome)PortableRemoteObject.narrow((Object)obj, EJBHome.class);
            Class<?> homeClass = svcHome.getClass();
            Method createMethod = homeClass.getMethod("create", null);
            Object remoteSvc = createMethod.invoke((Object)svcHome, new Object[0]);
            return remoteSvc;
        }
        catch (ClassCastException e) {
            log.error((Object)("Error creating EJB bean from JNDI Looking [" + beanHomeJNDIName + "]"), (Throwable)e);
            throw new InvalidServiceException("Can not find bean home interface [" + beanHomeJNDIName + "]", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            log.error((Object)("Can not find EJB bean in JNDI: [" + beanHomeJNDIName + "]"), (Throwable)e);
            throw new UnknownServiceException("Can not find bean home interface [" + beanHomeJNDIName + "]", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)("Can not find EJB bean in JNDI: [" + beanHomeJNDIName + "]"), (Throwable)e);
            throw new UnknownServiceException("JNDI error looking up bean home interface [" + beanHomeJNDIName + "]", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new InvalidServiceException("Can not create bean [" + beanHomeJNDIName + "]", (Throwable)e);
        }
    }
}

