/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.jms;

import com.ing.ifsa.IFSAMessage;
import com.ing.ifsa.IFSAQueue;
import com.ing.ifsa.IFSAQueueSender;
import com.ing.ifsa.IFSAServerQueueSender;
import com.ing.ifsa.IFSATextMessage;
import com.ing.ifsa.IFSAUDZ;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.HasPhysicalDestination;
import nl.nn.adapterframework.core.INamedObject;
import nl.nn.adapterframework.core.IbisException;
import nl.nn.adapterframework.extensions.ifsa.IfsaException;
import nl.nn.adapterframework.extensions.ifsa.IfsaMessageProtocolEnum;
import nl.nn.adapterframework.extensions.ifsa.jms.IfsaMessagingSource;
import nl.nn.adapterframework.extensions.ifsa.jms.IfsaMessagingSourceFactory;
import nl.nn.adapterframework.util.AppConstants;
import nl.nn.adapterframework.util.JtaUtil;
import nl.nn.adapterframework.util.LogUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class IfsaFacade
implements INamedObject,
HasPhysicalDestination {
    protected Logger log = LogUtil.getLogger((Object)this);
    private static final String USE_SELECTOR_FOR_PROVIDER_KEY = "ifsa.provider.useSelectors";
    private static final int DEFAULT_PROVIDER_ACKNOWLEDGMODE_RR = 2;
    private static final int DEFAULT_PROVIDER_ACKNOWLEDGMODE_FF = 1;
    private static final int DEFAULT_REQUESTER_ACKNOWLEDGMODE_RR = 1;
    private static final int DEFAULT_REQUESTER_ACKNOWLEDGMODE_FF = 1;
    private static Boolean useSelectorsStore = null;
    private int ackMode = -1;
    private String name;
    private String applicationId;
    private String serviceId;
    private String polishedServiceId = null;
    private IfsaMessageProtocolEnum messageProtocol;
    private long timeOut = 20000L;
    private IFSAQueue queue;
    private IfsaMessagingSource messagingSource = null;
    private boolean requestor = false;
    private boolean provider = false;
    private String providerSelector = null;

    public IfsaFacade(boolean asProvider) {
        if (asProvider) {
            this.provider = true;
        } else {
            this.requestor = true;
        }
    }

    protected String getLogPrefix() {
        String objectType;
        String serviceInfo = "";
        try {
            if (this.isRequestor()) {
                objectType = "IfsaRequester";
                serviceInfo = "of Application [" + this.getApplicationId() + "] " + (this.polishedServiceId != null ? "to Service [" + this.polishedServiceId + "] " : "");
            } else {
                objectType = "IfsaProvider";
                serviceInfo = "for Application [" + this.getApplicationId() + "] ";
            }
        }
        catch (IfsaException e) {
            this.log.debug((Object)"Exception determining objectType in getLogPrefix", (Throwable)e);
            objectType = "Object";
            serviceInfo = "of Application [" + this.getApplicationId() + "]";
        }
        return objectType + "[" + this.getName() + "] " + serviceInfo;
    }

    public void configure() throws ConfigurationException {
        block10: {
            if (StringUtils.isEmpty((String)this.getApplicationId())) {
                throw new ConfigurationException(this.getLogPrefix() + "applicationId is not specified");
            }
            if (this.getMessageProtocolEnum() == null) {
                throw new ConfigurationException(this.getLogPrefix() + "invalid messageProtocol specified [" + (Object)((Object)this.getMessageProtocolEnum()) + "], should be one of the following " + IfsaMessageProtocolEnum.getNames());
            }
            try {
                if (this.getAckMode() >= 0) break block10;
                if (this.getMessageProtocolEnum() == IfsaMessageProtocolEnum.FIRE_AND_FORGET) {
                    if (this.isRequestor()) {
                        this.setAckMode(1);
                    } else {
                        this.setAckMode(1);
                    }
                    break block10;
                }
                if (this.getMessageProtocolEnum() == IfsaMessageProtocolEnum.REQUEST_REPLY) {
                    if (this.isRequestor()) {
                        this.setAckMode(1);
                    } else {
                        this.setAckMode(2);
                    }
                    break block10;
                }
                throw new ConfigurationException(this.getLogPrefix() + "illegal messageProtocol");
            }
            catch (IfsaException e) {
                throw new ConfigurationException(this.getLogPrefix() + "cannot set acknowledgemode", (Throwable)e);
            }
        }
    }

    protected void cleanUpAfterException() {
        try {
            this.closeService();
        }
        catch (IfsaException e) {
            this.log.warn((Object)"exception closing ifsaConnection after previous exception, current:", (Throwable)e);
        }
    }

    public void openService() throws IfsaException {
        try {
            this.log.debug((Object)(this.getLogPrefix() + "opening connection for service"));
            this.getMessagingSource();
            this.getServiceQueue();
        }
        catch (IfsaException e) {
            this.cleanUpAfterException();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeService() throws IfsaException {
        block6: {
            try {
                if (this.messagingSource == null) break block6;
                try {
                    this.messagingSource.close();
                }
                catch (IbisException e) {
                    if (e instanceof IfsaException) {
                        throw (IfsaException)((Object)e);
                    }
                    throw new IfsaException((Throwable)e);
                }
                this.log.debug((Object)(this.getLogPrefix() + "closed connection for service"));
            }
            finally {
                this.queue = null;
                this.messagingSource = null;
            }
        }
    }

    protected IFSAQueue getServiceQueue() throws IfsaException {
        if (this.queue == null) {
            if (this.isRequestor()) {
                if (this.getServiceId() != null) {
                    this.queue = this.getMessagingSource().lookupService(this.getServiceId());
                    if (this.log.isDebugEnabled()) {
                        this.log.info((Object)(this.getLogPrefix() + "got Queue to send messages on " + this.getPhysicalDestinationName()));
                    }
                }
            } else {
                this.queue = this.getMessagingSource().lookupProviderInput();
                if (this.log.isDebugEnabled()) {
                    this.log.info((Object)(this.getLogPrefix() + "got Queue to receive messages from " + this.getPhysicalDestinationName()));
                }
            }
        }
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IfsaMessagingSource getMessagingSource() throws IfsaException {
        if (this.messagingSource == null) {
            IfsaFacade ifsaFacade = this;
            synchronized (ifsaFacade) {
                if (this.messagingSource == null) {
                    this.log.debug((Object)(this.getLogPrefix() + "instantiating IfsaConnectionFactory"));
                    IfsaMessagingSourceFactory ifsaConnectionFactory = new IfsaMessagingSourceFactory();
                    try {
                        this.log.debug((Object)(this.getLogPrefix() + "creating IfsaConnection"));
                        this.messagingSource = (IfsaMessagingSource)ifsaConnectionFactory.getConnection(this.getApplicationId());
                    }
                    catch (IbisException e) {
                        if (e instanceof IfsaException) {
                            throw (IfsaException)((Object)e);
                        }
                        throw new IfsaException((Throwable)e);
                    }
                }
            }
        }
        return this.messagingSource;
    }

    protected QueueSession createSession() throws IfsaException {
        try {
            int mode = this.getAckMode();
            if (this.isRequestor() && this.messagingSource.canUseIfsaModeSessions()) {
                mode += 100;
            }
            return (QueueSession)this.messagingSource.createSession(this.isJmsTransacted(), mode);
        }
        catch (IbisException e) {
            if (e instanceof IfsaException) {
                throw (IfsaException)((Object)e);
            }
            throw new IfsaException((Throwable)e);
        }
    }

    protected void closeSession(Session session) {
        try {
            this.getMessagingSource().releaseSession(session);
        }
        catch (IfsaException e) {
            this.log.warn((Object)"Exception releasing session", (Throwable)e);
        }
    }

    protected QueueSender createSender(QueueSession session, Queue queue) throws IfsaException {
        try {
            QueueSender queueSender = session.createSender(queue);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getLogPrefix() + "got queueSender [" + ToStringBuilder.reflectionToString((Object)((IFSAQueueSender)queueSender)) + "]"));
            }
            return queueSender;
        }
        catch (Exception e) {
            throw new IfsaException((Throwable)e);
        }
    }

    protected synchronized String getProviderSelector() {
        if (this.providerSelector == null && this.useSelectorsForProviders()) {
            try {
                this.providerSelector = "";
                if (this.messageProtocol.equals((Object)IfsaMessageProtocolEnum.REQUEST_REPLY)) {
                    this.providerSelector = "RR";
                }
                if (this.messageProtocol.equals((Object)IfsaMessageProtocolEnum.FIRE_AND_FORGET)) {
                    this.providerSelector = "FF";
                }
            }
            catch (Throwable t) {
                this.log.debug((Object)(this.getLogPrefix() + "exception determining selector, probably lower ifsa version, ignoring"));
            }
        }
        return this.providerSelector;
    }

    protected QueueReceiver getServiceReceiver(QueueSession session) throws IfsaException {
        try {
            QueueReceiver queueReceiver;
            if (this.isProvider()) {
                String selector = this.getProviderSelector();
                if (StringUtils.isEmpty((String)selector)) {
                    queueReceiver = session.createReceiver((Queue)this.getServiceQueue());
                } else {
                    try {
                        queueReceiver = session.createReceiver((Queue)this.getServiceQueue(), selector);
                    }
                    catch (JMSException e) {
                        this.log.warn((Object)("caught exception, probably due to use of selector [" + selector + "], falling back to non-selected mode"), (Throwable)e);
                        queueReceiver = session.createReceiver((Queue)this.getServiceQueue());
                    }
                }
            } else {
                throw new IfsaException("cannot obtain ServiceReceiver: Requestor cannot act as Provider");
            }
            if (this.log.isDebugEnabled() && !this.isSessionsArePooled()) {
                this.log.debug((Object)(this.getLogPrefix() + "got receiver for queue [" + queueReceiver.getQueue().getQueueName() + "] " + ToStringBuilder.reflectionToString((Object)queueReceiver)));
            }
            return queueReceiver;
        }
        catch (JMSException e) {
            throw new IfsaException((Throwable)e);
        }
    }

    public long getExpiry() throws IfsaException {
        return this.getExpiry(this.getServiceQueue());
    }

    public long getExpiry(IFSAQueue queue) throws IfsaException {
        long expiry = this.getTimeOut();
        if (expiry >= 0L) {
            return expiry;
        }
        try {
            return queue.getExpiry();
        }
        catch (JMSException e) {
            throw new IfsaException("error retrieving timeOut value", (Throwable)e);
        }
    }

    public String getMessageProtocol() {
        if (this.messageProtocol == null) {
            return null;
        }
        return this.messageProtocol.getName();
    }

    public IfsaMessageProtocolEnum getMessageProtocolEnum() {
        return this.messageProtocol;
    }

    public QueueReceiver getReplyReceiver(QueueSession session, Message sentMessage) throws IfsaException {
        if (this.isProvider()) {
            throw new IfsaException("cannot get ReplyReceiver: Provider cannot act as Requestor");
        }
        return this.getMessagingSource().getReplyReceiver(session, sentMessage);
    }

    public void closeReplyReceiver(QueueReceiver receiver) throws IfsaException {
        this.log.debug((Object)(this.getLogPrefix() + "closing replyreceiver"));
        this.getMessagingSource().closeReplyReceiver(receiver);
    }

    public boolean isRequestor() throws IfsaException {
        if (this.requestor && this.provider) {
            throw new IfsaException("cannot be both Requestor and Provider");
        }
        if (!this.requestor && !this.provider) {
            throw new IfsaException("not configured as Requestor or Provider");
        }
        return this.requestor;
    }

    public boolean isProvider() throws IfsaException {
        return !this.isRequestor();
    }

    public TextMessage sendMessage(QueueSession session, QueueSender sender, String message, Map udzMap, String bifName, byte[] btcData) throws IfsaException {
        try {
            if (!this.isRequestor()) {
                throw new IfsaException(this.getLogPrefix() + "Provider cannot use sendMessage, should use sendReply");
            }
            IFSATextMessage msg = (IFSATextMessage)session.createTextMessage();
            msg.setText(message);
            if (udzMap != null && msg instanceof IFSAMessage) {
                this.log.debug((Object)(this.getLogPrefix() + "add UDZ map to IFSAMessage"));
                IFSAUDZ udzObject = msg.getOutgoingUDZObject();
                udzObject.putAll(udzMap);
            }
            String replyToQueueName = "-";
            if (this.messageProtocol.equals((Object)IfsaMessageProtocolEnum.REQUEST_REPLY)) {
                Queue replyTo = this.getMessagingSource().getClientReplyQueue(session);
                msg.setJMSReplyTo((Destination)replyTo);
                replyToQueueName = replyTo.getQueueName();
            }
            if (this.messageProtocol.equals((Object)IfsaMessageProtocolEnum.FIRE_AND_FORGET)) {
                // empty if block
            }
            if (StringUtils.isNotEmpty((String)bifName)) {
                msg.setBifName(bifName);
            }
            if (btcData != null && btcData.length > 0) {
                msg.setBtcData(btcData);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getLogPrefix() + " messageProtocol [" + (Object)((Object)this.messageProtocol) + "] replyToQueueName [" + replyToQueueName + "] sending message [" + message + "]"));
            } else if (this.log.isInfoEnabled()) {
                this.log.info((Object)(this.getLogPrefix() + " messageProtocol [" + (Object)((Object)this.messageProtocol) + "] replyToQueueName [" + replyToQueueName + "] sending message"));
            }
            sender.send((Message)msg);
            if (!(!this.isJmsTransacted() || this.messagingSource.isXaEnabledForSure() && JtaUtil.inTransaction())) {
                session.commit();
                this.log.debug((Object)(this.getLogPrefix() + "committing (send) transaction"));
            }
            return msg;
        }
        catch (Exception e) {
            throw new IfsaException((Throwable)e);
        }
    }

    public void sendReply(QueueSession session, Message received_message, String response) throws IfsaException {
        QueueSender tqs = null;
        try {
            TextMessage answer = session.createTextMessage();
            answer.setText(response);
            Queue replyQueue = (Queue)received_message.getJMSReplyTo();
            tqs = session.createSender(replyQueue);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getLogPrefix() + "sending reply to [" + received_message.getJMSReplyTo() + "]"));
            }
            ((IFSAServerQueueSender)tqs).sendReply(received_message, (Message)answer);
        }
        catch (Throwable t) {
            throw new IfsaException(t);
        }
        finally {
            if (tqs != null) {
                try {
                    tqs.close();
                }
                catch (JMSException e) {
                    this.log.warn((Object)(this.getLogPrefix() + "exception closing reply queue sender"), (Throwable)e);
                }
            }
        }
    }

    public void setMessageProtocol(String newMessageProtocol) {
        if (null == IfsaMessageProtocolEnum.getEnum(newMessageProtocol)) {
            throw new IllegalArgumentException(this.getLogPrefix() + "illegal messageProtocol [" + newMessageProtocol + "] specified, it should be one of the values " + IfsaMessageProtocolEnum.getNames());
        }
        this.messageProtocol = IfsaMessageProtocolEnum.getEnum(newMessageProtocol);
        this.log.debug((Object)(this.getLogPrefix() + "message protocol set to " + this.messageProtocol.getName()));
    }

    public boolean isSessionsArePooled() {
        try {
            return this.getMessagingSource().sessionsArePooled();
        }
        catch (IfsaException e) {
            this.log.error((Object)(this.getLogPrefix() + "could not get session"), (Throwable)e);
            return false;
        }
    }

    protected boolean isJmsTransacted() {
        return this.getMessageProtocolEnum().equals((Object)IfsaMessageProtocolEnum.FIRE_AND_FORGET);
    }

    public String toString() {
        String result = super.toString();
        ToStringBuilder ts = new ToStringBuilder((Object)this);
        ts.append("applicationId", (Object)this.applicationId);
        ts.append("serviceId", (Object)this.serviceId);
        if (this.messageProtocol != null) {
            ts.append("messageProtocol", (Object)this.messageProtocol.getName());
            ts.append("jmsTransacted", this.isJmsTransacted());
        } else {
            ts.append("messageProtocol", (Object)"null!");
        }
        result = result + ts.toString();
        return result;
    }

    public String getPhysicalDestinationName() {
        String result = null;
        try {
            result = this.isRequestor() ? this.getServiceId() : this.getApplicationId();
            this.log.debug((Object)("obtaining connection and servicequeue for " + result));
            if (this.getMessagingSource() != null && this.getServiceQueue() != null) {
                result = result + " [" + this.getServiceQueue().getQueueName() + "]";
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)(this.getLogPrefix() + "got exception in getPhysicalDestinationName"), t);
        }
        try {
            result = result + " on " + this.getMessagingSource().getPhysicalName();
        }
        catch (Exception e) {
            this.log.warn((Object)("[" + this.name + "] got exception in messagingSource.getPhysicalName"), (Throwable)e);
        }
        return result;
    }

    public void setServiceId(String newServiceId) {
        this.serviceId = newServiceId;
    }

    public String getServiceId() {
        if (this.polishedServiceId == null && this.serviceId != null) {
            try {
                IfsaMessagingSource messagingSource = this.getMessagingSource();
                this.polishedServiceId = messagingSource.polishServiceId(this.serviceId);
            }
            catch (IfsaException e) {
                this.log.warn((Object)"could not obtain connection, no polishing of serviceId", (Throwable)e);
                this.polishedServiceId = this.serviceId;
            }
        }
        return this.polishedServiceId;
    }

    public void setApplicationId(String newApplicationId) {
        this.applicationId = newApplicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    protected synchronized boolean useSelectorsForProviders() {
        if (useSelectorsStore == null) {
            boolean pooled = AppConstants.getInstance().getBoolean(USE_SELECTOR_FOR_PROVIDER_KEY, true);
            useSelectorsStore = new Boolean(pooled);
        }
        return useSelectorsStore;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public void setAckMode(int ackMode) {
        this.ackMode = ackMode;
    }

    public int getAckMode() {
        return this.ackMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        if (acknowledgeMode.equalsIgnoreCase("auto") || acknowledgeMode.equalsIgnoreCase("AUTO_ACKNOWLEDGE")) {
            this.ackMode = 1;
        } else if (acknowledgeMode.equalsIgnoreCase("dups") || acknowledgeMode.equalsIgnoreCase("DUPS_OK_ACKNOWLEDGE")) {
            this.ackMode = 3;
        } else if (acknowledgeMode.equalsIgnoreCase("client") || acknowledgeMode.equalsIgnoreCase("CLIENT_ACKNOWLEDGE")) {
            this.ackMode = 2;
        } else {
            this.log.warn((Object)("[" + this.name + "] invalid acknowledgemode:[" + acknowledgeMode + "] setting no acknowledge"));
            this.ackMode = -1;
        }
    }
}

