/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.NamingException;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.PipeLineSession;
import nl.nn.adapterframework.jms.JmsException;
import nl.nn.adapterframework.jms.JmsSender;
import nl.nn.adapterframework.parameters.Parameter;
import nl.nn.adapterframework.parameters.ParameterValueList;
import nl.nn.adapterframework.util.AppConstants;

public class IfsaSimulatorJmsSender
extends JmsSender {
    private static final String RR_REQUEST = "rr_request";
    private static final String RR_REPLY = "rr_reply";
    private static final String FF_REQUEST = "ff_request";
    private String messageType = "";

    public void configure() throws ConfigurationException {
        String iad;
        if (!(this.getMessageType().equalsIgnoreCase(RR_REQUEST) || this.getMessageType().equalsIgnoreCase(RR_REPLY) || this.getMessageType().equalsIgnoreCase(FF_REQUEST))) {
            throw new ConfigurationException(this.getLogPrefix() + "illegal value for messageType [" + this.getMessageType() + "], must be '" + RR_REQUEST + "', '" + RR_REPLY + "'' or '" + FF_REQUEST + "'");
        }
        this.addParameter(new Parameter("ifsa", "_IFSA_HEADER_"));
        this.addParameter(new Parameter("ifsa_api", "jms_wrapper"));
        this.addParameter(new Parameter("ifsa_api_version", "22.30.020"));
        this.addParameter(new Parameter("ifsa_auth_flag", "1"));
        Parameter p = new Parameter();
        p.setName("ifsa_bif_id");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            iad = AppConstants.getInstance().getProperty("IFSAApplicationID", "");
            p.setPattern(iad + "#{ifsa_destination}#{uid}");
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setSessionKey("ifsa_bif_id");
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            iad = AppConstants.getInstance().getProperty("IFSAApplicationID", "");
            p.setPattern(iad + "#{ifsa_destination}#{uid}");
        }
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_bif_type");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue("0");
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setValue("0");
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setValue("2");
        }
        this.addParameter(p);
        this.addParameter(new Parameter("ifsa_bulk", "0"));
        this.addParameter(new Parameter("ifsa_bulk_auth_flag", "0"));
        this.addParameter(new Parameter("ifsa_cil_version", "22.30.009"));
        p = new Parameter();
        p.setName("ifsa_comp_algo");
        p.setDefaultValue("");
        p.setSessionKey("null");
        this.addParameter(p);
        if (!this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
                p = new Parameter();
                p.setName("ifsa_destination");
                p.setSessionKey("ifsa_source");
                this.addParameter(p);
            } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
                // empty if block
            }
        }
        p = new Parameter();
        p.setName("ifsa_expiry");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue(AppConstants.getInstance().getProperty("timeOutIFSARR", ""));
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setValue(AppConstants.getInstance().getProperty("timeOutIFSARR", ""));
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setValue("0");
        }
        this.addParameter(p);
        this.addParameter(new Parameter("ifsa_header_version", "02.02.000"));
        this.addParameter(new Parameter("ifsa_hop_count", "000"));
        this.addParameter(new Parameter("ifsa_node_id", AppConstants.getInstance().getProperty("ifsa_node_id", "")));
        p = new Parameter();
        p.setName("ifsa_ori_area");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue(AppConstants.getInstance().getProperty("ifsa_ori_area", ""));
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setValue(AppConstants.getInstance().getProperty("ifsa_ori_area", ""));
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setDefaultValue("");
            p.setSessionKey("null");
        }
        p.setMinLength(60);
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_ori_format");
        p.setDefaultValue("");
        p.setSessionKey("null");
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_ori_length");
        p.setDefaultValue("");
        p.setSessionKey("null");
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_ori_rtq");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue(AppConstants.getInstance().getProperty("ifsa_ori_rtq", ""));
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setDefaultValue("");
            p.setSessionKey("null");
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setDefaultValue("");
            p.setSessionKey("null");
        }
        p.setMinLength(48);
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_ori_rtqm");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue(AppConstants.getInstance().getProperty("ifsa_ori_rtqm", ""));
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setDefaultValue("");
            p.setSessionKey("null");
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setDefaultValue("");
            p.setSessionKey("null");
        }
        p.setMinLength(48);
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_priority");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue("3");
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setValue("3");
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setValue("2");
        }
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_source");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue(AppConstants.getInstance().getProperty("IFSAApplicationID", ""));
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            iad = AppConstants.getInstance().getProperty("IFSAApplicationID", "");
            p.setPattern(iad + "#{ifsa_destination}");
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setValue(AppConstants.getInstance().getProperty("IFSAApplicationID", ""));
        }
        this.addParameter(p);
        p = new Parameter();
        p.setName("ifsa_unique_id");
        p.setPattern("{uid}");
        this.addParameter(p);
        p = new Parameter();
        p.setName("JMS_IBM_MsgType");
        if (this.getMessageType().equalsIgnoreCase(RR_REQUEST)) {
            p.setValue("1");
        } else if (this.getMessageType().equalsIgnoreCase(RR_REPLY)) {
            p.setValue("2");
        } else if (this.getMessageType().equalsIgnoreCase(FF_REQUEST)) {
            p.setValue("8");
        }
        p.setType(Parameter.ParameterType.INTEGER);
        this.addParameter(p);
        if (this.getMessageType().equalsIgnoreCase(RR_REPLY) && this.getDestinationName() == null) {
            if (this.paramList != null) {
                this.paramList.configure();
            }
        } else {
            super.configure();
        }
    }

    public Destination getDestination() throws NamingException, JMSException, JmsException {
        if (this.getMessageType().equalsIgnoreCase(RR_REPLY) && this.getDestinationName() == null) {
            return null;
        }
        return super.getDestination();
    }

    public Destination getDestination(PipeLineSession session, ParameterValueList pvl) throws JmsException, NamingException, JMSException {
        if (this.getMessageType().equalsIgnoreCase(RR_REPLY) && this.getDestinationName() == null) {
            return (Destination)session.get((Object)"replyTo");
        }
        return super.getDestination(session, pvl);
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public String getMessageType() {
        return this.messageType;
    }
}

