/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.jms;

import com.ing.ifsa.IFSAConstants;
import com.ing.ifsa.IFSAContext;
import com.ing.ifsa.IFSAGate;
import com.ing.ifsa.IFSAQueueConnectionFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import nl.nn.adapterframework.core.IbisException;
import nl.nn.adapterframework.extensions.ifsa.jms.IfsaMessagingSource;
import nl.nn.adapterframework.jms.MessagingSource;
import nl.nn.adapterframework.jms.MessagingSourceFactory;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class IfsaMessagingSourceFactory
extends MessagingSourceFactory {
    private static final String IFSA_INITIAL_CONTEXT_FACTORY = "com.ing.ifsa.IFSAContextFactory";
    private static final String IFSA_PROVIDER_URL_V2_0 = "IFSA APPLICATION BUS";
    private static Map ifsaMessagingSourceMap = new HashMap();
    private boolean preJms22Api = false;
    private boolean xaEnabled = false;

    protected Map getMessagingSourceMap() {
        return ifsaMessagingSourceMap;
    }

    protected MessagingSource createMessagingSource(String id, String authAlias, boolean createDestination, boolean useJms102) throws IbisException {
        IFSAContext context = (IFSAContext)this.getContext();
        IFSAQueueConnectionFactory connectionFactory = (IFSAQueueConnectionFactory)this.getConnectionFactory((Context)context, id, createDestination, useJms102);
        return new IfsaMessagingSource(id, context, connectionFactory, this.getMessagingSourceMap(), this.preJms22Api, this.xaEnabled);
    }

    public synchronized MessagingSource getConnection(String id) throws IbisException {
        return super.getMessagingSource(id, null, false, true);
    }

    protected String getProviderUrl() {
        String purl = "IFSA Version V2.2";
        this.log.info("IFSA ProviderURL at time of compilation [" + purl + "]");
        try {
            Class<?> clazz = Class.forName("com.ing.ifsa.IFSAConstants");
            try {
                Field baicnfField = clazz.getField("IFSA_BAICNF");
                Object baicnfFieldValue = baicnfField.get(null);
                this.log.info("IFSA ProviderURL specified by installed API [" + baicnfFieldValue + "]");
                purl = baicnfFieldValue.toString();
            }
            catch (NoSuchFieldException e1) {
                this.log.info("field [com.ing.ifsa.IFSAConstants.IFSA_BAICNF] not found, assuming IFSA Version 2.0");
                this.preJms22Api = true;
                purl = IFSA_PROVIDER_URL_V2_0;
            }
        }
        catch (Exception e) {
            this.log.warn("exception determining IFSA ProviderURL", (Throwable)e);
        }
        this.log.info("IFSA ProviderURL used to connect [" + purl + "]");
        return purl;
    }

    protected Context createContext() throws NamingException {
        this.log.info("IFSA API installed version [" + IFSAConstants.getVersionInfo() + "]");
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", IFSA_INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", this.getProviderUrl());
        return new IFSAContext((Context)new InitialContext(env));
    }

    protected ConnectionFactory createConnectionFactory(Context context, String applicationId, boolean createDestination, boolean useJms102) throws IbisException, NamingException {
        IFSAQueueConnectionFactory ifsaQueueConnectionFactory = (IFSAQueueConnectionFactory)((IFSAContext)context).lookupBusConnection(applicationId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("IfsaConnection for application [" + applicationId + "] got ifsaQueueConnectionFactory with properties:" + ToStringBuilder.reflectionToString((Object)ifsaQueueConnectionFactory) + "\n isServer: " + ifsaQueueConnectionFactory.IsServer() + "\n isClientNonTransactional:" + ifsaQueueConnectionFactory.IsClientNonTransactional() + "\n isClientTransactional:" + ifsaQueueConnectionFactory.IsClientTransactional() + "\n isClientServerNonTransactional:" + ifsaQueueConnectionFactory.IsClientServerNonTransactional() + "\n isServerTransactional:" + ifsaQueueConnectionFactory.IsClientServerTransactional() + "\n");
        }
        if (!this.preJms22Api) {
            try {
                IFSAGate gate = IFSAGate.getInstance();
                this.xaEnabled = gate.isXA();
                this.log.info("IFSA JMS XA enabled [" + this.xaEnabled + "]");
                this.log.info("IFSA JMS hasDynamicReplyQueue: " + ((IFSAContext)context).hasDynamicReplyQueue());
            }
            catch (Throwable t) {
                this.log.info("caught exception determining IfsaJms v2.2+ features:", t);
            }
        } else {
            this.log.info("for IFSA JMS versions prior to 2.2 capability of XA support cannot be determined");
        }
        return ifsaQueueConnectionFactory;
    }
}

