/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.ifsa.jms;

import com.ing.ifsa.IFSAHeader;
import com.ing.ifsa.IFSAMessage;
import com.ing.ifsa.IFSAPoisonMessage;
import com.ing.ifsa.IFSAQueue;
import com.ing.ifsa.IFSAServiceName;
import com.ing.ifsa.IFSAServicesProvided;
import com.ing.ifsa.IFSAUDZ;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.core.IKnowsDeliveryCount;
import nl.nn.adapterframework.core.IListenerConnector;
import nl.nn.adapterframework.core.IMessageHandler;
import nl.nn.adapterframework.core.IMessageWrapper;
import nl.nn.adapterframework.core.IPortConnectedListener;
import nl.nn.adapterframework.core.IThreadCountControllable;
import nl.nn.adapterframework.core.ITransactionRequirements;
import nl.nn.adapterframework.core.IbisExceptionListener;
import nl.nn.adapterframework.core.ListenerException;
import nl.nn.adapterframework.core.PipeLineResult;
import nl.nn.adapterframework.core.PipeLineSession;
import nl.nn.adapterframework.extensions.ifsa.IfsaException;
import nl.nn.adapterframework.extensions.ifsa.IfsaMessageProtocolEnum;
import nl.nn.adapterframework.extensions.ifsa.jms.IfsaFacade;
import nl.nn.adapterframework.receivers.Receiver;
import nl.nn.adapterframework.stream.Message;
import nl.nn.adapterframework.util.ClassUtils;
import nl.nn.adapterframework.util.DateUtils;
import nl.nn.adapterframework.util.XmlUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PushingIfsaProviderListener
extends IfsaFacade
implements IPortConnectedListener<IFSAMessage>,
IThreadCountControllable,
IKnowsDeliveryCount,
ITransactionRequirements {
    public static final String THREAD_CONTEXT_ORIGINAL_RAW_MESSAGE_KEY = "originalRawMessage";
    public static final String THREAD_CONTEXT_BIFNAME_KEY = "IfsaBif";
    private String listenerPort;
    private String cacheMode;
    private IListenerConnector jmsConnector;
    private IMessageHandler<IFSAMessage> handler;
    private Receiver receiver;
    private IbisExceptionListener exceptionListener;

    public PushingIfsaProviderListener() {
        super(true);
        this.setTimeOut(3000L);
    }

    @Override
    public void configure() throws ConfigurationException {
        super.configure();
        if (this.jmsConnector == null) {
            throw new ConfigurationException(this.getLogPrefix() + " has no jmsConnector. It should be configured via springContext.xml");
        }
        if (!(!StringUtils.isNotEmpty((CharSequence)this.getCacheMode()) || this.getCacheMode().equals("CACHE_NONE") || this.getCacheMode().equals("CACHE_CONNECTION") || this.getCacheMode().equals("CACHE_SESSION") || this.getCacheMode().equals("CACHE_CONSUMER"))) {
            throw new ConfigurationException(this.getLogPrefix() + "cacheMode [" + this.getCacheMode() + "] must be one of CACHE_NONE, CACHE_CONNECTION, CACHE_SESSION or CACHE_CONSUMER");
        }
        IFSAQueue destination = null;
        try {
            destination = this.getServiceQueue();
        }
        catch (Exception e) {
            throw new ConfigurationException(this.getLogPrefix() + "could not get Destination", (Throwable)e);
        }
        try {
            this.jmsConnector.configureEndpointConnection((IPortConnectedListener)this, this.getMessagingSource().getConnectionFactory(), null, (Destination)destination, this.getExceptionListener(), this.getCacheMode(), this.getAckMode(), this.isJmsTransacted(), this.getProviderSelector(), this.getTimeOut(), -1L);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public void open() throws ListenerException {
        try {
            this.openService();
            IFSAServicesProvided services = this.getServiceQueue().getIFSAServicesProvided();
            for (int i = 0; i < services.getNumberOfServices(); ++i) {
                IFSAServiceName service = services.getService(i);
                String protocol = service.IsFireAndForgetService() ? "Fire and Forget" : "Request/Reply";
                this.log.info(this.getLogPrefix() + "providing ServiceName [" + service.getServiceName() + "] ServiceGroup [" + service.getServiceGroup() + "] protocol [" + protocol + "] ServiceVersion [" + service.getServiceVersion() + "]");
            }
            this.jmsConnector.start();
        }
        catch (Exception e) {
            throw new ListenerException(this.getLogPrefix(), (Throwable)e);
        }
    }

    public void close() throws ListenerException {
        try {
            this.jmsConnector.stop();
            this.closeService();
        }
        catch (IfsaException e) {
            throw new ListenerException(this.getLogPrefix(), (Throwable)e);
        }
    }

    public boolean transactionalRequired() {
        return this.getMessageProtocolEnum() == IfsaMessageProtocolEnum.FIRE_AND_FORGET;
    }

    public boolean transactionalAllowed() {
        return true;
    }

    public void afterMessageProcessed(PipeLineResult plr, Object rawMessageOrWrapper, Map<String, Object> threadContext) throws ListenerException {
        QueueSession session = (QueueSession)threadContext.get("JmsSession");
        if (this.getMessageProtocolEnum() == IfsaMessageProtocolEnum.REQUEST_REPLY) {
            javax.jms.Message originalRawMessage = rawMessageOrWrapper instanceof javax.jms.Message ? (javax.jms.Message)rawMessageOrWrapper : (javax.jms.Message)threadContext.get(THREAD_CONTEXT_ORIGINAL_RAW_MESSAGE_KEY);
            if (originalRawMessage == null) {
                String cid = (String)threadContext.get("cid");
                this.log.warn(this.getLogPrefix() + "no original raw message found for correlationId [" + cid + "], cannot send result");
            } else {
                if (session == null) {
                    throw new ListenerException(this.getLogPrefix() + "no session found in context, cannot send result");
                }
                try {
                    String result = "<exception>no result</exception>";
                    if (plr != null && plr.getResult() != null) {
                        result = plr.getResult().asString();
                    }
                    this.sendReply(session, originalRawMessage, result);
                }
                catch (IOException | IfsaException e) {
                    try {
                        this.sendReply(session, originalRawMessage, "<exception>" + e.getMessage() + "</exception>");
                    }
                    catch (IfsaException e2) {
                        this.log.warn(this.getLogPrefix() + "exception sending errormessage as reply", (Throwable)e2);
                    }
                    throw new ListenerException(this.getLogPrefix() + "Exception on sending result", e);
                }
            }
        }
    }

    protected String getIdFromWrapper(IMessageWrapper wrapper, Map<String, Object> threadContext) {
        for (String key : wrapper.getContext().keySet()) {
            Object value = wrapper.getContext().get(key);
            this.log.debug(this.getLogPrefix() + "setting variable [" + key + "] to [" + value + "]");
            threadContext.put(key, value);
        }
        return wrapper.getId();
    }

    protected Message getMessageFromWrapper(IMessageWrapper wrapper, Map<String, Object> threadContext) {
        return wrapper.getMessage();
    }

    public String getIdFromRawMessage(IFSAMessage rawMessage, Map<String, Object> threadContext) throws ListenerException {
        IFSAMessage message = null;
        if (rawMessage instanceof IMessageWrapper) {
            return this.getIdFromWrapper((IMessageWrapper)rawMessage, threadContext);
        }
        try {
            message = rawMessage;
        }
        catch (ClassCastException e) {
            this.log.error(this.getLogPrefix() + "message received was not of type IFSAMessage, but [" + rawMessage.getClass().getName() + "]", (Throwable)e);
            return null;
        }
        String mode = "unknown";
        String id = "unset";
        String cid = "unset";
        Date tsSent = null;
        Destination replyTo = null;
        String messageText = null;
        String fullIfsaServiceName = null;
        IFSAServiceName requestedService = null;
        String ifsaServiceName = null;
        String ifsaGroup = null;
        String ifsaOccurrence = null;
        String ifsaVersion = null;
        try {
            if (message.getJMSDeliveryMode() == 1) {
                mode = "NON_PERSISTENT";
            } else if (message.getJMSDeliveryMode() == 2) {
                mode = "PERSISTENT";
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            id = message.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            cid = message.getJMSCorrelationID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            long lTimeStamp = message.getJMSTimestamp();
            tsSent = new Date(lTimeStamp);
        }
        catch (JMSException lTimeStamp) {
            // empty catch block
        }
        try {
            replyTo = message.getJMSReplyTo();
        }
        catch (JMSException lTimeStamp) {
            // empty catch block
        }
        try {
            messageText = ((TextMessage)message).getText();
        }
        catch (Throwable lTimeStamp) {
            // empty catch block
        }
        try {
            fullIfsaServiceName = message.getServiceString();
            requestedService = message.getService();
            ifsaServiceName = requestedService.getServiceName();
            ifsaGroup = requestedService.getServiceGroup();
            ifsaOccurrence = requestedService.getServiceOccurance();
            ifsaVersion = requestedService.getServiceVersion();
        }
        catch (JMSException e) {
            this.log.error(this.getLogPrefix() + "got error getting serviceparameter", (Throwable)e);
        }
        String BIFname = null;
        try {
            BIFname = message.getBifName();
            if (StringUtils.isNotEmpty((CharSequence)BIFname)) {
                threadContext.put(THREAD_CONTEXT_BIFNAME_KEY, BIFname);
            }
        }
        catch (JMSException e) {
            this.log.error(this.getLogPrefix() + "got error getting BIFname", (Throwable)e);
        }
        byte[] btcData = null;
        try {
            btcData = message.getBtcData();
        }
        catch (JMSException e) {
            this.log.error(this.getLogPrefix() + "got error getting btcData", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getLogPrefix() + "got message for [" + fullIfsaServiceName + "] with JMSDeliveryMode=[" + mode + "] \n  JMSMessageID=[" + id + "] \n  JMSCorrelationID=[" + cid + "] \n  BIFname=[" + BIFname + "] \n  ifsaServiceName=[" + ifsaServiceName + "] \n  ifsaGroup=[" + ifsaGroup + "] \n  ifsaOccurrence=[" + ifsaOccurrence + "] \n  ifsaVersion=[" + ifsaVersion + "] \n  Timestamp Sent=[" + DateUtils.format((Date)tsSent) + "] \n  ReplyTo=[" + (replyTo == null ? "none" : replyTo.toString()) + "] \n  MessageHeaders=[" + this.displayHeaders(message) + "\n] \n  Message=[" + message.toString() + "\n]");
        }
        PipeLineSession.setListenerParameters(threadContext, (String)id, (String)BIFname, null, (Date)tsSent);
        threadContext.put("timestamp", tsSent);
        threadContext.put("replyTo", replyTo == null ? "none" : replyTo.toString());
        threadContext.put("messageText", messageText);
        threadContext.put("fullIfsaServiceName", fullIfsaServiceName);
        threadContext.put("ifsaServiceName", ifsaServiceName);
        threadContext.put("ifsaGroup", ifsaGroup);
        threadContext.put("ifsaOccurrence", ifsaOccurrence);
        threadContext.put("ifsaVersion", ifsaVersion);
        threadContext.put("ifsaBifName", BIFname);
        threadContext.put("ifsaBtcData", btcData);
        IFSAUDZ udz = message.getIncomingUDZObject();
        if (udz != null) {
            String contextDump = "ifsaUDZ:";
            for (String key : udz.keySet()) {
                String value = (String)udz.get(key);
                contextDump = contextDump + "\n " + key + "=[" + value + "]";
                threadContext.put(key, value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getLogPrefix() + contextDump);
            }
        }
        return BIFname;
    }

    private String displayHeaders(IFSAMessage message) {
        StringBuffer result = new StringBuffer();
        try {
            Enumeration enumeration = message.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String tagName = (String)enumeration.nextElement();
                Object value = message.getObjectProperty(tagName);
                result.append("\n").append(tagName).append(": ");
                if (value == null) {
                    result.append("null");
                    continue;
                }
                result.append("(").append(ClassUtils.nameOf((Object)value)).append(") [").append(value).append("]");
                if (!tagName.startsWith("ifsa") || tagName.equals("ifsa_unique_id") || tagName.startsWith("ifsa_epz_") || tagName.startsWith("ifsa_udz_")) continue;
                result.append(" * copied when sending reply");
                if (value instanceof String) continue;
                result.append(" THIS CAN CAUSE A PROBLEM AS " + ClassUtils.nameOf((Object)value) + " IS NOT String!");
            }
        }
        catch (Throwable t) {
            this.log.warn("exception parsing headers", t);
        }
        return result.toString();
    }

    public Message extractMessage(IFSAMessage rawMessage, Map<String, Object> threadContext) throws ListenerException {
        if (rawMessage instanceof IMessageWrapper) {
            return this.getMessageFromWrapper((IMessageWrapper)rawMessage, threadContext);
        }
        if (rawMessage instanceof IFSAPoisonMessage) {
            String source;
            IFSAPoisonMessage pm = (IFSAPoisonMessage)rawMessage;
            IFSAHeader header = pm.getIFSAHeader();
            try {
                source = header.getIFSA_Source();
            }
            catch (Exception e) {
                source = "unknown due to exeption:" + e.getMessage();
            }
            return new Message("<poisonmessage>  <source>" + source + "</source>  <contents>" + XmlUtils.encodeChars((String)ToStringBuilder.reflectionToString((Object)pm)) + "</contents></poisonmessage>");
        }
        TextMessage message = null;
        try {
            message = (TextMessage)rawMessage;
        }
        catch (ClassCastException e) {
            this.log.warn(this.getLogPrefix() + "message received was not of type TextMessage, but [" + rawMessage.getClass().getName() + "]", (Throwable)e);
            return null;
        }
        try {
            String result = message.getText();
            threadContext.put(THREAD_CONTEXT_ORIGINAL_RAW_MESSAGE_KEY, message);
            return new Message(result);
        }
        catch (JMSException e) {
            throw new ListenerException(this.getLogPrefix(), (Throwable)e);
        }
    }

    public void setJmsConnector(IListenerConnector configurator) {
        this.jmsConnector = configurator;
    }

    public IListenerConnector getJmsConnector() {
        return this.jmsConnector;
    }

    public IListenerConnector getListenerPortConnector() {
        return this.jmsConnector;
    }

    public void setExceptionListener(IbisExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public IbisExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setHandler(IMessageHandler<IFSAMessage> handler) {
        this.handler = handler;
    }

    public IMessageHandler<IFSAMessage> getHandler() {
        return this.handler;
    }

    public void setListenerPort(String listenerPort) {
        this.listenerPort = listenerPort;
    }

    public String getListenerPort() {
        return this.listenerPort;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setCacheMode(String string) {
        this.cacheMode = string;
    }

    public String getCacheMode() {
        return this.cacheMode;
    }

    public boolean isThreadCountReadable() {
        if (this.jmsConnector instanceof IThreadCountControllable) {
            IThreadCountControllable tcc = (IThreadCountControllable)this.jmsConnector;
            return tcc.isThreadCountReadable();
        }
        return false;
    }

    public boolean isThreadCountControllable() {
        if (this.jmsConnector instanceof IThreadCountControllable) {
            IThreadCountControllable tcc = (IThreadCountControllable)this.jmsConnector;
            return tcc.isThreadCountControllable();
        }
        return false;
    }

    public int getCurrentThreadCount() {
        if (this.jmsConnector instanceof IThreadCountControllable) {
            IThreadCountControllable tcc = (IThreadCountControllable)this.jmsConnector;
            return tcc.getCurrentThreadCount();
        }
        return -1;
    }

    public int getMaxThreadCount() {
        if (this.jmsConnector instanceof IThreadCountControllable) {
            IThreadCountControllable tcc = (IThreadCountControllable)this.jmsConnector;
            return tcc.getMaxThreadCount();
        }
        return -1;
    }

    public void increaseThreadCount() {
        if (this.jmsConnector instanceof IThreadCountControllable) {
            IThreadCountControllable tcc = (IThreadCountControllable)this.jmsConnector;
            tcc.increaseThreadCount();
        }
    }

    public void decreaseThreadCount() {
        if (this.jmsConnector instanceof IThreadCountControllable) {
            IThreadCountControllable tcc = (IThreadCountControllable)this.jmsConnector;
            tcc.decreaseThreadCount();
        }
    }

    public int getDeliveryCount(Object rawMessage) {
        try {
            javax.jms.Message message = (javax.jms.Message)rawMessage;
            int value = message.getIntProperty("JMSXDeliveryCount");
            if (this.log.isDebugEnabled()) {
                this.log.debug("determined delivery count [" + value + "]");
            }
            return value;
        }
        catch (Exception e) {
            this.log.error(this.getLogPrefix() + "exception in determination of DeliveryCount", (Throwable)e);
            return -1;
        }
    }
}

