/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector.local;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.fortuna.ical4j.model.Calendar;
import org.ical4j.connector.ObjectCollection;
import org.ical4j.connector.ObjectStoreException;
import org.ical4j.connector.local.LocalCollectionConfiguration;

public abstract class AbstractLocalObjectCollection<T>
implements ObjectCollection<T> {
    private final File root;
    private final LocalCollectionConfiguration configuration;

    public AbstractLocalObjectCollection(File root) throws IOException {
        this.root = Objects.requireNonNull(root);
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("Root must be a directory");
        }
        File configRoot = new File(root, ".ical4j");
        if (configRoot.exists() && !configRoot.isDirectory() || !configRoot.exists() && !configRoot.mkdirs()) {
            throw new IOException("Unable to initialise collection config");
        }
        this.configuration = new LocalCollectionConfiguration(configRoot);
    }

    protected File getRoot() {
        return this.root;
    }

    @Override
    public String getDisplayName() {
        return this.configuration.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.configuration.getDescription();
    }

    public String[] getSupportedComponentTypes() {
        return this.configuration.getSupportedComponentTypes();
    }

    public Calendar getTimeZone() {
        return this.configuration.getTimeZone();
    }

    public void setDisplayName(String displayName) throws IOException {
        this.configuration.setDisplayName(displayName);
    }

    public void setDescription(String description) throws IOException {
        this.configuration.setDescription(description);
    }

    public void setSupportedComponents(String[] supportedComponents) throws IOException {
        this.configuration.setSupportedComponents(supportedComponents);
    }

    public void setTimeZone(Calendar timezone) throws IOException {
        this.configuration.setTimeZone(timezone);
    }

    @Override
    public void delete() throws ObjectStoreException {
        if (Objects.requireNonNull(this.root.list((root, name) -> !name.equals(".ical4j"))).length > 0) {
            throw new ObjectStoreException("Collection is not empty. Remove all contents before deleting.");
        }
        if (!this.configuration.delete() || !this.root.delete()) {
            throw new ObjectStoreException("Unable to delete collection");
        }
    }

    public String toString() {
        return String.format("LocalCollection[%s]", this.getDisplayName());
    }
}

