/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector.local;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Calendar;
import org.ical4j.connector.ObjectCollection;
import org.ical4j.connector.ObjectNotFoundException;
import org.ical4j.connector.ObjectStore;
import org.ical4j.connector.ObjectStoreException;
import org.ical4j.connector.local.AbstractLocalObjectCollection;

public abstract class AbstractLocalObjectStore<C extends AbstractLocalObjectCollection<?>>
implements ObjectStore<C> {
    private final File root;

    AbstractLocalObjectStore(File root) {
        this.root = Objects.requireNonNull(root);
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException("Root must be a directory");
        }
        if (!root.exists() && !root.mkdirs()) {
            throw new IllegalArgumentException("Unable to initialise root directory");
        }
    }

    protected File getRoot() {
        return this.root;
    }

    @Override
    public boolean connect() throws ObjectStoreException {
        return false;
    }

    @Override
    public boolean connect(String username, char[] password) throws ObjectStoreException {
        return false;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public C addCollection(String id) throws ObjectStoreException {
        File collectionDir = new File(this.root, id);
        if (collectionDir.exists() && !collectionDir.isDirectory() || !collectionDir.exists() && !collectionDir.mkdirs()) {
            throw new ObjectStoreException("Unable to initialise collection");
        }
        ObjectCollection<Object> collection = null;
        try {
            collection = this.getCollection(id);
        }
        catch (ObjectNotFoundException e) {
            try {
                collection = this.newCollection(id);
            }
            catch (IOException ex) {
                throw new ObjectStoreException(ex);
            }
        }
        return (C)collection;
    }

    protected abstract C newCollection(String var1) throws IOException;

    @Override
    public C addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        ObjectCollection collection = this.addCollection(id);
        try {
            ((AbstractLocalObjectCollection)collection).setDisplayName(displayName);
            ((AbstractLocalObjectCollection)collection).setDescription(description);
            ((AbstractLocalObjectCollection)collection).setSupportedComponents(supportedComponents);
            ((AbstractLocalObjectCollection)collection).setTimeZone(timezone);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
        return (C)collection;
    }

    @Override
    public C removeCollection(String id) throws ObjectNotFoundException, ObjectStoreException {
        ObjectCollection collection = this.getCollection(id);
        ((AbstractLocalObjectCollection)collection).delete();
        return (C)collection;
    }

    @Override
    public C getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        File collectionDir = new File(this.root, id);
        if (!collectionDir.exists() || !collectionDir.isDirectory()) {
            throw new ObjectNotFoundException("Unable to retrieve collection");
        }
        try {
            return this.newCollection(id);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
    }

    @Override
    public List<C> getCollections() {
        return Arrays.stream(this.root.list()).map(name -> {
            try {
                return this.newCollection((String)name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

