/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector.local;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.ical4j.connector.CalendarCollection;
import org.ical4j.connector.FailedOperationException;
import org.ical4j.connector.MediaType;
import org.ical4j.connector.ObjectNotFoundException;
import org.ical4j.connector.ObjectStoreException;
import org.ical4j.connector.local.AbstractLocalObjectCollection;

public class LocalCalendarCollection
extends AbstractLocalObjectCollection<Calendar>
implements CalendarCollection {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[1];

    public LocalCalendarCollection(File root) throws IOException {
        super(root);
    }

    @Override
    public MediaType[] getSupportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    public long getMaxResourceSize() {
        return 0L;
    }

    @Override
    public Instant getMinDateTime() {
        return null;
    }

    @Override
    public Instant getMaxDateTime() {
        return null;
    }

    @Override
    public Integer getMaxInstances() {
        return null;
    }

    @Override
    public Integer getMaxAttendeesPerInstance() {
        return null;
    }

    @Override
    public List<String> listObjectUids() {
        return Arrays.stream(this.getObjectFiles()).map(file -> file.getName().split(".ics")[0]).collect(Collectors.toList());
    }

    @Override
    public Uid addCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = calendar.getUid();
        try {
            Calendar existing = this.getCalendar(uid.getValue());
            throw new ObjectStoreException("Calendar already exists");
        }
        catch (ObjectNotFoundException existing) {
            try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".ics"));){
                new CalendarOutputter(false).output(calendar, (Writer)writer);
            }
            catch (IOException e) {
                throw new ObjectStoreException("Error writing calendar file", e);
            }
            return uid;
        }
    }

    @Override
    public Calendar getCalendar(String uid) throws ObjectNotFoundException {
        try {
            return Calendars.load((String)new File(this.getRoot(), uid + ".ics").getAbsolutePath());
        }
        catch (IOException | ParserException e) {
            throw new ObjectNotFoundException(String.format("Calendar not found: %s", uid), e);
        }
    }

    @Override
    public Calendar removeCalendar(String uid) throws FailedOperationException, ObjectNotFoundException {
        Calendar calendar = this.getCalendar(uid);
        if (!new File(this.getRoot(), uid + ".ics").delete()) {
            throw new FailedOperationException("Unable to delete calendar: " + uid);
        }
        return calendar;
    }

    @Override
    public Uid[] merge(Calendar calendar) throws ObjectStoreException {
        Calendar[] uidCalendars;
        for (Calendar c : uidCalendars = calendar.split()) {
            Uid uid = c.getUid();
            try {
                Calendar existing = this.getCalendar(uid.getValue());
                throw new ObjectStoreException("Calendar already exists");
            }
            catch (ObjectNotFoundException existing) {
                try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".ics"));){
                    new CalendarOutputter(false).output(c, (Writer)writer);
                }
                catch (IOException e) {
                    throw new ObjectStoreException("Error writing calendar file", e);
                }
            }
        }
        return (Uid[])Arrays.stream(uidCalendars).map(Calendar::getUid).toArray(Uid[]::new);
    }

    @Override
    public Calendar export() {
        Calendar export = new Calendar();
        for (File object : this.getObjectFiles()) {
            try {
                export = export.merge(Calendars.load((String)object.getAbsolutePath()));
            }
            catch (IOException | ParserException e) {
                throw new RuntimeException(e);
            }
        }
        return export;
    }

    @Override
    public Iterable<Calendar> getComponents() throws ObjectStoreException {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        File[] componentFiles = this.getObjectFiles();
        if (componentFiles != null) {
            try {
                for (File file : componentFiles) {
                    calendars.add(Calendars.load((String)file.getAbsolutePath()));
                }
            }
            catch (IOException | ParserException e) {
                throw new ObjectStoreException(e);
            }
        }
        return calendars;
    }

    private File[] getObjectFiles() {
        return this.getRoot().listFiles(pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".ics"));
    }

    static {
        LocalCalendarCollection.SUPPORTED_MEDIA_TYPES[0] = MediaType.ICALENDAR_2_0;
    }
}

