/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.connector.local;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.VCardOutputter;
import net.fortuna.ical4j.vcard.property.Uid;
import org.ical4j.connector.CardCollection;
import org.ical4j.connector.FailedOperationException;
import org.ical4j.connector.MediaType;
import org.ical4j.connector.ObjectNotFoundException;
import org.ical4j.connector.ObjectStoreException;
import org.ical4j.connector.local.AbstractLocalObjectCollection;

public class LocalCardCollection
extends AbstractLocalObjectCollection<VCard>
implements CardCollection {
    private static final MediaType[] SUPPORTED_MEDIA_TYPES = new MediaType[1];

    public LocalCardCollection(File root) throws IOException {
        super(root);
    }

    @Override
    public List<String> listObjectUids() {
        return Arrays.stream(this.getObjectFiles()).map(file -> file.getName().split(".vcf")[0]).collect(Collectors.toList());
    }

    @Override
    public Uid addCard(VCard card) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = (Uid)card.getRequiredProperty(PropertyName.UID.toString());
        try {
            VCard existing = this.getCard(uid.getValue());
            throw new ObjectStoreException("Card already exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.save(card);
            return uid;
        }
    }

    @Override
    public Uid[] merge(VCard card) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = (Uid)card.getRequiredProperty(PropertyName.UID.toString());
        VCard existing = null;
        try {
            existing = this.getCard(uid.getValue());
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectStoreException(e);
        }
        existing.addAll((Collection)card.getProperties(new String[0]));
        this.save(card);
        return Collections.singletonList(uid).toArray(new Uid[0]);
    }

    private void save(VCard card) throws ObjectStoreException {
        Uid uid = (Uid)card.getRequiredProperty(PropertyName.UID.toString());
        try (FileWriter writer = new FileWriter(new File(this.getRoot(), uid.getValue() + ".vcf"));){
            new VCardOutputter(false).output(card, (Writer)writer);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Error writing card file", e);
        }
    }

    @Override
    public VCard getCard(String uid) throws ObjectNotFoundException {
        try {
            return new VCardBuilder(Files.newInputStream(new File(this.getRoot(), uid + ".vcf").toPath(), new OpenOption[0])).build();
        }
        catch (IOException | ParserException e) {
            throw new ObjectNotFoundException(String.format("Card not found: %s", uid), e);
        }
    }

    @Override
    public VCard removeCard(String uid) throws ObjectNotFoundException, FailedOperationException {
        VCard card = this.getCard(uid);
        if (!new File(this.getRoot(), uid + ".vcf").delete()) {
            throw new FailedOperationException("Unable to delete card: " + uid);
        }
        return card;
    }

    @Override
    public Iterable<VCard> getComponents() throws ObjectStoreException {
        ArrayList<VCard> cards = new ArrayList<VCard>();
        File[] componentFiles = this.getObjectFiles();
        if (componentFiles != null) {
            try {
                for (File file : componentFiles) {
                    VCardBuilder builder = new VCardBuilder(Files.newInputStream(file.toPath(), new OpenOption[0]));
                    cards.add(builder.build());
                }
            }
            catch (IOException | ParserException e) {
                throw new ObjectStoreException(e);
            }
        }
        return cards;
    }

    @Override
    public VCard[] export() throws ObjectStoreException {
        ArrayList<VCard> export = new ArrayList<VCard>();
        for (VCard card : this.getComponents()) {
            export.add(card);
        }
        return export.toArray(new VCard[0]);
    }

    private File[] getObjectFiles() {
        return this.getRoot().listFiles(pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".vcf"));
    }

    static {
        LocalCardCollection.SUPPORTED_MEDIA_TYPES[0] = MediaType.VCARD_4_0;
    }
}

