/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.integration;

import net.fortuna.ical4j.model.Calendar;
import org.ical4j.integration.ListenerList;
import org.ical4j.integration.event.CalendarAddListener;
import org.ical4j.integration.event.CalendarCancelListener;
import org.ical4j.integration.event.CalendarCounterListener;
import org.ical4j.integration.event.CalendarDeclineCounterListener;
import org.ical4j.integration.event.CalendarPublishListener;
import org.ical4j.integration.event.CalendarRefreshListener;
import org.ical4j.integration.event.CalendarReplyListener;
import org.ical4j.integration.event.CalendarRequestListener;

public interface CalendarListenerSupport {
    public ListenerList<Object> getCalendarListeners();

    default public boolean addCalendarPublishListener(CalendarPublishListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarPublishListener(CalendarPublishListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public boolean addCalendarRequestListener(CalendarRequestListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarRequestListener(CalendarRequestListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public boolean addCalendarReplyListener(CalendarReplyListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarReplyListener(CalendarReplyListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public boolean addCalendarAddListener(CalendarAddListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarAddListener(CalendarAddListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public boolean addCalendarCancelListener(CalendarCancelListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarCancelListener(CalendarCancelListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public boolean addCalendarRefreshListener(CalendarRefreshListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarRefreshListener(CalendarRefreshListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public boolean addCalendarCounterListener(CalendarCounterListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarCounterListener(CalendarCounterListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public boolean addCalendarDeclineCounterListener(CalendarDeclineCounterListener listener) {
        return this.getCalendarListeners().add(listener);
    }

    default public boolean removeCalendarDeclineCounterListener(CalendarDeclineCounterListener listener) {
        return this.getCalendarListeners().remove(listener);
    }

    default public void fireCalendarEvent(Calendar calendar) {
        switch (calendar.getRequiredProperty("METHOD").getValue()) {
            case "PUBLISH": {
                this.getCalendarListeners().get(CalendarPublishListener.class).forEach(listener -> listener.onPublish(calendar));
                break;
            }
            case "REQUEST": {
                this.getCalendarListeners().get(CalendarRequestListener.class).forEach(listener -> listener.onRequest(calendar));
                break;
            }
            case "REPLY": {
                this.getCalendarListeners().get(CalendarReplyListener.class).forEach(listener -> listener.onReply(calendar));
                break;
            }
            case "ADD": {
                this.getCalendarListeners().get(CalendarAddListener.class).forEach(listener -> listener.onAdd(calendar));
                break;
            }
            case "CANCEL": {
                this.getCalendarListeners().get(CalendarCancelListener.class).forEach(listener -> listener.onCancel(calendar));
                break;
            }
            case "REFRESH": {
                this.getCalendarListeners().get(CalendarRefreshListener.class).forEach(listener -> listener.onRefresh(calendar));
                break;
            }
            case "COUNTER": {
                this.getCalendarListeners().get(CalendarCounterListener.class).forEach(listener -> listener.onCounter(calendar));
                break;
            }
            case "DECLINE-COUNTER": {
                this.getCalendarListeners().get(CalendarDeclineCounterListener.class).forEach(listener -> listener.onDeclineCounter(calendar));
                break;
            }
        }
    }
}

