/*
 * Decompiled with CFR 0.152.
 */
package org.id4me;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.id4me.config.Id4meClaimsParameters;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Id4meClaimsConfig {
    private static final Logger log = LoggerFactory.getLogger(Id4meClaimsConfig.class);
    private final List<Id4meClaimsParameters.Entry> entries;
    private final String claimsParam;
    private final Set<String> essentialClaims;

    Id4meClaimsConfig(Id4meClaimsParameters parameters) {
        this.entries = Collections.unmodifiableList(new ArrayList<Id4meClaimsParameters.Entry>(parameters.getEntries()));
        this.claimsParam = this.buildClaimsParam();
        log.info("Configured claims param:     {}", (Object)this.claimsParam);
        this.essentialClaims = this.buildEssentialClaims();
        log.info("Configured essential claims: {}", this.essentialClaims);
    }

    private String buildClaimsParam() {
        JSONObject userinfo = new JSONObject();
        for (Id4meClaimsParameters.Entry entry : this.entries) {
            String reason;
            JSONObject p = null;
            if (entry.isEssential()) {
                p = new JSONObject();
                p.put("essential", true);
            }
            if ((reason = entry.getReason()) != null && !reason.equals("")) {
                p = p == null ? new JSONObject() : p;
                p.put("reason", (Object)reason);
            }
            if (p != null) {
                userinfo.put(entry.getName(), (Object)p);
                continue;
            }
            userinfo.put(entry.getName(), JSONObject.NULL);
        }
        return "{\"userinfo\":" + userinfo.toString() + "}";
    }

    String getClaimsParam() {
        return this.claimsParam;
    }

    private Set<String> buildEssentialClaims() {
        HashSet<String> claims = new HashSet<String>();
        for (Id4meClaimsParameters.Entry entry : this.entries) {
            if (!entry.isEssential()) continue;
            claims.add(entry.getName());
        }
        return Collections.unmodifiableSet(claims);
    }

    Set<String> getEssentialClaims() {
        return this.essentialClaims;
    }

    boolean isEssential(String claimName) {
        return this.essentialClaims.contains(claimName);
    }
}

