/*
 * Decompiled with CFR 0.152.
 */
package org.id4me;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

class Id4meKeyPairHandler {
    private KeyPair keyPair = null;
    private String pub_key_file;
    private String priv_key_file;

    public Id4meKeyPairHandler(String pub_key_file, String priv_key_file) throws Exception {
        this.priv_key_file = priv_key_file;
        this.pub_key_file = pub_key_file;
        PublicKey pub_key = this.getPemPublicKey(pub_key_file);
        PrivateKey priv_key = this.getPemPrivateKey(priv_key_file);
        this.keyPair = new KeyPair(pub_key, priv_key);
    }

    public String toString() {
        return this.pub_key_file + ", " + this.priv_key_file;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public JSONObject generateJwks() throws Exception {
        JWK jwk = this.generateJwk(this.keyPair);
        JSONObject jwks = new JSONObject();
        JSONArray keys = new JSONArray();
        JSONObject jwk_json = new JSONObject(jwk.toJSONString());
        jwk_json.remove("use");
        keys.put((Object)jwk_json);
        jwks.put("keys", (Object)keys);
        return jwks;
    }

    private JWK generateJwk(KeyPair keyPair) throws Exception {
        RSAKey jwk = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).build();
        return jwk;
    }

    public PrivateKey getPemPrivateKey(String filename) throws Exception {
        String algorithm = "RSA";
        File f = new File(filename);
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        byte[] keyBytes = new byte[(int)f.length()];
        dis.readFully(keyBytes);
        dis.close();
        String temp = new String(keyBytes);
        String privKeyPEM = temp.replace("-----BEGIN PRIVATE KEY-----\n", "");
        privKeyPEM = privKeyPEM.replace("-----END PRIVATE KEY-----", "");
        byte[] decoded = Base64.decode((String)privKeyPEM);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decoded);
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        return kf.generatePrivate(spec);
    }

    public PublicKey getPemPublicKey(String filename) throws Exception {
        String algorithm = "RSA";
        File f = new File(filename);
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        byte[] keyBytes = new byte[(int)f.length()];
        dis.readFully(keyBytes);
        dis.close();
        String temp = new String(keyBytes);
        String publicKeyPEM = temp.replace("-----BEGIN PUBLIC KEY-----\n", "");
        publicKeyPEM = publicKeyPEM.replace("-----END PUBLIC KEY-----", "");
        byte[] decoded = Base64.decode((String)publicKeyPEM);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(decoded);
        KeyFactory kf = KeyFactory.getInstance(algorithm);
        return kf.generatePublic(spec);
    }
}

