/*
 * Decompiled with CFR 0.152.
 */
package org.id4me;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Iterator;
import org.id4me.Id4meDnsData;
import org.id4me.Id4meDnsResponseParser;
import org.id4me.Id4meValidator;
import org.jitsi.dnssec.validator.ValidatingResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;

class Id4meResolver {
    private static final Logger log = LoggerFactory.getLogger(Id4meResolver.class);
    private final Resolver vr;
    private final boolean dnssecRequired;

    Id4meResolver(String dnsServer, String rootKey, boolean dnssecRequired) throws UnknownHostException, UnsupportedEncodingException, IOException {
        SimpleResolver sr;
        SimpleResolver simpleResolver = sr = dnsServer != null ? new SimpleResolver(dnsServer) : new SimpleResolver();
        if (dnssecRequired) {
            this.vr = new ValidatingResolver((Resolver)sr);
            ((ValidatingResolver)this.vr).loadTrustAnchors((InputStream)new ByteArrayInputStream(rootKey.getBytes("ASCII")));
        } else {
            this.vr = sr;
        }
        this.dnssecRequired = dnssecRequired;
        log.debug("Id4meResolver created for DNS server: {}", (Object)dnsServer);
    }

    Id4meDnsDataWithLoginHint getDataFromDns(String id4me) throws Exception {
        String loginHint;
        if (!Id4meValidator.isValidUserid(id4me)) {
            log.info("ID4me identifier has wrong format: {}", (Object)id4me);
            throw new Exception("ID4me identifier has wrong format: " + id4me);
        }
        int atPos = id4me.indexOf(64);
        if (atPos > 0) {
            String localPart = id4me.substring(0, atPos);
            String domain = id4me.substring(atPos + 1, id4me.length());
            id4me = this.sha256(localPart) + "._openid." + domain;
            loginHint = localPart + "." + domain;
        } else {
            loginHint = id4me;
            id4me = "_openid." + id4me;
        }
        String domain = id4me.endsWith(".") ? id4me : id4me + ".";
        log.info("Get data from DNS: domain: {}", (Object)domain);
        LookupResponse response = this.lookupDnssec(domain);
        if (response == null) {
            log.info("No resource record found in DNS for domain: {}", (Object)domain);
            throw new Exception("No resource record found in DNS for domain: " + domain);
        }
        if (this.dnssecRequired && !response.isDnssec()) {
            log.info("Error getting domain-id data from DNS: DNSSFLAG == false");
            throw new Exception("Error getting domain-id data from DNS: DNSSFLAG == false");
        }
        String data = response.getData();
        log.info("Get data from DNS: data retrieved: {}", (Object)data);
        Id4meDnsData dnsResponse = Id4meDnsResponseParser.parseDnsResponse(data);
        return new Id4meDnsDataWithLoginHint(dnsResponse, loginHint);
    }

    private String sha256(String str) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(str.getBytes());
        byte[] digest = md.digest();
        String hash = String.format("%064x", new BigInteger(1, digest));
        String sha256 = hash.substring(0, 56);
        log.debug("sha256(\"{}\") = \"{}\"", (Object)str, (Object)sha256);
        return sha256;
    }

    private LookupResponse lookupDnssec(String name) throws IOException {
        return this.lookup(this.vr, name);
    }

    LookupResponse lookupDane(String name) throws IOException {
        return this.lookupWithType(this.vr, name, 52);
    }

    private LookupResponse lookup(Resolver resolver, String name) throws IOException {
        RRset[] answer;
        log.debug("DNS lookup: {}", (Object)name);
        Record qr = Record.newRecord((Name)Name.fromConstantString((String)name), (int)16, (int)1);
        Message response = resolver.send(Message.newQuery((Record)qr));
        boolean dnssec = response.getHeader().getFlag(10);
        String rcode = Rcode.string((int)response.getRcode());
        if (!"NOERROR".equals(rcode)) {
            log.warn("DNS lookup: response error: {}", (Object)rcode);
            return null;
        }
        for (RRset set : answer = response.getSectionRRsets(1)) {
            Iterator rrIter = set.rrs();
            while (rrIter.hasNext()) {
                Record rec = (Record)rrIter.next();
                if (rec.getType() != 16) continue;
                String data = rec.rdataToString();
                log.debug("DNS lookup: response: {}", (Object)data);
                return new LookupResponse(data.replace("\"", ""), dnssec);
            }
        }
        String data = qr.rdataToString();
        log.debug("DNS lookup: response: {}", (Object)data);
        return new LookupResponse(data, dnssec);
    }

    private LookupResponse lookupWithType(Resolver resolver, String name, int type) throws IOException {
        RRset[] answer;
        log.debug("DNS lookup: {}; type: {}", (Object)name, (Object)type);
        Record qr = Record.newRecord((Name)Name.fromConstantString((String)name), (int)255, (int)1);
        Message response = resolver.send(Message.newQuery((Record)qr));
        boolean dnssec = response.getHeader().getFlag(10);
        String rcode = Rcode.string((int)response.getRcode());
        if (!"NOERROR".equals(rcode)) {
            log.warn("DNS lookup: response error: {}", (Object)rcode);
            return null;
        }
        for (RRset set : answer = response.getSectionRRsets(1)) {
            Iterator rrIter = set.rrs();
            while (rrIter.hasNext()) {
                Record rec = (Record)rrIter.next();
                if (rec.getType() == type) {
                    String data = rec.rdataToString();
                    log.debug("DNS lookup: response: {}", (Object)data);
                    return new LookupResponse(data.replace("\"", ""), dnssec);
                }
                if (rec.getType() != 5) continue;
                String data = rec.rdataToString();
                log.debug("DNS lookup: response (CNAME): {}", (Object)data);
                return this.lookupWithType(resolver, data.replace("\"", ""), type);
            }
        }
        String data = qr.rdataToString();
        log.debug("DNS lookup: response: {}", (Object)data);
        return new LookupResponse(data, dnssec);
    }

    class LookupResponse {
        private final String data;
        private final boolean dnssec;

        LookupResponse(String data, boolean dnssec) {
            this.data = data;
            this.dnssec = dnssec;
        }

        String getData() {
            return this.data;
        }

        boolean isDnssec() {
            return this.dnssec;
        }
    }

    static class Id4meDnsDataWithLoginHint {
        private final Id4meDnsData dnsResponse;
        private final String loginHint;

        Id4meDnsDataWithLoginHint(Id4meDnsData dnsResponse, String loginHint) {
            this.dnsResponse = dnsResponse;
            this.loginHint = loginHint;
        }

        Id4meDnsData getDnsResponse() {
            return this.dnsResponse;
        }

        String getLoginHint() {
            return this.loginHint;
        }
    }
}

