/*
 * Decompiled with CFR 0.152.
 */
package org.id4me;

import org.id4me.Id4meClaimsConfig;
import org.id4me.config.Id4meClaimsParameters;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Id4meClaimsConfigParser {
    private static final Logger log = LoggerFactory.getLogger(Id4meClaimsConfigParser.class);

    private Id4meClaimsConfigParser() {
    }

    static Id4meClaimsConfig parseClaimsConfigJSON(String claimsConfigJSON) {
        JSONArray claims = new JSONArray(claimsConfigJSON);
        Id4meClaimsParameters parameters = new Id4meClaimsParameters();
        for (Object o : claims) {
            Id4meClaimsParameters.Entry entry = Id4meClaimsConfigParser.parseSingleClaim(o);
            if (entry == null) continue;
            parameters.addEntry(entry);
        }
        return new Id4meClaimsConfig(parameters);
    }

    private static Id4meClaimsParameters.Entry parseSingleClaim(Object o) {
        if (!(o instanceof JSONObject)) {
            log.error("Not a JSONObject: class: {}, value: {}", (Object)o.getClass().getName(), o);
            return null;
        }
        JSONObject claim = (JSONObject)o;
        if (!claim.has("name")) {
            log.error("Attribute 'name' missing in claim JSONObject: {}", (Object)claim);
            return null;
        }
        Id4meClaimsParameters.Entry entry = new Id4meClaimsParameters.Entry();
        entry.setName(claim.getString("name"));
        if (claim.has("essential")) {
            entry.setEssential(claim.getBoolean("essential"));
        }
        if (claim.has("reason")) {
            entry.setReason(claim.getString("reason"));
        }
        return entry;
    }
}

