/*
 * Decompiled with CFR 0.152.
 */
package org.id4me;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.id4me.Id4meIdentityAuthorityData;
import org.id4me.util.FileReader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Id4meIdentityAuthorityStorage2 {
    private static final Logger log = LoggerFactory.getLogger(Id4meIdentityAuthorityStorage2.class);
    private static final Map<String, Id4meIdentityAuthorityData> storage = new ConcurrentHashMap<String, Id4meIdentityAuthorityData>();
    public static final Id4meIdentityAuthorityStorage2 INSTANCE = new Id4meIdentityAuthorityStorage2();

    private Id4meIdentityAuthorityStorage2() {
    }

    boolean hasIauData(String iau) {
        return storage.containsKey(iau);
    }

    Id4meIdentityAuthorityData getIauData(Path authorityPath, String iau) throws IOException {
        Path path = this.buildIauFilePath(authorityPath, iau);
        if (storage.containsKey(path.toString())) {
            return storage.get(path.toString());
        }
        if (this.loadIauDataFromFile(authorityPath, iau)) {
            return storage.get(path.toString());
        }
        return null;
    }

    boolean loadIauDataFromFile(Path authorityPath, String iau) throws IOException {
        String json;
        Path path = this.buildIauFilePath(authorityPath, iau);
        if (path.toFile().exists() && (json = FileReader.readFileToString(path)).length() > 0) {
            JSONObject registrationJson = new JSONObject(json);
            Id4meIdentityAuthorityData data = storage.computeIfAbsent(path.toString(), k -> new Id4meIdentityAuthorityData());
            data.setIau(iau);
            data.setClientId(registrationJson.getString("client_id"));
            data.setClientSecret(registrationJson.getString("client_secret"));
            data.setRegistrationData(registrationJson);
            storage.put(path.toString(), data);
            return true;
        }
        return false;
    }

    void removeIauData(Path authorityPath, String iau) throws IOException {
        Path path = this.buildIauFilePath(authorityPath, iau);
        Files.deleteIfExists(path);
        storage.remove(path.toString());
    }

    Id4meIdentityAuthorityData saveRegistrationData(Path authorityPath, String iau, JSONObject registrationData) throws IOException {
        Path tmpPath = this.buildIauTmpFilePath(authorityPath, iau);
        Path path = this.buildIauFilePath(authorityPath, iau);
        this.ensurePathExists(tmpPath);
        log.info("Saving registration data in iau data file: {}", (Object)path);
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPath, new OpenOption[0]);){
            writer.write(registrationData.toString(2));
            ((Writer)writer).flush();
            Files.move(tmpPath, path, StandardCopyOption.ATOMIC_MOVE);
        }
        Id4meIdentityAuthorityData data = storage.get(path.toString());
        if (data == null) {
            data = new Id4meIdentityAuthorityData();
        }
        data.setIau(iau);
        data.setClientId(registrationData.getString("client_id"));
        data.setClientSecret(registrationData.getString("client_secret"));
        data.setRegistrationData(registrationData);
        storage.put(path.toString(), data);
        return data;
    }

    private void ensurePathExists(Path path) {
        Path parent = path.getParent();
        if (parent != null && !parent.toFile().exists()) {
            parent.toFile().mkdirs();
        }
    }

    private Path buildIauFilePath(Path authorityPath, String iau) {
        return authorityPath.resolve(iau + ".json");
    }

    private Path buildIauTmpFilePath(Path authorityPath, String iau) {
        return authorityPath.resolve(iau + ".json.tmp");
    }
}

