/*
 * Decompiled with CFR 0.152.
 */
package org.id4me;

import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.BoundedInputStream;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.id4me.Id4meClaimsConfig;
import org.id4me.Id4meClaimsConfigParser;
import org.id4me.Id4meDnsData;
import org.id4me.Id4meIdentityAuthorityData;
import org.id4me.Id4meIdentityAuthorityStorage2;
import org.id4me.Id4meKeyPairHandler;
import org.id4me.Id4meResolver;
import org.id4me.Id4meSessionData;
import org.id4me.config.Id4meClaimsParameters;
import org.id4me.config.Id4meProperties;
import org.id4me.exceptions.ClientNotRegisteredException;
import org.id4me.exceptions.ClientRegistrationSecretExpiredException;
import org.id4me.exceptions.MandatoryClaimsException;
import org.id4me.exceptions.TokenNotFoundException;
import org.id4me.exceptions.TokenValidationException;
import org.id4me.util.FileReader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Id4meLogon {
    private static final Logger log = LoggerFactory.getLogger(Id4meLogon.class);
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";
    private int MAX_FETCH_SIZE = 50000;
    private final Id4meIdentityAuthorityStorage2 storage = Id4meIdentityAuthorityStorage2.INSTANCE;
    private Id4meResolver resolver;
    private String clientName;
    private String redirectUri;
    private String[] redirectUris;
    private String logoUri;
    private Path registrationDataPath;
    private final Id4meClaimsConfig claimsConfig;
    private Id4meKeyPairHandler keyPairHandler;

    public Id4meLogon(String id4MePropertiesFile, String claimsParametersFile) throws Exception {
        this.readPropertiesFile(id4MePropertiesFile);
        this.claimsConfig = this.readClaimsParametersFile(claimsParametersFile);
        this.initSSLSocketFactory();
    }

    public Id4meClaimsConfig getClaimsConfig() {
        return this.claimsConfig;
    }

    public Id4meLogon(Id4meProperties id4meProperties, Id4meClaimsParameters claimsParameters) throws Exception {
        this.readProperties(id4meProperties);
        this.claimsConfig = new Id4meClaimsConfig(claimsParameters);
        this.initSSLSocketFactory();
    }

    private void initSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private void readPropertiesFile(String filename) throws Exception {
        Path path = Paths.get(filename, new String[0]);
        if (!path.toFile().exists()) {
            throw new Exception("Properties file " + path + " not found!");
        }
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            props.load(in);
        }
        if (props.containsKey("client.max_fetch_size")) {
            try {
                String mx = props.getProperty("client.max_fetch_size");
                this.MAX_FETCH_SIZE = Integer.parseInt(mx);
            }
            catch (Exception ex) {
                log.error("Error determining MAX_FETCH_SIZE from properties: " + ex.getMessage());
            }
        }
        if (!props.containsKey("client.name")) {
            throw new Exception("property client.name not found in " + path);
        }
        this.clientName = props.getProperty("client.name");
        if (!props.containsKey("redirect.uri")) {
            throw new Exception("property redirect.uri not found in " + path);
        }
        this.redirectUri = props.getProperty("redirect.uri");
        this.redirectUris = props.containsKey("redirect.uris") ? props.getProperty("redirect.uris").split(",") : new String[]{this.redirectUri};
        if (props.containsKey("logo.uri")) {
            this.logoUri = props.getProperty("logo.uri");
        }
        String rootKey = props.containsKey("dnssec_root_key") ? props.getProperty("dnssec_root_key") : (props.containsKey("dnsssec_root_key") ? props.getProperty("dnsssec_root_key") : ". IN DS 20326 8 2 E06D44B80B8F1D39A95C0B0D7C65D08458E880409BBC683457104237C7F8EC8D");
        boolean dnssecRequired = true;
        if (props.containsKey("dnssec_required")) {
            dnssecRequired = Boolean.parseBoolean(props.getProperty("dnssec_required"));
        }
        String dnsResolver = props.containsKey("dns.resolver") ? props.getProperty("dns.resolver") : "127.0.0.1";
        this.resolver = new Id4meResolver(dnsResolver, rootKey, dnssecRequired);
        this.registrationDataPath = props.containsKey("registration.data.path") ? Paths.get(props.getProperty("registration.data.path", null), new String[0]) : Paths.get("./", new String[0]);
        if (props.containsKey("pub_key") && props.containsKey("priv_key")) {
            this.keyPairHandler = new Id4meKeyPairHandler(props.getProperty("pub_key"), props.getProperty("priv_key"));
        }
        this.logProperties(rootKey, dnsResolver);
    }

    private void readProperties(Id4meProperties properties) throws Exception {
        if (properties.getMaxFetchSize() != null) {
            this.MAX_FETCH_SIZE = properties.getMaxFetchSize();
        }
        if (properties.getClientName() == null) {
            throw new Exception("Id4meProperties.clientName not set");
        }
        this.clientName = properties.getClientName();
        if (properties.getRedirectURI() == null) {
            throw new Exception("Id4meProperties.redirectURI not set");
        }
        this.redirectUri = properties.getRedirectURI();
        this.redirectUris = properties.getRedirectURIs() != null ? properties.getRedirectURIs() : new String[]{this.redirectUri};
        if (properties.getLogoURI() != null) {
            this.logoUri = properties.getLogoURI();
        }
        String rootKey = properties.getDnssecRootKey() != null ? properties.getDnssecRootKey() : ". IN DS 19036 8 2 49AAC11D7B6F6446702E54A1607371607A1A41855200FD2CE1CDDE32F24E8FB5";
        String dnsResolver = properties.getDnsResolver() != null ? properties.getDnsResolver() : "127.0.0.1";
        this.resolver = new Id4meResolver(dnsResolver, rootKey, properties.isDnssecRequired());
        if (properties.getRegistrationDataPath() != null) {
            String path = properties.getRegistrationDataPath();
            this.registrationDataPath = Paths.get(path, new String[0]);
        } else {
            this.registrationDataPath = Paths.get("./", new String[0]);
        }
        if (properties.getPrivKeyFile() != null && properties.getPubKeyFile() != null) {
            this.keyPairHandler = new Id4meKeyPairHandler(properties.getPubKeyFile(), properties.getPrivKeyFile());
        }
        this.logProperties(rootKey, dnsResolver);
    }

    private void logProperties(String rootKey, String dnsResolver) {
        log.info("Configured client name:     {}", (Object)this.clientName);
        log.info("Configured redirect URI:    {}", (Object)this.redirectUri);
        log.info("Configured redirect URIs:    {}", (Object)Arrays.toString(this.redirectUris));
        log.info("Configured logo URI:        {}", (Object)this.logoUri);
        log.info("Configured DNSSEC root key: {}", (Object)rootKey);
        log.info("Configured DNS resolver:    {}", (Object)dnsResolver);
        log.info("Configured registration data path: {}", (Object)this.registrationDataPath);
        if (this.keyPairHandler != null) {
            log.info("Configured keyPairHandler: {}", (Object)this.keyPairHandler.toString());
        }
    }

    private static String readFile(String filename) throws Exception {
        Path path = Paths.get(filename, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return FileReader.readFileToString(path);
        }
        throw new Exception("File not found: " + path);
    }

    private Id4meClaimsConfig readClaimsParametersFile(String filename) throws Exception {
        Path path = Paths.get(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new Exception("Claims configuration file " + path.toAbsolutePath() + " not found!");
        }
        String claimsConfigJSON = Id4meLogon.readFile(filename);
        return Id4meClaimsConfigParser.parseClaimsConfigJSON(claimsConfigJSON);
    }

    public Id4meSessionData createSessionData(String id4me, boolean autoRegisterClient) throws Exception {
        Id4meSessionData sessionData = new Id4meSessionData();
        sessionData.setId4me(id4me);
        Id4meResolver.Id4meDnsDataWithLoginHint dnsDataWithLoginHint = this.resolver.getDataFromDns(id4me);
        Id4meDnsData dnsData = dnsDataWithLoginHint.getDnsResponse();
        sessionData.setLoginHint(dnsDataWithLoginHint.getLoginHint());
        sessionData.setIau(dnsData.getIau());
        sessionData.setIag(dnsData.getIag());
        sessionData.setRedirectUri(URLEncoder.encode(this.redirectUri, UTF_8));
        sessionData.setLogoUri(URLEncoder.encode(this.logoUri, UTF_8));
        log.debug("Creating session data using login hint:   {}", (Object)dnsDataWithLoginHint.getLoginHint());
        log.debug("Creating session data using redirect URI: {}", (Object)this.redirectUri);
        log.debug("Creating session data using logo URI:     {}", (Object)this.logoUri);
        this.getIauData(sessionData, autoRegisterClient);
        return sessionData;
    }

    public boolean unsubscribeIau(Id4meSessionData sessionData) {
        String iau = sessionData.getIau();
        JSONObject registration = sessionData.getIauData().getRegistrationData();
        String registrationAccessToken = registration.getString("registration_access_token");
        String registrationClientUri = registration.getString("registration_client_uri");
        String authHeader = this.buildAuthHeader(registrationAccessToken);
        log.info("Unsubscribing IAU with registrationClientUri: {}", (Object)registrationClientUri);
        try {
            URL url = new URL(registrationClientUri);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("DELETE");
            con.setRequestProperty(CONTENT_TYPE, "application/json");
            con.setRequestProperty(AUTHORIZATION, authHeader);
            con.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.writeBytes("{}");
                wr.flush();
            }
            int responseCode = con.getResponseCode();
            log.info("Unsubscribing IAU response code: {}", (Object)responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                StringBuilder response = new StringBuilder();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                log.info("Unsubscribing IAU response: {}", (Object)response);
                this.storage.removeIauData(this.registrationDataPath, iau);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            log.error("Error unsubscribing IAU", (Object)ex.getMessage());
            return false;
        }
    }

    private JSONObject fetchJwtsData(Id4meSessionData sessionData) throws Exception {
        String jwtUri = sessionData.getIauData().getWellKnown().getString("jwks_uri");
        String jwts = this.fetchUrl(jwtUri);
        return new JSONObject(jwts);
    }

    public void doDynamicClientRegistration(Id4meSessionData sessionData) throws Exception {
        String iau = sessionData.getIau();
        log.info("Trying dynamic client registration for IAU: {}", (Object)iau);
        Id4meIdentityAuthorityData data = sessionData.getIauData();
        if (data == null) {
            throw new Exception("No iau data found in session for dynamic client registration!");
        }
        JSONObject well_known = data.getWellKnown();
        if (well_known == null) {
            throw new Exception("well-known data not found in session for dynamic client registration!");
        }
        JSONObject registrationData = this.getRegistrationData(sessionData);
        data = this.storage.saveRegistrationData(this.registrationDataPath, iau, registrationData);
        data.setWellKnown(well_known);
        sessionData.setIauData(data);
    }

    public String authorize(Id4meSessionData sessionData) throws UnsupportedEncodingException {
        String claimsParam = this.claimsConfig.getClaimsParam();
        claimsParam = URLEncoder.encode(claimsParam, UTF_8);
        Id4meIdentityAuthorityData data = sessionData.getIauData();
        JSONArray claims = sessionData.getIauData().getWellKnown().getJSONArray("claims_supported");
        log.debug("Authorizing: claims: {}", (Object)claims);
        String authorizeUri = data.getWellKnown().getString("authorization_endpoint") + "?response_type=code&claims=" + claimsParam + "&client_id=" + sessionData.getIauData().getClientId() + "&redirect_uri=" + sessionData.getRedirectUri() + "&scope=openid&state=" + sessionData.getState() + "&nonce=" + sessionData.getNonce() + "&login_hint=" + sessionData.getLoginHint();
        log.info("Authorizing: authorize URI: {}", (Object)authorizeUri);
        return authorizeUri;
    }

    public void authenticate(Id4meSessionData sessionData, String code) throws Exception {
        String type;
        JSONObject bearerToken = this.getToken(sessionData, code);
        log.info("Authenticating with token: {}", (Object)bearerToken);
        if (bearerToken.has("token_type") && !(type = bearerToken.getString("token_type")).equalsIgnoreCase("bearer")) {
            throw new TokenNotFoundException("Bearer token not found in response!");
        }
        String identityHandle = null;
        if (bearerToken.has("id_token")) {
            String id_token;
            block9: {
                id_token = bearerToken.getString("id_token");
                try {
                    EncryptedJWT jwt = EncryptedJWT.parse((String)id_token);
                    if (jwt.getIV() == null) break block9;
                    if (this.keyPairHandler != null) {
                        RSADecrypter decrypter = new RSADecrypter(this.keyPairHandler.getKeyPair().getPrivate());
                        jwt.decrypt((JWEDecrypter)decrypter);
                        id_token = jwt.getPayload().toString();
                        break block9;
                    }
                    throw new Exception("id token seem to be encrypted but no KeyPair found!");
                }
                catch (Exception ex) {
                    log.debug(ex.toString());
                }
            }
            sessionData.setIdToken(id_token);
            if (identityHandle == null) {
                identityHandle = this.identityHandleFromIdToken(sessionData, id_token);
            }
        }
        if (identityHandle == null && bearerToken.has("access_token")) {
            String access_token = bearerToken.getString("access_token");
            sessionData.setAccessToken(access_token);
            identityHandle = this.identityHandleFromAccessToken(sessionData, access_token);
        }
        if (identityHandle != null) {
            sessionData.setIdentityHandle(identityHandle);
        }
        sessionData.setBearerToken(bearerToken);
        sessionData.setUserinfo(sessionData.getAccessTokenUserinfo());
        if (sessionData.getUserinfo() == null) {
            sessionData.setUserinfo(sessionData.getIdTokenUserinfo());
        }
        sessionData.setTokenExpires(this.getExpired(bearerToken));
    }

    public Long getExpired(JSONObject token) {
        if (token.has("expires_in")) {
            long exp = token.getLong("expires_in");
            long expIn = System.currentTimeMillis() + exp * 1000L;
            log.debug("Authenticate: Set token to expire in {} sec", (Object)exp);
            return expIn;
        }
        return null;
    }

    public String identityHandleFromAccessToken(Id4meSessionData sessionData, String access_token) throws Exception {
        String identityHandle = null;
        String[] a_fields = access_token.split("\\.");
        switch (a_fields.length) {
            case 1: {
                log.info("AccessToken contains only a header");
                break;
            }
            case 2: {
                log.info("AccessToken contains header and payload");
                break;
            }
            case 3: {
                log.info("AccessToken contains header, payload and signature");
                SignedJWT signedToken = (SignedJWT)JWTParser.parse((String)access_token);
                JSONObject jwtsData = this.fetchJwtsData(sessionData);
                String payload = new String(Base64.getDecoder().decode(a_fields[1]));
                log.info("access_token payload: " + payload);
                this.validateSignedToken(jwtsData, signedToken);
                JSONObject userinfo = new JSONObject(signedToken.getPayload().toString());
                sessionData.setAccessTokenUserinfo(userinfo);
                if (!userinfo.has("iss") || !userinfo.has("sub")) break;
                identityHandle = userinfo.getString("iss") + "#" + userinfo.getString("sub");
                break;
            }
        }
        return identityHandle;
    }

    public String identityHandleFromIdToken(Id4meSessionData sessionData, String id_token) throws Exception {
        String identityHandle = sessionData.getIdentityHandle();
        String[] id_fields = id_token.split("\\.");
        switch (id_fields.length) {
            case 1: {
                log.info("IdToken contains only a header");
                break;
            }
            case 2: {
                log.info("IdToken contains header and payload");
                break;
            }
            case 3: {
                log.info("IdToken contains header, payload and signature");
                SignedJWT signedToken = (SignedJWT)JWTParser.parse((String)id_token);
                JSONObject jwtsData = this.fetchJwtsData(sessionData);
                String payload = new String(Base64.getDecoder().decode(id_fields[1]));
                log.info("id_token payload: " + payload);
                this.validateSignedToken(jwtsData, signedToken);
                this.validateIdTokenPayload(sessionData, signedToken);
                JSONObject userinfo = new JSONObject(signedToken.getPayload().toString());
                sessionData.setIdTokenUserinfo(userinfo);
                if (!userinfo.has("iss") || !userinfo.has("sub")) break;
                String identity = userinfo.getString("iss") + "#" + userinfo.getString("sub");
                if (identityHandle != null && !identity.equals(identityHandle)) {
                    throw new Exception("claims sub + iss from access_token and id_token are different!");
                }
                identityHandle = identity;
                break;
            }
        }
        return identityHandle;
    }

    public JSONObject userinfo(Id4meSessionData sessionData) throws Exception {
        JSONObject userinfo = this.getUserinfo(sessionData);
        if (userinfo.has("claims")) {
            String[] names;
            JSONObject json = new JSONObject();
            for (String n : names = JSONObject.getNames((JSONObject)userinfo)) {
                if (n.equals("claims")) continue;
                json.put(n, userinfo.get(n));
            }
            JSONObject claims = userinfo.getJSONObject("claims");
            for (String n : names = JSONObject.getNames((JSONObject)claims)) {
                json.put(n, claims.get(n));
            }
            userinfo = json;
        }
        this.checkMandatoryClaims(userinfo);
        sessionData.setUserinfo(userinfo);
        sessionData.setState("userinfo");
        return userinfo;
    }

    private void checkMandatoryClaims(JSONObject userinfo) throws MandatoryClaimsException {
        for (String claimName : this.claimsConfig.getEssentialClaims()) {
            if (userinfo.has(claimName)) continue;
            log.info("Mandatory claim \"{}\" not found in userinfo: {}", (Object)claimName, (Object)userinfo);
            throw new MandatoryClaimsException("Mandatory claim \"" + claimName + "\" not found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id4meSessionData registerClient(String id4me) throws Exception {
        Id4meSessionData sessionData = new Id4meSessionData();
        Id4meResolver.Id4meDnsDataWithLoginHint dnsDataWithLoginHint = this.resolver.getDataFromDns(id4me);
        Id4meDnsData dnsData = dnsDataWithLoginHint.getDnsResponse();
        sessionData.setLoginHint(dnsDataWithLoginHint.getLoginHint());
        sessionData.setIau(dnsData.getIau());
        sessionData.setIag(dnsData.getIag());
        sessionData.setRedirectUri(URLEncoder.encode(this.redirectUri, UTF_8));
        sessionData.setLogoUri(URLEncoder.encode(this.logoUri, UTF_8));
        Id4meIdentityAuthorityStorage2 id4meIdentityAuthorityStorage2 = this.storage;
        synchronized (id4meIdentityAuthorityStorage2) {
            String iau = sessionData.getIau();
            Id4meIdentityAuthorityData data = this.storage.getIauData(this.registrationDataPath, iau);
            String wellKnownUri = "https://" + iau + "/.well-known/openid-configuration";
            String wellKnownData = this.fetchUrl(wellKnownUri);
            JSONObject wellKnown = new JSONObject(wellKnownData);
            if (data == null) {
                data = new Id4meIdentityAuthorityData();
                data.setIau(iau);
                data.setWellKnown(wellKnown);
                sessionData.setIauData(data);
                this.doDynamicClientRegistration(sessionData);
            }
        }
        return sessionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIauData(Id4meSessionData sessionData, boolean autoRegisterClient) throws Exception {
        String iau = sessionData.getIau();
        log.info("Retrieving identity authority: {}", (Object)iau);
        Id4meIdentityAuthorityData data = this.storage.getIauData(this.registrationDataPath, iau);
        Id4meIdentityAuthorityStorage2 id4meIdentityAuthorityStorage2 = this.storage;
        synchronized (id4meIdentityAuthorityStorage2) {
            String wellKnownUri = "https://" + iau + "/.well-known/openid-configuration";
            String wellKnownData = this.fetchUrl(wellKnownUri);
            JSONObject wellKnown = new JSONObject(wellKnownData);
            log.info(wellKnown.toString(2));
            if (data == null) {
                if (autoRegisterClient) {
                    data = new Id4meIdentityAuthorityData();
                    data.setWellKnown(wellKnown);
                    sessionData.setIauData(data);
                    this.doDynamicClientRegistration(sessionData);
                    return;
                }
                throw new ClientNotRegisteredException("Client is not registered at " + iau);
            }
            log.info("Identity authority used: {}", (Object)iau);
            JSONObject registration = data.getRegistrationData();
            long client_secret_expires_at = registration.getLong("client_secret_expires_at");
            if (client_secret_expires_at != 0L) {
                long NOW = System.currentTimeMillis();
                long validity = client_secret_expires_at * 1000L - NOW;
                log.info("client_secret valid for : " + (double)validity * 0.001 + " seconds.");
                if (validity < 600000L) {
                    if (autoRegisterClient) {
                        this.storage.removeIauData(this.registrationDataPath, iau);
                        data = new Id4meIdentityAuthorityData();
                        data.setWellKnown(wellKnown);
                        sessionData.setIauData(data);
                        this.doDynamicClientRegistration(sessionData);
                        return;
                    }
                    throw new ClientRegistrationSecretExpiredException("Client registration secret is is expired at " + iau);
                }
            }
            data.setWellKnown(wellKnown);
            sessionData.setIauData(data);
        }
    }

    private String fetchUrl(String httpsUrl) throws IOException {
        URL url = new URL(httpsUrl);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        System.out.println("fetchUrl: " + con.getResponseCode() + ", " + con.getResponseMessage());
        BoundedInputStream bounded = new BoundedInputStream(con.getInputStream(), (long)this.MAX_FETCH_SIZE);
        StringBuilder response = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bounded));){
            String input;
            while ((input = br.readLine()) != null) {
                response.append(input);
            }
        }
        log.debug("Fetched from URL:          {}", (Object)httpsUrl);
        log.debug("Fetched from URL response: {}", (Object)response);
        return response.toString();
    }

    private JSONObject getRegistrationData(Id4meSessionData sessionData) throws Exception {
        JSONArray id_alg;
        Id4meIdentityAuthorityData data = sessionData.getIauData();
        String httpsUrl = data.getWellKnown().getString("registration_endpoint");
        URL url = new URL(httpsUrl);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty(CONTENT_TYPE, "application/json");
        con.setDoOutput(true);
        String[] redirectUrisLocal = new String[this.redirectUris.length];
        int i = 0;
        for (String string : this.redirectUris) {
            redirectUrisLocal[i++] = URLDecoder.decode(string, UTF_8);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("redirect_uris", (Object)redirectUrisLocal);
        jsonObject.put("client_name", (Object)this.clientName);
        if (this.logoUri != null && !"".equals(this.logoUri.trim())) {
            jsonObject.put("logo_uri", (Object)this.logoUri);
        }
        jsonObject.put("application_type", (Object)"web");
        if (this.keyPairHandler != null && (id_alg = data.getWellKnown().getJSONArray("id_token_encryption_alg_values_supported")).toList().contains("RSA-OAEP-256")) {
            data.getWellKnown().getJSONArray("id_token_encryption_enc_values_supported");
            jsonObject.put("id_token_encrypted_response_alg", (Object)"RSA-OAEP-256");
            JSONObject jwks = this.keyPairHandler.generateJwks();
            jsonObject.put("jwks", (Object)jwks);
        }
        String json = jsonObject.toString();
        log.info("Registration data request: {}", (Object)json);
        Throwable throwable = null;
        try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
            wr.writeBytes(json);
            wr.flush();
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        int responseCode = con.getResponseCode();
        String string = con.getResponseMessage();
        log.info("Registration data request response code: {}, message: {}", (Object)responseCode, (Object)string);
        if (responseCode == 200 || responseCode == 201) {
            StringBuilder response = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            JSONObject result = new JSONObject(response.toString());
            log.info("Registration data:\n{}", (Object)result.toString(2));
            return result;
        }
        throw new Exception("Error " + responseCode + " on url " + httpsUrl);
    }

    private JSONObject getToken(Id4meSessionData logonData, String code) throws Exception {
        Id4meIdentityAuthorityData data = logonData.getIauData();
        String httpsUrl = data.getWellKnown().getString("token_endpoint");
        String urlParameters = "grant_type=authorization_code&code=" + code + "&redirect_uri=" + logonData.getRedirectUri() + "&nonce=" + logonData.getNonce();
        String authorization = Base64.getEncoder().encodeToString((logonData.getIauData().getClientId() + ":" + logonData.getIauData().getClientSecret()).getBytes(UTF_8));
        URL url = new URL(httpsUrl);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty(CONTENT_TYPE, "application/x-www-form-urlencoded");
        con.setRequestProperty(AUTHORIZATION, "Basic " + authorization);
        con.setDoOutput(true);
        log.info("Get token: sending 'POST' request to URL: {} with parameters: {}", (Object)url, (Object)urlParameters);
        try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
            wr.writeBytes(urlParameters);
            wr.flush();
        }
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            StringBuilder response = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            log.info("Get token: Response: {}", (Object)response);
            JSONObject json = new JSONObject(response.toString());
            return json;
        }
        log.warn("Get token: Error response code: {}", (Object)responseCode);
        throw new Exception("Error " + responseCode + " on url " + httpsUrl);
    }

    private JSONObject getUserinfo(Id4meSessionData logonData) throws Exception {
        String name = "_443._tcp." + logonData.getIag() + ".";
        Id4meResolver.LookupResponse response = this.resolver.lookupDane(name);
        if (response != null) {
            log.info("TLSA lookup response: {} = \"{}\", DNSSEC = {}", new Object[]{name, response.getData(), response.isDnssec()});
        } else {
            log.info("TLSA lookup failed");
        }
        String httpsUrl = logonData.getIauData().getWellKnown().getString("userinfo_endpoint");
        String authorization = logonData.getAccessToken();
        String ret = this.fetchUserinfo(httpsUrl, authorization);
        JSONObject userinfo = ret.trim().indexOf(123) == 0 ? new JSONObject(ret) : this.getPayloadFromJwt(ret.trim());
        if (userinfo.has("_claim_sources") && userinfo.has("_claim_names")) {
            userinfo = this.getDistributedClaims(userinfo);
        }
        if (userinfo.has("error")) {
            if (userinfo.has("error_description")) {
                throw new Exception(userinfo.getString("error_description"));
            }
            throw new Exception(userinfo.toString(2));
        }
        return userinfo;
    }

    private JSONObject fetchAgentJwts(String host) throws Exception {
        String wellKnownUri = "https://" + host + "/.well-known/openid-configuration";
        String wellKnownData = this.fetchUrl(wellKnownUri);
        JSONObject wellKnown = new JSONObject(wellKnownData);
        String jwtUri = wellKnown.getString("jwks_uri");
        String jwts = this.fetchUrl(jwtUri);
        return new JSONObject(jwts);
    }

    private JSONObject getDistributedClaims(JSONObject json) throws Exception {
        String endpoint;
        JSONObject ep;
        JSONObject userinfo = new JSONObject();
        JSONObject claimSources = json.getJSONObject("_claim_sources");
        String[] sources = JSONObject.getNames((JSONObject)claimSources);
        Hashtable<String, JSONObject> agentJwts = new Hashtable<String, JSONObject>();
        for (String src : sources) {
            ep = claimSources.getJSONObject(src);
            endpoint = ep.getString("endpoint");
            URL url = new URL(endpoint);
            String host = url.getHost();
            if (!agentJwts.contains(host)) {
                JSONObject jwts_data = this.fetchAgentJwts(host);
                agentJwts.put(host, jwts_data);
                System.out.println("+" + host);
                System.out.println("+" + jwts_data.toString(2));
                continue;
            }
            System.out.println(host);
        }
        for (String src : sources) {
            String[] names;
            ep = claimSources.getJSONObject(src);
            endpoint = ep.getString("endpoint");
            String accessToken = ep.getString("access_token");
            URL url = new URL(endpoint);
            String host = url.getHost();
            log.debug("Get distributed claims: accessToken: {}", (Object)accessToken);
            log.debug("Get distributed claims: endpoint:    {}", (Object)endpoint);
            log.debug("Get distributed claims: host:    {}", (Object)host);
            String response = this.fetchUserinfo(endpoint, accessToken);
            SignedJWT signedToken = (SignedJWT)JWTParser.parse((String)response);
            JSONObject jwtsData = (JSONObject)agentJwts.get(host);
            System.out.println(signedToken.toString());
            this.validateSignedToken(jwtsData, signedToken);
            log.debug("Get distributed claims: response:    {}", (Object)response);
            JSONObject payload = response.startsWith("{") ? new JSONObject(response) : this.getPayloadFromJwt(response);
            for (String n : names = JSONObject.getNames((JSONObject)payload)) {
                userinfo.put(n, payload.get(n));
            }
        }
        return userinfo;
    }

    public JSONObject getPayloadFromJwt(String token) {
        JSONObject userinfo = null;
        try {
            if (token.indexOf(46) < 0) {
                return null;
            }
            String[] idFields = token.split("\\.");
            String header = new String(Base64.getDecoder().decode(idFields[0]));
            String payload = new String(Base64.getDecoder().decode(idFields[1]));
            if (idFields.length == 3) {
                // empty if block
            }
            log.info("Userinfo extracted from token: header:  {}", (Object)header);
            log.info("Userinfo extracted from token: payload: {}", (Object)payload);
            userinfo = new JSONObject(payload);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return userinfo;
    }

    private String fetchUserinfo(String httpsUrl, String accessToken) throws Exception {
        URL url = new URL(httpsUrl);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        String authHeader = this.buildAuthHeader(accessToken);
        con.setRequestProperty(AUTHORIZATION, authHeader);
        log.info("Fetch userinfo: URL:         {}", (Object)url);
        log.info("Fetch userinfo: authHeader:  {}", (Object)authHeader);
        int status_code = con.getResponseCode();
        if (status_code != 200) {
            String status_message = con.getResponseMessage();
            throw new Exception("Error " + status_code + ": " + status_message + ", " + httpsUrl);
        }
        InputStream in = con.getInputStream();
        StringBuilder response = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(in);
             BufferedReader br = new BufferedReader(reader);){
            String input;
            while ((input = br.readLine()) != null) {
                response.append(input);
            }
        }
        log.info("Fetch userinfo: response:    {}", (Object)response);
        return response.toString().trim();
    }

    private String buildAuthHeader(String authorization) {
        return "Bearer " + authorization;
    }

    private void validateSignedToken(JSONObject jwtsData, SignedJWT signedToken) throws Exception {
        log.debug("Validate signed token:          {}", (Object)signedToken.toString());
        JSONObject headerJson = new JSONObject(signedToken.getHeader().toString());
        JSONObject payloadJson = new JSONObject(signedToken.getPayload().toString());
        log.debug("Validate token: header:  {}", (Object)headerJson.toString());
        log.debug("Validate token: payload: {}", (Object)payloadJson.toString());
        String headerKid = null;
        if (headerJson.has("kid")) {
            headerKid = headerJson.getString("kid");
        }
        if (!headerJson.has("alg")) {
            throw new Exception("Field alg missing in token payload!");
        }
        String headerAlg = headerJson.getString("alg");
        if (!headerAlg.equalsIgnoreCase("RS256")) {
            throw new Exception("JWTS signature algorithm mismatch, expected RS256, found " + headerAlg);
        }
        this.validateTokenSignature(jwtsData, signedToken, headerKid, headerAlg);
    }

    private void validateTokenSignature(JSONObject jwtsData, SignedJWT signedToken, String headerKid, String headerAlg) throws Exception {
        JSONArray keys = jwtsData.getJSONArray("keys");
        if (keys == null || keys.length() <= 0) {
            throw new IllegalArgumentException("Error on validating the token, keys == NULL");
        }
        for (int i = 0; i < keys.length(); ++i) {
            JSONObject key = keys.getJSONObject(i);
            String kid = key.getString("kid");
            log.debug("Validating token signature: kid: {}", (Object)kid);
            if (headerKid != null && !kid.equals(headerKid)) continue;
            switch (headerAlg.toUpperCase()) {
                case "RS256": {
                    RSAKey rsa = RSAKey.parse((String)key.toString());
                    RSAPublicKey pubKey = (RSAPublicKey)rsa.toPublicKey();
                    RSASSAVerifier verifier = new RSASSAVerifier(pubKey);
                    if (signedToken.verify((JWSVerifier)verifier)) {
                        log.debug("Validating token signature: token RS256 signature valid");
                        return;
                    }
                    throw new Exception("Error on validating the token signature, kid=RS256, alg=RSA");
                }
            }
            throw new IllegalArgumentException("Unhandled value for header_alg: " + headerAlg);
        }
        throw new TokenValidationException("No valid public key for token validation found!");
    }

    private void validateStandardClaims(Id4meSessionData sessionData, JSONObject userinfo) throws Exception {
        String sessionAud;
        log.debug("Validate userinfo standard claims: ", (Object)userinfo.toString());
        if (!userinfo.has("nonce")) {
            throw new Exception("Field nonce missing!");
        }
        String tokenNonce = userinfo.getString("nonce");
        String sessionNonce = sessionData.getNonce();
        if (!sessionNonce.equals(tokenNonce)) {
            throw new Exception("Error on validating standard claims, the session nonce != nonce!");
        }
        if (!userinfo.has("exp")) {
            throw new Exception("Field exp missing!");
        }
        if (!userinfo.has("iss")) {
            throw new Exception("Field iss missing!");
        }
        String tokenIss = userinfo.getString("iss");
        String sessionIss = sessionData.getIauData().getWellKnown().getString("issuer");
        if (!sessionIss.equals(tokenIss)) {
            throw new Exception("Error on validating standard claims, the session iss != iss!");
        }
        if (!userinfo.has("sub")) {
            throw new Exception("Field sub missing!");
        }
        if (!userinfo.has("aud")) {
            throw new Exception("Field aud missing!");
        }
        Object aud = userinfo.get("aud");
        if (aud instanceof String && !(sessionAud = sessionData.getIauData().getRegistrationData().getString("client_id")).equals(aud)) {
            throw new Exception("Error on validating standard claims, the session audience != aud!");
        }
        if (!userinfo.has("iat")) {
            throw new Exception("Field iat missing!");
        }
    }

    private void validateIdTokenPayload(Id4meSessionData sessionData, SignedJWT signedToken) throws Exception {
        JSONObject payloadJson = new JSONObject(signedToken.getPayload().toString());
        log.debug("Validate Id token payload: ", (Object)payloadJson.toString());
        this.validateStandardClaims(sessionData, payloadJson);
        long exp = payloadJson.getLong("exp");
        long tokenExpiresMillis = exp * 1000L;
        log.debug("Validate Id token: token expiration threshold: {}", (Object)new Date(tokenExpiresMillis));
        if (System.currentTimeMillis() > tokenExpiresMillis) {
            throw new Exception("Token is expired!");
        }
        sessionData.setTokenExpires(tokenExpiresMillis);
        sessionData.setStandardClaimsValidated(true);
    }
}

