/*
 * Decompiled with CFR 0.152.
 */
package org.ifinal.finalframework.auto.coding.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.ifinal.finalframework.auto.coding.beans.PropertyDescriptor;
import org.ifinal.finalframework.auto.coding.beans.SetterAndGetterFilter;
import org.ifinal.finalframework.core.generator.NameGenerator;
import org.springframework.lang.NonNull;

public class Bean
implements Iterable<PropertyDescriptor> {
    static final String GET_PREFIX = "get";
    static final String SET_PREFIX = "set";
    static final String IS_PREFIX = "is";
    private static final Map<TypeElement, Bean> cache = new HashMap<TypeElement, Bean>(128);
    private final TypeElement typeElement;
    private final SetterAndGetterFilter setterAndGetterFilter;
    private final Map<String, VariableElement> fields = new LinkedHashMap<String, VariableElement>();
    private final List<ExecutableElement> methods = new ArrayList<ExecutableElement>();
    private final Map<ExecutableElement, Boolean> processed = new HashMap<ExecutableElement, Boolean>();
    private final Map<String, PropertyDescriptor> properties = new LinkedHashMap<String, PropertyDescriptor>();

    private Bean(ProcessingEnvironment env, TypeElement typeElement) {
        this.typeElement = typeElement;
        this.setterAndGetterFilter = new SetterAndGetterFilter(env);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bean from(ProcessingEnvironment env, TypeElement typeElement) {
        if (!cache.containsKey(typeElement)) {
            Map<TypeElement, Bean> map = cache;
            synchronized (map) {
                cache.put(typeElement, new Bean(env, typeElement));
            }
        }
        return cache.get(typeElement);
    }

    private void init() {
        List<? extends Element> elements = this.typeElement.getEnclosedElements();
        this.initFields(elements);
        this.initMethods(elements);
        this.initProperties();
    }

    private void initFields(List<? extends Element> elements) {
        ElementFilter.fieldsIn(elements).forEach(field -> this.fields.put(field.getSimpleName().toString(), (VariableElement)field));
    }

    private void initMethods(List<? extends Element> elements) {
        ElementFilter.methodsIn(elements).stream().filter(method -> this.setterAndGetterFilter.matches((ExecutableElement)method, null)).forEach(this.methods::add);
    }

    private void initProperties() {
        this.fields.forEach((? super K key, ? super V field) -> this.properties.put((String)key, new PropertyDescriptor(this, (String)key, Optional.of(field), this.findSetter((String)key), this.findGetter((String)key))));
        this.methods.stream().filter(it -> !Boolean.TRUE.equals(this.processed.get(it))).filter(this.setterAndGetterFilter::isSetter).forEach(setter -> {
            String propertyName;
            String setterName = setter.getSimpleName().toString();
            if (setterName.startsWith(SET_PREFIX) && !this.properties.containsKey(propertyName = setterName.substring(SET_PREFIX.length()))) {
                this.properties.put(propertyName, new PropertyDescriptor(this, propertyName, Optional.empty(), Optional.of(setter), this.findGetter(propertyName)));
            }
        });
        this.methods.stream().filter(it -> !Boolean.TRUE.equals(this.processed.get(it))).filter(this.setterAndGetterFilter::isGetter).forEach(getter -> {
            String propertyName;
            String getterName = getter.getSimpleName().toString();
            if (getterName.startsWith(IS_PREFIX)) {
                propertyName = NameGenerator.decapitalize((String)getterName, (String)IS_PREFIX);
            } else if (getterName.startsWith(GET_PREFIX)) {
                propertyName = NameGenerator.decapitalize((String)getterName, (String)GET_PREFIX);
            } else {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684 getter \u65b9\u6cd5" + getter.toString());
            }
            if (!this.properties.containsKey(propertyName)) {
                this.properties.put(propertyName, new PropertyDescriptor(this, propertyName, Optional.empty(), this.findSetter(propertyName), Optional.of(getter)));
            }
        });
    }

    private Optional<ExecutableElement> findSetter(String property) {
        String setterName = NameGenerator.capitalize((String)SET_PREFIX, (String)property);
        Optional<ExecutableElement> setter = this.methods.stream().filter(this.setterAndGetterFilter::isSetter).filter(it -> it.getSimpleName().toString().equals(setterName)).findFirst();
        setter.ifPresent(executableElement -> this.processed.put((ExecutableElement)executableElement, true));
        return setter;
    }

    private Optional<ExecutableElement> findGetter(String property) {
        Optional<ExecutableElement> getter = this.methods.stream().filter(this.setterAndGetterFilter::isGetter).filter(it -> it.getSimpleName().toString().equals(NameGenerator.capitalize((String)GET_PREFIX, (String)property))).findFirst();
        if (getter.isPresent()) {
            this.processed.put(getter.get(), true);
            return getter;
        }
        Optional<ExecutableElement> nextGetter = this.methods.stream().filter(this.setterAndGetterFilter::isGetter).filter(it -> it.getSimpleName().toString().equals(NameGenerator.capitalize((String)IS_PREFIX, (String)property))).findFirst();
        if (nextGetter.isPresent()) {
            this.processed.put(nextGetter.get(), true);
            return nextGetter;
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Iterator<PropertyDescriptor> iterator() {
        return this.properties.values().iterator();
    }

    public Stream<PropertyDescriptor> stream() {
        return this.properties.values().stream();
    }
}

