/*
 * Decompiled with CFR 0.152.
 */
package org.ifinal.finalframework.auto.coding.beans;

import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.ifinal.finalframework.auto.coding.beans.Bean;
import org.springframework.data.util.Lazy;

public class PropertyDescriptor {
    private final Bean bean;
    private final String name;
    private final Optional<VariableElement> field;
    private final Optional<ExecutableElement> setter;
    private final Optional<ExecutableElement> getter;
    private final Lazy<String> toString;

    public PropertyDescriptor(Bean bean, String name, Optional<VariableElement> field, Optional<ExecutableElement> setter, Optional<ExecutableElement> getter) {
        this.bean = bean;
        this.name = name;
        this.field = field;
        this.setter = setter;
        this.getter = getter;
        this.toString = Lazy.of(() -> {
            StringBuilder sb = new StringBuilder();
            sb.append(name).append(":{field=").append(field.map(e -> e.getSimpleName().toString()).orElse("")).append(",setter=").append(setter.map(e -> e.getSimpleName().toString()).orElse("")).append(",getter=").append(getter.map(e -> e.getSimpleName().toString()).orElse("")).append("}");
            return sb.toString();
        });
    }

    public Bean getBean() {
        return this.bean;
    }

    public String getName() {
        return this.name;
    }

    public Optional<VariableElement> getField() {
        return this.field;
    }

    public Optional<ExecutableElement> getSetter() {
        return this.setter;
    }

    public Optional<ExecutableElement> getGetter() {
        return this.getter;
    }

    public String toString() {
        return (String)this.toString.get();
    }
}

