/*
 * Decompiled with CFR 0.152.
 */
package org.ifinal.finalframework.auto.coding.beans;

import java.util.List;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetterAndGetterFilter {
    private static final Logger logger = LoggerFactory.getLogger(SetterAndGetterFilter.class);

    public SetterAndGetterFilter(ProcessingEnvironment env) {
    }

    public boolean matches(ExecutableElement method, TypeMirror parameterTypeOrReturnType) {
        List<? extends VariableElement> parameters;
        String name;
        if (method.getKind() != ElementKind.METHOD) {
            return false;
        }
        if (Objects.nonNull(parameterTypeOrReturnType)) {
            logger.info("try to check method parameterTypeOrReturnType");
        }
        return this.isSetter(name = method.getSimpleName().toString(), parameters = method.getParameters()) || this.isGetter(name, parameters);
    }

    public boolean isSetter(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        List<? extends VariableElement> parameters = method.getParameters();
        return this.isSetter(name, parameters);
    }

    public boolean isGetter(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        List<? extends VariableElement> parameters = method.getParameters();
        return this.isGetter(name, parameters);
    }

    private boolean isSetter(String name, List<? extends VariableElement> parameters) {
        return parameters.size() == 1 && name.startsWith("set");
    }

    private boolean isGetter(String name, List<? extends VariableElement> parameters) {
        return parameters.isEmpty() && (name.startsWith("get") || name.startsWith("is"));
    }
}

