/*
 * Decompiled with CFR 0.152.
 */
package org.ifinal.finalframework.auto.coding.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.springframework.lang.NonNull;

public final class TypeElements {
    private final Types types;
    private final Elements elements;
    private final Map<Class<?>, TypeElement> typeElementMap = new HashMap(16);
    private final Map<Class<?>, TypeMirror> elementTypes = new HashMap(16);

    public TypeElements(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
        this.init();
    }

    private void init() {
        Stream.of(LocalDateTime.class, LocalDate.class, LocalTime.class, Object.class).forEach(this::initTypeElements);
        this.elementTypes.put(Collection.class, this.types.getDeclaredType(this.elements.getTypeElement(Collection.class.getCanonicalName()), this.types.getWildcardType(null, null)));
        this.elementTypes.put(List.class, this.types.getDeclaredType(this.elements.getTypeElement(List.class.getCanonicalName()), this.types.getWildcardType(null, null)));
        this.elementTypes.put(Set.class, this.types.getDeclaredType(this.elements.getTypeElement(Set.class.getCanonicalName()), this.types.getWildcardType(null, null)));
        this.elementTypes.put(Map.class, this.types.getDeclaredType(this.elements.getTypeElement(Map.class.getCanonicalName()), this.types.getWildcardType(null, null), this.types.getWildcardType(null, null)));
    }

    private void initTypeElements(Class<?> type) {
        this.typeElementMap.put(type, this.elements.getTypeElement(type.getCanonicalName()));
    }

    public boolean isCollection(@NonNull Element element) {
        return this.isAssignable(element.asType(), this.elementTypes.get(Collection.class)) || this.isSubtype(element.asType(), this.elementTypes.get(Collection.class));
    }

    public boolean isList(@NonNull Element element) {
        return this.isAssignable(element.asType(), this.elementTypes.get(List.class)) || this.isSubtype(element.asType(), this.elementTypes.get(List.class));
    }

    public boolean isSet(@NonNull Element element) {
        return this.isAssignable(element.asType(), this.elementTypes.get(Set.class)) || this.isSubtype(element.asType(), this.elementTypes.get(Set.class));
    }

    public boolean isMap(@NonNull Element element) {
        return this.isAssignable(element.asType(), this.elementTypes.get(Map.class)) || this.isSubtype(element.asType(), this.elementTypes.get(Map.class));
    }

    public boolean isSameType(@NonNull Element element, @NonNull Class<?> target) {
        return this.isSameType(element, this.getTypeElement(target));
    }

    public boolean isSameType(@NonNull Element element, @NonNull Element target) {
        return this.isSameType(element.asType(), target.asType());
    }

    public boolean isSameType(@NonNull TypeMirror type, @NonNull TypeMirror target) {
        return this.types.isSameType(type, target);
    }

    public boolean isSubtype(@NonNull Element element, @NonNull Class<?> target) {
        return this.isSubtype(element, this.getTypeElement(target));
    }

    public boolean isSubtype(@NonNull Element element, @NonNull Element target) {
        return this.types.isSubtype(this.types.erasure(element.asType()), this.types.erasure(target.asType()));
    }

    public boolean isSubtype(@NonNull TypeMirror element, @NonNull TypeMirror target) {
        return this.types.isSubtype(element, target);
    }

    public boolean isObject(Element element) {
        return this.isSameType(element, Object.class);
    }

    public boolean isAssignable(@NonNull Element element, @NonNull Element target) {
        return this.isAssignable(this.types.erasure(element.asType()), this.types.erasure(target.asType()));
    }

    public boolean isAssignable(@NonNull TypeMirror type, @NonNull TypeMirror target) {
        return this.types.isAssignable(type, target);
    }

    public TypeElement getTypeElement(Class<?> type) {
        return this.typeElementMap.containsKey(type) ? this.typeElementMap.get(type) : this.elements.getTypeElement(type.getCanonicalName());
    }
}

