/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.query;

import java.util.Objects;
import org.springframework.lang.Nullable;

public final class CriterionExpression {
    private static final String DELIMITER = " ";
    private static final String CDATA_OPEN = "<![CDATA[ ";
    private static final String CDATA_CLOSE = " ]]>";
    private static final String AND_OR = "${andOr} ";
    private static final String TEST_VALUE_NOT_NULL = "${value} != null";
    private static final String FRAGMENT_JAVA_TYPE = "#if($javaType), javaType=$!{javaType.canonicalName}#end";
    private static final String FRAGMENT_TYPE_HANDLER = "#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end";
    private static final String FRAGMENT_VALUE = "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}";
    private static final String FRAGMENT_VALUE_MIN = "#{${value}.min#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}";
    private static final String FRAGMENT_VALUE_AMX = "#{${value}.max#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}";
    public static final String IS_NULL = CriterionExpression.expression(null, "${column} IS NULL");
    public static final String IS_NOT_NULL = CriterionExpression.expression(null, "${column} IS NOT NULL");
    public static final String EQUAL = CriterionExpression.expression("${value} != null", "${column} = ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    public static final String NOT_EQUAL = CriterionExpression.expression("${value} != null", "${column} != ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    public static final String GREAT_THAN = CriterionExpression.expression("${value} != null", "${column} > ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    public static final String GREAT_THAN_EQUAL = CriterionExpression.expression("${value} != null", "${column} >= ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    public static final String LESS_THAN = CriterionExpression.expression("${value} != null", "${column} < ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    public static final String LESS_THAN_EQUAL = CriterionExpression.expression("${value} != null", "${column} <= ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    private static final String TEST_BETWEEN_VALUE_NOT_NULL = "${value} != null and ${value}.min != null and ${value}.max != null";
    public static final String BETWEEN = CriterionExpression.expression("${value} != null and ${value}.min != null and ${value}.max != null", "${column} BETWEEN #{${value}.min", "#if($javaType), javaType=$!{javaType.canonicalName}#end", "#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end", "AND #{${value}.max", "#if($javaType), javaType=$!{javaType.canonicalName}#end", "#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end");
    public static final String NOT_BETWEEN = CriterionExpression.expression("${value} != null and ${value}.min != null and ${value}.max != null", "${column} NOT BETWEEN #{${value}.min", "#if($javaType), javaType=$!{javaType.canonicalName}#end", "#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end", "AND #{${value}.max", "#if($javaType), javaType=$!{javaType.canonicalName}#end", "#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end");
    private static final String TEST_LIKE_VALUE_NOT_NULL = "${value} != null and ${value} != ''";
    public static final String LIKE = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} LIKE #{${value}}");
    public static final String NOT_LIKE = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} NOT LIKE #{${value}}");
    public static final String START_WITH = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} LIKE CONCAT('%',#{${value}})");
    public static final String NOT_START_WITH = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} NOT LIKE CONCAT('%',#{${value}})");
    public static final String END_WITH = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} LIKE CONCAT(#{${value}},'%')");
    public static final String NOT_END_WITH = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} NOT LIKE CONCAT(#{${value}},'%')");
    public static final String CONTAINS = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} LIKE CONCAT('%',#{${value}},'%')");
    public static final String NOT_CONTAINS = CriterionExpression.expression("${value} != null and ${value} != ''", "${column} NOT LIKE CONCAT('%',#{${value}},'%')");
    public static final String IN = CriterionExpression.expression("${value} != null", "<foreach collection=\"${value}\" item=\"item\" open=\"${column} IN (\" close=\")\" separator=\",\">", "#{item}", "</foreach>");
    public static final String NOT_IN = CriterionExpression.expression("${value} != null", "<foreach collection=\"${value}\" item=\"item\" open=\"${column} NOT IN (\" close=\")\" separator=\",\">", "#{item}", "</foreach>");
    public static final String JSON_CONTAINS = CriterionExpression.expression("${value} != null", "JSON_CONTAINS( ${column},", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}", "       #if($path), '${path}'#end )");
    public static final String NOT_JSON_CONTAINS = CriterionExpression.expression("${value} != null", "!JSON_CONTAINS( ${column},", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}", "       #if($path), '${path}'#end )");
    public static final String UPDATE_SET = CriterionExpression.update("${value} != null", "${column} = ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    public static final String UPDATE_INCR = CriterionExpression.update("${value} != null", "${column} = ${column} + ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");
    public static final String UPDATE_DECR = CriterionExpression.update("${value} != null", "${column} = ${column} - ", "#{${value}#if($javaType), javaType=$!{javaType.canonicalName}#end#if($typeHandler), typeHandler=$!{typeHandler.canonicalName}#end}");

    private CriterionExpression() {
    }

    private static String expression(@Nullable String test, String ... fragments) {
        if (Objects.isNull(test)) {
            return "<![CDATA[ ${andOr} " + String.join((CharSequence)DELIMITER, fragments) + CDATA_CLOSE;
        }
        return "<if test=\"" + test + "\">" + CDATA_OPEN + AND_OR + String.join((CharSequence)DELIMITER, fragments) + CDATA_CLOSE + "</if>";
    }

    private static String update(String test, String ... fragments) {
        if (Objects.isNull(test)) {
            return CDATA_OPEN + String.join((CharSequence)DELIMITER, fragments) + "," + CDATA_CLOSE;
        }
        return "<if test=\"" + test + "\">" + CDATA_OPEN + String.join((CharSequence)DELIMITER, fragments) + "," + CDATA_CLOSE + "</if>";
    }
}

