/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.query;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.ifinalframework.query.Criteriable;
import org.ifinalframework.query.Criterion;
import org.ifinalframework.query.CriterionAttributes;
import org.ifinalframework.query.FunctionCriteriable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class CriterionTarget
implements FunctionCriteriable<Object> {
    private String column;
    private final CriterionAttributes criterion;

    private CriterionTarget(String column) {
        this.column = Objects.requireNonNull(column, "criterion column can not be null.");
        this.criterion = new CriterionAttributes();
    }

    public static CriterionTarget from(String column) {
        return new CriterionTarget(column);
    }

    @Override
    @NonNull
    public Criterion condition(@NonNull String expression, @Nullable Object value, @Nullable Consumer<CriterionAttributes> consumer) {
        this.criterion.setExpression(expression);
        this.criterion.setColumn(this.column);
        this.criterion.setValue(value);
        if (Objects.nonNull(consumer)) {
            consumer.accept(this.criterion);
        }
        return this.criterion;
    }

    @Override
    public Criteriable<Object> apply(@NonNull UnaryOperator<String> column, @Nullable Consumer<CriterionAttributes> consumer) {
        this.column = (String)column.apply(this.column);
        if (Objects.nonNull(consumer)) {
            consumer.accept(this.criterion);
        }
        return this;
    }
}

