/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.ifinalframework.core.Groupable;
import org.ifinalframework.core.Limitable;
import org.ifinalframework.core.Orderable;
import org.ifinalframework.core.Pageable;
import org.ifinalframework.query.Criteria;
import org.ifinalframework.query.Criterion;
import org.ifinalframework.query.Direction;
import org.ifinalframework.query.Order;
import org.ifinalframework.query.QProperty;
import org.springframework.lang.NonNull;

public class Query
implements Groupable,
Orderable,
Limitable,
Pageable {
    private final Criteria criteria = new Criteria();
    private Integer page;
    private Integer size;
    private Boolean count = Boolean.TRUE;
    private Long offset;
    private Long limit;
    private final List<String> orders = new LinkedList<String>();
    private final List<String> groups = new LinkedList<String>();

    public Query page(Integer page, Integer size) {
        this.page = page;
        this.size = size;
        return this;
    }

    public Query page(Integer page) {
        this.page = page;
        return this;
    }

    public Query size(Integer size) {
        this.size = size;
        return this;
    }

    public Query count(Boolean count) {
        this.count = count;
        return this;
    }

    public Query where(Criterion ... criteria) {
        return this.where(Arrays.asList(criteria));
    }

    public Query where(@NonNull Collection<Criterion> criteria) {
        this.criteria.addAll(criteria);
        return this;
    }

    public Query group(QProperty<?> ... properties) {
        return this.group(Arrays.asList(properties));
    }

    public Query group(Collection<QProperty<?>> properties) {
        properties.forEach(it -> this.groups.add(it.getColumn()));
        return this;
    }

    public Query sort(Order ... orders) {
        return this.sort(Arrays.asList(orders));
    }

    public Query sort(@NonNull Collection<Order> orders) {
        for (Order order : orders) {
            this.sort(order.getColumn(), order.getDirection());
        }
        return this;
    }

    public Query sort(@NonNull Direction direction, QProperty<?> ... properties) {
        for (QProperty<?> property : properties) {
            this.sort(property.getColumn(), direction);
        }
        return this;
    }

    public Query asc(QProperty<?> ... properties) {
        return this.sort(Direction.ASC, properties);
    }

    public Query desc(QProperty<?> ... properties) {
        return this.sort(Direction.DESC, properties);
    }

    private void sort(String column, Direction direction) {
        this.sort(String.format("%s %s", column, direction.name()));
    }

    private void sort(String order) {
        this.orders.add(order);
    }

    public Query limit(long offset, long limit) {
        this.offset = offset;
        this.limit = limit;
        return this;
    }

    public Query limit(long limit) {
        this.offset = null;
        this.limit = limit;
        return this;
    }

    @Generated
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Generated
    public void setPage(Integer page) {
        this.page = page;
    }

    @Generated
    public Integer getPage() {
        return this.page;
    }

    @Generated
    public void setSize(Integer size) {
        this.size = size;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public void setCount(Boolean count) {
        this.count = count;
    }

    @Generated
    public Boolean getCount() {
        return this.count;
    }

    @Generated
    public Long getOffset() {
        return this.offset;
    }

    @Generated
    public Long getLimit() {
        return this.limit;
    }

    @Generated
    public List<String> getOrders() {
        return this.orders;
    }

    @Generated
    public List<String> getGroups() {
        return this.groups;
    }
}

