/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.auto.service.processor;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;

public final class AnnotationValues {
    private static final BooleanAnnotationVisitor BOOLEAN_ANNOTATION_VISITOR = new BooleanAnnotationVisitor();

    private AnnotationValues() {
    }

    public static boolean getBoolean(AnnotationValue value) {
        return value.accept(BOOLEAN_ANNOTATION_VISITOR, null);
    }

    public static TypeElement getClass(AnnotationValue value) {
        return (TypeElement)((DeclaredType)value.getValue()).asElement();
    }

    private static class BooleanAnnotationVisitor
    extends AbsAnnotationValueVisitor<Boolean, Void> {
        private BooleanAnnotationVisitor() {
        }

        @Override
        public Boolean visitBoolean(boolean av, Void unused) {
            return av;
        }
    }

    protected static abstract class AbsAnnotationValueVisitor<R, P>
    extends AbstractAnnotationValueVisitor8<R, P> {
        protected AbsAnnotationValueVisitor() {
        }

        @Override
        public R visitBoolean(boolean b, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitByte(byte b, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitChar(char c, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitDouble(double d, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitFloat(float f, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitInt(int i, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitLong(long i, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitShort(short s, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitString(String s, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitType(TypeMirror t, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitEnumConstant(VariableElement c, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitAnnotation(AnnotationMirror a, P p) {
            throw new IllegalArgumentException("");
        }

        @Override
        public R visitArray(List<? extends AnnotationValue> vals, P p) {
            throw new IllegalArgumentException("");
        }
    }
}

