/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.auto.service.processor;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.ifinalframework.auto.service.processor.AbsServiceProcessor;
import org.ifinalframework.auto.service.processor.AnnotationMirrors;

@SupportedAnnotationTypes(value={"*"})
public class AutoServiceProcessor
extends AbsServiceProcessor {
    private static final String AUTO_SERVICE = "org.ifinalframework.auto.service.annotation.AutoService";
    private static final String KEY_VALUE = "value";
    private static final String KEY_NAME = "name";
    private static final String KEY_PATH = "path";
    private static final String KEY_IGNORE = "ignore";
    private static final IgnoreFilter ignoreFilter = new IgnoreFilter();

    @Override
    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<TypeElement> elements = ElementFilter.typesIn(roundEnv.getRootElements());
        elements.stream().filter(ignoreFilter).forEach(element -> {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (annotationMirror.getAnnotationType().toString().equals(AUTO_SERVICE)) {
                    this.processAutoService((TypeElement)element, annotationMirror);
                    continue;
                }
                List<? extends AnnotationMirror> mirrors = annotationMirror.getAnnotationType().asElement().getAnnotationMirrors();
                for (AnnotationMirror annotationMirror2 : mirrors) {
                    if (!annotationMirror2.getAnnotationType().toString().equals(AUTO_SERVICE)) continue;
                    this.processAutoService((TypeElement)element, annotationMirror2, annotationMirror);
                }
            }
        });
        return false;
    }

    private void processAutoService(TypeElement element, AnnotationMirror autoService) {
        this.processAutoService(element, autoService, null);
    }

    private void processAutoService(TypeElement element, AnnotationMirror autoService, AnnotationMirror targetService) {
        try {
            String name;
            Map<String, AnnotationValue> autoServiceValues = AnnotationMirrors.getAnnotationValues(autoService);
            Map<String, AnnotationValue> targetServiceValues = targetService == null ? null : AnnotationMirrors.getAnnotationValues(targetService);
            DeclaredType serviceInterface = (DeclaredType)autoServiceValues.get(KEY_VALUE).getValue();
            String path = autoServiceValues.containsKey(KEY_PATH) ? (String)autoServiceValues.get(KEY_PATH).getValue() : "services";
            String string = name = autoServiceValues.containsKey(KEY_NAME) ? (String)autoServiceValues.get(KEY_NAME).getValue() : null;
            if (targetServiceValues != null && targetServiceValues.containsKey(KEY_VALUE)) {
                name = (String)targetServiceValues.get(KEY_VALUE).getValue();
            }
            this.addService((TypeElement)serviceInterface.asElement(), element, name, path);
        }
        catch (Exception e) {
            this.error(e.getMessage(), element, autoService);
        }
    }

    private static class IgnoreFilter
    implements Predicate<TypeElement> {
        private IgnoreFilter() {
        }

        @Override
        public boolean test(TypeElement element) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                Map<String, AnnotationValue> autoServiceValues;
                AnnotationValue ignoreValue;
                if (!annotationMirror.getAnnotationType().toString().equals(AutoServiceProcessor.AUTO_SERVICE) || !Objects.nonNull(ignoreValue = (autoServiceValues = AnnotationMirrors.getAnnotationValues(annotationMirror)).get(AutoServiceProcessor.KEY_IGNORE))) continue;
                return Boolean.FALSE.equals(ignoreValue.getValue());
            }
            return true;
        }
    }
}

