/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.java11;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.net.ssl.SSLSession;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.util.LazyStringBuilder;
import org.jivesoftware.smack.websocket.impl.AbstractWebSocket;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;

public final class Java11WebSocket
extends AbstractWebSocket {
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().build();
    private WebSocket webSocket;

    Java11WebSocket(WebSocketRemoteConnectionEndpoint endpoint, ModularXmppClientToServerConnectionInternal connectionInternal) {
        super(endpoint, connectionInternal);
        WebSocket.Listener listener = new WebSocket.Listener(){
            LazyStringBuilder received = new LazyStringBuilder();

            @Override
            public void onOpen(WebSocket webSocket) {
                LOGGER.finer(String.valueOf(webSocket) + " opened");
                webSocket.request(1L);
            }

            @Override
            public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                this.received.append(data);
                webSocket.request(1L);
                if (last) {
                    String wholeMessage = this.received.toString();
                    this.received = new LazyStringBuilder();
                    Java11WebSocket.this.onIncomingWebSocketElement(wholeMessage);
                }
                return null;
            }

            @Override
            public void onError(WebSocket webSocket, Throwable error) {
                Java11WebSocket.this.onWebSocketFailure(error);
            }

            @Override
            public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                LOGGER.finer(String.valueOf(webSocket) + " closed with status code " + statusCode + ". Provided reason: " + reason);
                return null;
            }

            @Override
            public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
                this.logPingPong(PingPong.ping, webSocket, message);
                webSocket.request(1L);
                return null;
            }

            @Override
            public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
                this.logPingPong(PingPong.pong, webSocket, message);
                webSocket.request(1L);
                return null;
            }

            private void logPingPong(PingPong pingPong, WebSocket webSocket, ByteBuffer message) {
                Level pingPongLogLevel = Level.FINER;
                if (!LOGGER.isLoggable(pingPongLogLevel)) {
                    return;
                }
                LOGGER.log(pingPongLogLevel, "Received " + String.valueOf((Object)pingPong) + " over " + String.valueOf(webSocket) + ". Message: " + String.valueOf(message));
            }
        };
        URI uri = endpoint.getUri();
        CompletableFuture<WebSocket> webSocketFuture = HTTP_CLIENT.newWebSocketBuilder().subprotocols("xmpp", new String[0]).buildAsync(uri, listener);
        webSocketFuture.whenComplete((webSocket, throwable) -> {
            if (throwable == null) {
                this.webSocket = webSocket;
                this.future.setResult((Object)this);
            } else {
                this.onWebSocketFailure((Throwable)throwable);
            }
        });
    }

    protected void send(String element) {
        CompletableFuture<WebSocket> completableFuture = this.webSocket.sendText(element, true);
        try {
            completableFuture.get();
        }
        catch (ExecutionException e) {
            this.onWebSocketFailure(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void disconnect(int code, String message) {
        try {
            if (!this.webSocket.isOutputClosed()) {
                CompletableFuture<WebSocket> completableFuture = this.webSocket.sendClose(code, message);
                completableFuture.get();
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.WARNING, "Failed to send final close when disconnecting " + String.valueOf((Object)this), e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.webSocket.abort();
        }
    }

    public SSLSession getSSLSession() {
        return null;
    }

    private void onWebSocketFailure(ExecutionException executionException) {
        Throwable cause = executionException.getCause();
        this.onWebSocketFailure(cause);
    }

    static enum PingPong {
        ping,
        pong;

    }
}

