/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.redis.spring.boot.autoconfigure;

import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.iherus.shiro.cache.redis.config.DefaultPoolConfig;
import org.iherus.shiro.cache.redis.config.RedisClusterConfiguration;
import org.iherus.shiro.cache.redis.config.RedisSentinelConfiguration;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.jedis.JedisConnectionFactory;
import org.iherus.shiro.redis.spring.boot.autoconfigure.JedisSslClientConfiguration;
import org.iherus.shiro.redis.spring.boot.autoconfigure.JedisSslClientConfigurationCustomizer;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisConfigurationWrapper;
import org.iherus.shiro.redis.spring.boot.autoconfigure.RedisProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnClass(value={GenericObjectPool.class, Jedis.class})
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class JedisConnectionFactoryConfiguration
extends RedisConfigurationWrapper {
    private final RedisProperties properties;
    private final ObjectProvider<JedisSslClientConfigurationCustomizer> customizerProvider;

    protected JedisConnectionFactoryConfiguration(RedisProperties properties, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfigProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigProvider, ObjectProvider<JedisSslClientConfigurationCustomizer> customizerProvider) {
        super(properties, standaloneConfigProvider, sentinelConfigProvider, clusterConfigProvider);
        this.properties = properties;
        this.customizerProvider = customizerProvider;
    }

    @Bean(name={"x_jedisConnectionFactory"}, initMethod="init", destroyMethod="destroy")
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public JedisConnectionFactory connectionFactory() {
        return this.createJedisConnectionFactory();
    }

    private JedisConnectionFactory createJedisConnectionFactory() {
        GenericObjectPoolConfig poolConfig = this.createJedisPoolConfig(this.properties.getJedis().getPool());
        RedisSentinelConfiguration sentinelConfig = null;
        RedisClusterConfiguration clusterConfig = null;
        JedisConnectionFactory factory = null;
        sentinelConfig = this.getSentinelConfiguration();
        factory = sentinelConfig != null ? new JedisConnectionFactory(sentinelConfig, poolConfig) : ((clusterConfig = this.getClusterConfiguration()) != null ? new JedisConnectionFactory(clusterConfig, poolConfig) : new JedisConnectionFactory(this.getStandaloneConfiguration(), poolConfig));
        this.applyProperties(factory);
        return factory;
    }

    private void applyProperties(JedisConnectionFactory factory) {
        RedisProperties.JedisConfig jedisConfig = this.properties.getJedis();
        JedisSslClientConfiguration sslConfig = this.getJedisSslClientConfiguration();
        factory.setClientName(jedisConfig.getClientName());
        factory.setConnectTimeout(jedisConfig.getConnectTimeout());
        factory.setSoTimeout(jedisConfig.getSoTimeout());
        factory.setUseSsl(jedisConfig.isSsl());
        factory.setSslSocketFactory(sslConfig.getSslSocketFactory());
        factory.setSslParameters(sslConfig.getSslParameters());
        factory.setHostnameVerifier(sslConfig.getHostnameVerifier());
    }

    private JedisSslClientConfiguration getJedisSslClientConfiguration() {
        JedisSslClientConfiguration.Builder builder = JedisSslClientConfiguration.builder();
        this.customize(builder);
        return builder.build();
    }

    private GenericObjectPoolConfig createJedisPoolConfig(RedisProperties.Pool settingPoolConfig) {
        if (settingPoolConfig == null) {
            return new DefaultPoolConfig();
        }
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(settingPoolConfig.getMinIdle());
        config.setMaxIdle(settingPoolConfig.getMaxIdle());
        config.setMaxTotal(settingPoolConfig.getMaxTotal());
        config.setMaxWaitMillis(settingPoolConfig.getMaxWaitMillis());
        config.setTestOnBorrow(settingPoolConfig.isTestOnBorrow());
        config.setTestWhileIdle(settingPoolConfig.isTestWhileIdle());
        config.setMinEvictableIdleTimeMillis(settingPoolConfig.getMinEvictableIdleTimeMillis());
        config.setTimeBetweenEvictionRunsMillis(settingPoolConfig.getTimeBetweenEvictionRunsMillis());
        config.setNumTestsPerEvictionRun(settingPoolConfig.getNumTestsPerEvictionRun());
        return config;
    }

    private void customize(JedisSslClientConfiguration.Builder builder) {
        this.customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
    }
}

